/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.util.guice;

import com.ahsrcm.corp.cdl.CDLEntity;
import com.ahsrcm.corp.cdl.CDLFactory;
import com.ahsrcm.util.ByteBuffer;
import com.google.inject.Provider;
import com.thoughtworks.xstream.core.util.Base64Encoder;
import net.model3.bean.ReflectionTool;
import net.model3.bean.converters.AbstractGenericConverter;
import net.model3.bean.converters.Converter;

public class ProviderReflectionTool
implements Provider<ReflectionTool> {
    public ReflectionTool get() {
        ReflectionTool reflectionTool = new ReflectionTool();
        reflectionTool.getConverterFactory().addConverter((Converter)new AbstractGenericConverter<ByteBuffer>(){

            public ByteBuffer stringToValue(Class<?> clazz, String string) {
                return new ByteBuffer(new Base64Encoder().decode(string));
            }

            public String valueToString(ByteBuffer byteBuffer) {
                return new Base64Encoder().encode(byteBuffer.getBuffer());
            }
        });
        reflectionTool.getConverterFactory().addConverter((Converter)new AbstractGenericConverter<CDLEntity>(){

            public CDLEntity stringToValue(Class<?> clazz, String string) {
                return CDLFactory.get().getCDL(string);
            }

            public String valueToString(CDLEntity cDLEntity) {
                return cDLEntity.getEntityName();
            }
        });
        return reflectionTool;
    }
}

