/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.util;

import com.ahsrcm.corp.ScannedImage;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.ArrayList;
import java.util.Collection;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.ServiceUI;
import javax.print.SimpleDoc;
import javax.print.attribute.HashDocAttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;
import net.model3.collections.ListX;
import net.model3.imaging.Rotation;

public class PrintingService {
    public static void print(ScannedImage scannedImage) {
        PrintingService.print(ListX.create((Object[])new ScannedImage[]{scannedImage}));
    }

    public static void print(Collection<ScannedImage> collection) {
        try {
            HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
            DocFlavor.SERVICE_FORMATTED sERVICE_FORMATTED = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
            PrintService[] printServiceArray = PrintServiceLookup.lookupPrintServices(sERVICE_FORMATTED, hashPrintRequestAttributeSet);
            PrintService printService = PrintServiceLookup.lookupDefaultPrintService();
            PrintService printService2 = ServiceUI.printDialog(null, 200, 200, printServiceArray, printService, sERVICE_FORMATTED, hashPrintRequestAttributeSet);
            if (printService2 != null) {
                DocPrintJob docPrintJob = printService2.createPrintJob();
                ScannedImagesPrintable scannedImagesPrintable = new ScannedImagesPrintable(collection);
                HashDocAttributeSet hashDocAttributeSet = new HashDocAttributeSet();
                SimpleDoc simpleDoc = new SimpleDoc(scannedImagesPrintable, sERVICE_FORMATTED, hashDocAttributeSet);
                docPrintJob.print(simpleDoc, hashPrintRequestAttributeSet);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static class ScannedImagesPrintable
    implements Printable {
        private final ArrayList<ScannedImage> _scannedImage = new ArrayList();

        public ScannedImagesPrintable(Collection<ScannedImage> collection) {
            this._scannedImage.addAll(collection);
        }

        @Override
        public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
            if (n >= this._scannedImage.size()) {
                return 1;
            }
            ScannedImage scannedImage = this._scannedImage.get(n);
            if (scannedImage != null) {
                BufferedImage bufferedImage = scannedImage.getImageProxy().getImage(null, Rotation.NONE);
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
                int n2 = bufferedImage.getWidth();
                int n3 = bufferedImage.getHeight();
                double d = pageFormat.getImageableWidth() / (double)n2;
                double d2 = pageFormat.getImageableHeight() / (double)n3;
                graphics2D.scale(d, d2);
                AffineTransform affineTransform = AffineTransform.getTranslateInstance(pageFormat.getImageableX(), pageFormat.getImageableY());
                graphics2D.drawRenderedImage(bufferedImage, affineTransform);
                return 0;
            }
            return 1;
        }
    }
}

