/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.util;

import com.asprise.util.tiff.TIFFReader;
import com.google.inject.Inject;
import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.util.Properties;
import net.model3.guice.DependencyInjector;
import net.model3.guice.bootstrap.ConfigurationDirectory;
import net.model3.lang.ClassX;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.newfile.Directory;
import net.model3.newfile.File;

public class PixelChecker {
    private static final Logger logger = LoggerHelper.getLogger(PixelChecker.class);
    private int _inset;
    private int _brightnessThreshold;
    private int _largestBlackBlobThreshold;
    private static final int DEFAULT_INSET = 150;
    private static final int DEFAULT_BRIGHTNESS_THRESHOLD = 50;
    private static final int DEFAULT_LARGEST_BLACK_BLOB_THRESHOLD = 20;
    private ConfigurationDirectory _configurationDirectory;

    @Inject
    private PixelChecker(ConfigurationDirectory configurationDirectory) {
        this._configurationDirectory = configurationDirectory;
        this.loadConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadConfig() {
        Directory directory = (Directory)this._configurationDirectory.get();
        File file = directory.file("scanning.ini");
        Properties properties = new Properties();
        if (file.exists()) {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = file.createInputStream();
                properties.load(fileInputStream);
            }
            catch (Exception exception) {
                logger.error((Object)"Error loading properties for PixelChecker.", (Object)exception);
            }
            finally {
                try {
                    fileInputStream.close();
                }
                catch (Exception exception) {}
            }
        } else {
            try {
                properties.load(ClassX.getResourceAsStream((String)"scanning.ini"));
            }
            catch (Exception exception) {
                logger.error((Object)"Error loading properties for PixelChecker.", (Object)exception);
            }
        }
        if (properties.isEmpty()) {
            this._inset = 150;
            this._brightnessThreshold = 50;
            this._largestBlackBlobThreshold = 20;
        } else {
            logger.info((Object)"Property File Values | inset:{}  |  brightnessThreshold:{}  |  largestBlackBlobThreshold:{}", (Object)properties.getProperty("inset"), (Object)properties.getProperty("brightnessThreshold"), (Object)properties.getProperty("largestBlackBlobThreshold"));
            this._inset = Integer.valueOf(properties.getProperty("inset", "150"));
            this._brightnessThreshold = Integer.valueOf(properties.getProperty("brightnessThreshold", "50"));
            this._largestBlackBlobThreshold = Integer.valueOf(properties.getProperty("largestBlackBlobThreshold", "20"));
        }
    }

    public boolean isImageBlank(BufferedImage bufferedImage) {
        int n = this.getLargestPixel(bufferedImage);
        return n < this._largestBlackBlobThreshold;
    }

    private int getLargestPixel(BufferedImage bufferedImage) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        int[] nArray = new int[n * n2];
        bufferedImage.getRGB(0, 0, n, n2, nArray, 0, n);
        int n3 = this._inset;
        int n4 = n - n3;
        int n5 = n2 - n3;
        int n6 = 0;
        int n7 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            int n8 = i / n;
            int n9 = i % n;
            if (n9 < n3 || n9 > n4 || n8 > n5 || n8 < n3) {
                n6 = i;
                continue;
            }
            int n10 = nArray[i] & 0xFF;
            int n11 = nArray[i] & 0xFF;
            int n12 = nArray[i] & 0xFF;
            int n13 = Math.min(n10, Math.min(n11, n12));
            if (n13 < this._brightnessThreshold) {
                if (n7 >= i - n6) continue;
                n7 = i - n6;
                continue;
            }
            n6 = i;
        }
        logger.debug((Object)String.format("Longest run:%d", n7));
        return n7;
    }

    public static void test(File file) throws Exception {
        TIFFReader tIFFReader = new TIFFReader(file.asFile());
        for (int i = 0; i < 35; ++i) {
            System.out.println("******** Image " + i + " *********");
            BufferedImage bufferedImage = (BufferedImage)tIFFReader.getPage(i);
            PixelChecker pixelChecker = (PixelChecker)DependencyInjector.getInstance(PixelChecker.class);
            boolean bl = pixelChecker.isImageBlank(bufferedImage);
            System.out.println(bl);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        Directory directory = new Directory("/Users/flow/Downloads/EM-2026/test/tiffs/");
        for (File file : directory.files()) {
            System.out.println("testing file " + file.getCanonicalPath());
            TIFFReader tIFFReader = new TIFFReader(file.asFile());
            BufferedImage bufferedImage = (BufferedImage)tIFFReader.getPage(0);
            PixelChecker pixelChecker = (PixelChecker)DependencyInjector.getInstance(PixelChecker.class);
            boolean bl = pixelChecker.isImageBlank(bufferedImage);
            System.out.println(bl);
        }
    }
}

