/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.util;

import com.ahsrcm.scanning.device.JaiTiffReaderWriter;
import com.asprise.util.tiff.TIFFReader;
import com.sun.media.imageio.plugins.tiff.TIFFImageReadParam;
import com.sun.media.imageioimpl.plugins.tiff.TIFFImageReader;
import com.sun.media.jai.codec.FileSeekableStream;
import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageDecodeParam;
import com.sun.media.jai.codec.ImageDecoder;
import com.sun.media.jai.codec.SeekableStream;
import de.goto3d.freeimage4j.FreeImage;
import de.goto3d.freeimage4j.FreeImageException;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.Hashtable;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.stream.ImageInputStream;
import net.model3.newfile.Directory;
import net.model3.newfile.File;

public class MultipageTiffTest {
    public final String multipageTiff = "/test/01.tif";
    public final String testDirectory = "/test/" + System.currentTimeMillis();

    public static void main(String[] stringArray) throws IOException {
        MultipageTiffTest multipageTiffTest = new MultipageTiffTest();
        multipageTiffTest.doItFreeImage4j();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doitJAI() {
        System.out.println("******************** JAI *********************");
        ImageInputStream imageInputStream = null;
        try {
            TIFFImageReader tIFFImageReader = (TIFFImageReader)ImageIO.getImageReadersByFormatName("tiff").next();
            TIFFImageReadParam tIFFImageReadParam = (TIFFImageReadParam)tIFFImageReader.getDefaultReadParam();
            File file = new File("/test/01.tif");
            imageInputStream = ImageIO.createImageInputStream(file.asFile());
            tIFFImageReader.setInput((Object)imageInputStream);
            int n = tIFFImageReader.getNumImages(false);
            System.out.println("This TIF has " + n + " image(s)");
            JaiTiffReaderWriter jaiTiffReaderWriter = new JaiTiffReaderWriter();
            for (int i = 0; i < n; ++i) {
                BufferedImage bufferedImage = tIFFImageReader.read(i, (ImageReadParam)tIFFImageReadParam);
                Directory directory = new Directory(this.testDirectory);
                if (!directory.exists()) {
                    directory.makeDirectories();
                }
                File file2 = new File(this.testDirectory + "/jai" + i + ".tif");
                System.out.println("Saving " + file2.getCanonicalPath());
                jaiTiffReaderWriter.saveImage(bufferedImage, file2);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        finally {
            try {
                imageInputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    public void doItLikeApp() {
        try {
            TIFFImageReader tIFFImageReader = (TIFFImageReader)ImageIO.getImageReadersByFormatName("tiff").next();
            File file = new File("/test/01.tif");
            ImageInputStream imageInputStream = ImageIO.createImageInputStream(file.asFile());
            tIFFImageReader.setInput((Object)imageInputStream);
            int n = tIFFImageReader.getNumImages(true);
            System.out.println(String.format("Tiff file %s has %s pages.", file.getCanonicalPath(), n));
            JaiTiffReaderWriter jaiTiffReaderWriter = new JaiTiffReaderWriter();
            for (int i = 0; i < n; ++i) {
                BufferedImage bufferedImage = tIFFImageReader.read(i);
                Directory directory = new Directory(this.testDirectory);
                if (!directory.exists()) {
                    directory.makeDirectories();
                }
                File file2 = new File(this.testDirectory + "/app" + i + ".tif");
                System.out.println("Saving " + file2.getCanonicalPath());
                jaiTiffReaderWriter.saveImage(bufferedImage, file2);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doItAsprise() {
        System.out.println("******************** ASPRISE *********************");
        try {
            File file = new File("/test/01.tif");
            TIFFReader tIFFReader = new TIFFReader(file.asFile());
            int n = tIFFReader.countPages();
            JaiTiffReaderWriter jaiTiffReaderWriter = new JaiTiffReaderWriter();
            for (int i = 0; i < n; ++i) {
                RenderedImage renderedImage = tIFFReader.getPage(i);
                Directory directory = new Directory(this.testDirectory);
                if (!directory.exists()) {
                    directory.makeDirectories();
                }
                File file2 = new File(this.testDirectory + "/asprise" + i + ".tif");
                System.out.println("Saving " + file2.getCanonicalPath());
                jaiTiffReaderWriter.saveImage(this.convertRenderedImage(renderedImage), file2);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doItAsprise2() {
        System.out.println("******************** ASPRISE2 *********************");
        try {
            File file = new File("/test/01.tif");
            TIFFReader tIFFReader = new TIFFReader(file.asFile());
            JaiTiffReaderWriter jaiTiffReaderWriter = new JaiTiffReaderWriter();
            boolean bl = true;
            int n = -1;
            while (bl) {
                try {
                    System.out.println("Attempting to read image " + ++n);
                    RenderedImage renderedImage = tIFFReader.getPage(n);
                    Directory directory = new Directory(this.testDirectory);
                    if (!directory.exists()) {
                        directory.makeDirectories();
                    }
                    File file2 = new File(this.testDirectory + "/asprise" + n + ".tif");
                    System.out.println("Saving " + file2.getCanonicalPath());
                    jaiTiffReaderWriter.saveImage(this.convertRenderedImage(renderedImage), file2);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    System.out.println("Last image hit at " + n);
                    bl = false;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doItJAI2() {
        System.out.println("******************** JAI2 *********************");
        FileSeekableStream fileSeekableStream = null;
        try {
            File file = new File("/test/01.tif");
            fileSeekableStream = new FileSeekableStream(file.asFile());
            ImageDecodeParam imageDecodeParam = null;
            ImageDecoder imageDecoder = ImageCodec.createImageDecoder((String)"tiff", (SeekableStream)fileSeekableStream, imageDecodeParam);
            int n = imageDecoder.getNumPages();
            System.out.println("Number of images in this TIFF: " + n);
            JaiTiffReaderWriter jaiTiffReaderWriter = new JaiTiffReaderWriter();
            for (int i = 0; i < n; ++i) {
                RenderedImage renderedImage = imageDecoder.decodeAsRenderedImage(i);
                Directory directory = new Directory(this.testDirectory);
                if (!directory.exists()) {
                    directory.makeDirectories();
                }
                File file2 = new File(this.testDirectory + "/asprise" + i + ".tif");
                System.out.println("Saving " + file2.getCanonicalPath());
                jaiTiffReaderWriter.saveImage(this.convertRenderedImage(renderedImage), file2);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        finally {
            try {
                fileSeekableStream.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doItFreeImage4j() {
        System.out.println("******************** FreeImage4j *********************");
        try {
            File file = new File("/test/01.tif");
            FreeImage freeImage = null;
            try {
                freeImage = new FreeImage(file.asFile());
            }
            catch (FreeImageException freeImageException) {
                freeImageException.printStackTrace();
            }
            File file2 = new File("/test/newTiffFile.tif");
            file2.asFile().createNewFile();
            freeImage.save(file2.asFile());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public BufferedImage convertRenderedImage(RenderedImage renderedImage) {
        if (renderedImage instanceof BufferedImage) {
            return (BufferedImage)renderedImage;
        }
        ColorModel colorModel = renderedImage.getColorModel();
        int n = renderedImage.getWidth();
        int n2 = renderedImage.getHeight();
        WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(n, n2);
        boolean bl = colorModel.isAlphaPremultiplied();
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        String[] stringArray = renderedImage.getPropertyNames();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                hashtable.put(stringArray[i], renderedImage.getProperty(stringArray[i]));
            }
        }
        BufferedImage bufferedImage = new BufferedImage(colorModel, writableRaster, bl, hashtable);
        renderedImage.copyData(writableRaster);
        return bufferedImage;
    }
}

