/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.util;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Set;
import net.model3.collections.SetX;

public class LruCache<T> {
    final int _maxSize;
    final Set<T> _set = SetX.create();
    final Deque<T> _deque = new ArrayDeque<T>();

    public LruCache(int n) {
        this._maxSize = n;
    }

    public boolean contains(T t) {
        return this._set.contains(t);
    }

    public synchronized void add(T t) {
        if (this.contains(t)) {
            this.remove(t);
        }
        if (this._set.size() == this._maxSize) {
            T t2 = this._deque.removeFirst();
            this._set.remove(t2);
        }
        this._set.add(t);
        this._deque.add(t);
    }

    public synchronized void remove(T t) {
        this._set.remove(t);
        this._deque.remove(t);
    }

    public static <T> LruCache<T> create(int n) {
        return new LruCache<T>(n);
    }
}

