/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.util;

import com.ibm.as400.access.AS400Text;
import java.util.Map;
import net.model3.collections.MapX;

public class EbcdicHelper {
    private static final String NON_ALPHANUMERIC_CHARS = "`~!@#$%^&*()-_=+]}[{;:'\"\\|,<.>/?";
    private static final Map<Byte, String> _charMap;
    private static final AS400Text _converter;

    static void addChar(char c) {
        String string = String.valueOf(c);
        byte[] byArray = _converter.toBytes((Object)string);
        _charMap.put(byArray[0], string);
    }

    public static String arrayToHexDump(byte[] byArray) {
        int n = byArray.length;
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = null;
        for (int i = 0; i < n; ++i) {
            String string;
            if (i % 16 == 0) {
                if (i != 0) {
                    stringBuilder2.append("'");
                    stringBuilder.append(stringBuilder2.toString());
                    stringBuilder.append("\n");
                }
                stringBuilder2 = new StringBuilder(" '");
                string = Integer.toHexString(i);
                for (int j = string.length(); j < 4; ++j) {
                    stringBuilder.append(0);
                }
                stringBuilder.append(string);
                stringBuilder.append(" ");
            }
            if ((string = _charMap.get(byArray[i])) == null) {
                string = "~";
            }
            stringBuilder2.append(string);
            String string2 = Integer.toHexString(0xFF & byArray[i]);
            if (string2.length() == 1) {
                stringBuilder.append('0');
            }
            stringBuilder.append(string2);
            stringBuilder.append(" ");
            if (i != n - 1) continue;
            for (int j = i % 16 + 1; j < 16; ++j) {
                stringBuilder.append("  ");
            }
            stringBuilder2.append("'");
            stringBuilder.append(stringBuilder2.toString());
        }
        return stringBuilder.toString();
    }

    static String convertToPrintableChars(byte[] byArray, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            String string = _charMap.get(byArray[i]);
            if (string == null) {
                string = "?";
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    static {
        char c;
        _charMap = MapX.create();
        _converter = new AS400Text(1);
        for (c = 'a'; c <= 'z'; c = (char)((char)(c + 1))) {
            EbcdicHelper.addChar(c);
        }
        for (c = 'A'; c <= 'Z'; c = (char)((char)(c + 1))) {
            EbcdicHelper.addChar(c);
        }
        for (c = '0'; c <= '9'; c = (char)(c + '\u0001')) {
            EbcdicHelper.addChar(c);
        }
        for (char c2 : NON_ALPHANUMERIC_CHARS.toCharArray()) {
            EbcdicHelper.addChar(c2);
        }
    }
}

