/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.util;

import com.ahsrcm.corp.BaseBusinessBean;
import java.util.Set;
import net.java.dev.properties.IndexedProperty;
import net.model3.collections.SetX;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;

public class ChangeSet<T extends BaseBusinessBean<T>> {
    private static final Logger logger = LoggerHelper.getLogger();
    private final Set<T> _inserts = SetX.create();
    private final Set<T> _updates = SetX.create();
    private final Set<T> _deletes = SetX.create();
    private ChangeListener<T> _changeListener = new ChangeListener<T>(){

        @Override
        public void delete(T t) {
        }

        @Override
        public void insert(T t) {
        }

        @Override
        public void update(T t) {
        }
    };

    public void insert(T t) {
        logger.debug((Object)"inserting {}", t);
        this._inserts.add(t);
        this.normalizeEntries();
        this._changeListener.insert(t);
    }

    public void update(T t) {
        logger.debug((Object)"updating {}", t);
        this._updates.add(t);
        this.normalizeEntries();
        this._changeListener.update(t);
    }

    public void delete(T t) {
        logger.debug((Object)"deleting {}", t);
        this._deletes.add(t);
        this.normalizeEntries();
        this._changeListener.delete(t);
    }

    public Set<T> getInserts() {
        return this._inserts;
    }

    public Set<T> getDeletes() {
        return this._deletes;
    }

    public Set<T> getUpdates() {
        return this._updates;
    }

    public int size() {
        return this._inserts.size() + this._deletes.size() + this._updates.size();
    }

    public void clearAllChanges() {
        this._inserts.clear();
        this._updates.clear();
        this._deletes.clear();
    }

    private void normalizeEntries() {
        Set set = SetX.create(this._inserts);
        set.retainAll(this._deletes);
        this._inserts.removeAll(set);
        this._updates.removeAll(set);
        this._deletes.removeAll(set);
        this._updates.removeAll(this._deletes);
        this._updates.removeAll(this._inserts);
    }

    public void setChangeListener(ChangeListener<T> changeListener) {
        this._changeListener = changeListener;
    }

    public static <T extends BaseBusinessBean<T>> ChangeSet<T> create() {
        return new ChangeSet<T>();
    }

    public void revertChanges(IndexedProperty<T> indexedProperty) {
        this.normalizeEntries();
        for (BaseBusinessBean baseBusinessBean : this._inserts) {
            indexedProperty.remove((Object)baseBusinessBean);
        }
        for (BaseBusinessBean baseBusinessBean : this._deletes) {
            indexedProperty.add((Object)baseBusinessBean);
        }
        for (BaseBusinessBean baseBusinessBean : this._updates) {
            baseBusinessBean.refresh();
        }
    }

    public boolean hasNewRecords() {
        return 0 < this._inserts.size() - this._deletes.size();
    }

    public static interface ChangeListener<T> {
        public void insert(T var1);

        public void update(T var1);

        public void delete(T var1);
    }
}

