/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.util;

import com.ahsrcm.util.guice.Directories;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import net.model3.chrono.DateTime;
import net.model3.lang.AbstractComparable;
import net.model3.lang.TimeDuration;
import net.model3.logging.Log;
import net.model3.logging.LogHelper;
import net.model3.newfile.Directory;

@Singleton
public class CachePurger
implements Runnable {
    private static Log logger = LogHelper.getLog();
    private DateTime _cutoffDate = new DateTime().subtract(new TimeDuration("30 days"));
    @Inject
    Directories _directories;

    @Inject
    private CachePurger() {
    }

    @Override
    public void run() {
        try {
            this.pruneOldFiles(this._directories.thumbnails());
            this.pruneOldFiles(this._directories.companyCpt());
            this.pruneOldFiles(this._directories.imageRoot());
            this.pruneOldFiles(this._directories.config().subDirectory("logs"));
            this.pruneOldFiles(this._directories.config().subDirectory(".logs"), true);
        }
        catch (Exception exception) {
            logger.error((Object)"cache purger failed", (Object)exception);
        }
    }

    void pruneOldFiles(Directory directory) {
        this.pruneOldFiles(directory, true);
    }

    void pruneOldFiles(Directory directory, boolean bl) {
        if (!directory.exists()) {
            return;
        }
        for (Directory directory2 : directory.subDirectories()) {
            this.pruneOldFiles(directory2, false);
        }
        for (Directory directory2 : directory.files()) {
            if (!directory2.getLastModified().lessThan((AbstractComparable)this._cutoffDate)) continue;
            logger.debug((Object)"purging {}", (Object)directory2.getCanonicalPath());
            try {
                directory2.delete();
            }
            catch (Exception exception) {
                logger.debug((Object)"unable to delete file", (Object)exception);
            }
        }
        if (!bl && directory.files().size() == 0 && directory.subDirectories().size() == 0) {
            logger.debug((Object)"purging {}", (Object)directory.getCanonicalPath());
            try {
                directory.delete();
            }
            catch (Exception exception) {
                logger.debug((Object)"unable to delete directory", (Object)exception);
            }
        }
    }
}

