/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.util;

import codegen.CodegenMain;
import codegen.SourceHolder;
import com.ahsrcm.corp.beanprops.LazyMapProperty;
import com.ahsrcm.util.CoreGuiceModuleForTesting;
import com.google.inject.Module;
import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.Type;
import groovy.lang.Script;
import java.math.BigInteger;
import java.util.List;
import net.java.dev.properties.BaseProperty;
import net.java.dev.properties.IndexedProperty;
import net.java.dev.properties.RProperty;
import net.java.dev.properties.WProperty;
import net.java.dev.properties.jdbc.EntityPersister;
import net.java.dev.properties.jdbc.handlers.ColumnContext;
import net.model3.collections.ListX;
import net.model3.guice.DependencyInjector;
import net.model3.lang.ClassX;
import net.model3.lang.StringX;
import net.model3.newfile.Directory;

public class AhsCodeGen {
    protected Directory _ahsRoot = this.getAhsRoot();
    protected Directory _coreCore = this._ahsRoot.subDirectory("core/core");

    public static void main(String[] stringArray) {
        DependencyInjector.set((Module[])new Module[]{CoreGuiceModuleForTesting.create()});
        DependencyInjector.get();
        AhsCodeGen ahsCodeGen = new AhsCodeGen();
        ahsCodeGen.run();
    }

    public Directory getAhsRoot() {
        for (Directory directory = new Directory(".").getCanonical(); directory != null; directory = directory.getParent()) {
            if (!directory.subDirectory("incubator").exists() || !directory.subDirectory("infoedge").exists()) continue;
            return directory;
        }
        throw new RuntimeException("unable to find ahs root from " + new Directory(".").getCanonicalPath());
    }

    public List<Directory> getSourceDirectories() {
        return ListX.create((Object[])new Directory[]{new Directory("./src/main/java/com/ahsrcm/core/beans/"), new Directory("./src/main/java/com/ahsrcm/corp/"), new Directory("./src/main/java/com/ahsrcm/core/virtualmanager/"), new Directory("./src/main/java/com/ahsrcm/core/securesend/")});
    }

    public Directory getOutputDirectory() {
        return this._coreCore.subDirectory("src/main/java");
    }

    public Directory getBackupDirectory() {
        return this._ahsRoot.subDirectory("purgatory");
    }

    public void run() {
        CodegenMain codegenMain = new CodegenMain(){

            public void addScriptVariables(SourceHolder sourceHolder, Script script) {
                script.setProperty("ahsCodeGen", (Object)AhsCodeGen.this);
            }
        };
        codegenMain.addGroovyTemplate(this._coreCore.file("src/main/resources/template.groovy"));
        codegenMain.setBackupDirectory(this.getBackupDirectory());
        for (Directory directory : this.getSourceDirectories()) {
            codegenMain.getSourceDirectories().add(directory);
        }
        codegenMain.setOutputDirectory(this.getOutputDirectory());
        codegenMain.run();
    }

    public String getKeySig(EntityPersister<?> entityPersister) {
        StringBuilder stringBuilder = new StringBuilder();
        for (ColumnSig columnSig : this.getColumnSigs(entityPersister.getPrimaryKeyColumns())) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(columnSig.typeName);
            stringBuilder.append(" ");
            stringBuilder.append(columnSig.columnName);
        }
        return stringBuilder.toString();
    }

    public String getFetchSig(EntityPersister<?> entityPersister) {
        StringBuilder stringBuilder = new StringBuilder();
        for (ColumnSig columnSig : this.getColumnSigs(entityPersister.getPrimaryKeyColumns())) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(columnSig.columnName);
        }
        return stringBuilder.toString();
    }

    public List<ColumnSig> getColumnSigs(List<ColumnContext> list) {
        List list2 = ListX.create();
        for (ColumnContext columnContext : list) {
            list2.add(new ColumnSig(columnContext));
        }
        return list2;
    }

    public boolean isInstanceOf(Type type, Class<?> clazz) {
        if (type.getJavaClass() != null) {
            if (type.getJavaClass().getFullyQualifiedName().equals(clazz.getName())) {
                return true;
            }
            Type type2 = type.getJavaClass().getSuperClass();
            if (type2 != null && this.isInstanceOf(type2, clazz)) {
                return true;
            }
            for (Type type3 : type.getJavaClass().getImplements()) {
                if (!this.isInstanceOf(type3, clazz)) continue;
                return true;
            }
        }
        return false;
    }

    public String getPropertyTypeAsString(Type type) {
        if (this.isInstanceOf(type, IndexedProperty.class)) {
            return "java.util.List<" + this.getTypeAsString(type.getActualTypeArguments()[0]) + ">";
        }
        if (this.isInstanceOf(type, LazyMapProperty.class)) {
            return "java.util.Map<" + this.getTypeAsString(type.getActualTypeArguments()[0]) + "," + this.getTypeAsString(type.getActualTypeArguments()[1]) + ">";
        }
        return this.getTypeAsString(type.getActualTypeArguments()[0]);
    }

    public String getTypeAsString(Type type) {
        StringBuilder stringBuilder = new StringBuilder(type.getFullyQualifiedName());
        if (type.getActualTypeArguments() != null && type.getActualTypeArguments().length > 0) {
            stringBuilder.append("<");
            for (int i = 0; i < type.getActualTypeArguments().length; ++i) {
                if (i > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(this.getTypeAsString(type.getActualTypeArguments()[i]));
            }
            stringBuilder.append(">");
        }
        return stringBuilder.toString();
    }

    public String generateGettersAndSetters(SourceHolder sourceHolder) {
        List list = ListX.create();
        for (JavaField javaField : sourceHolder.getJavaClass().getFields()) {
            CharSequence charSequence;
            if (javaField.isStatic()) continue;
            boolean bl = this.isInstanceOf(javaField.getType(), BaseProperty.class);
            String string = bl ? this.getPropertyTypeAsString(javaField.getType()) : this.getTypeAsString(javaField.getType());
            String string2 = javaField.getName();
            String string3 = string2;
            if (string3.startsWith("_")) {
                string3 = string3.substring(1);
            }
            String string4 = Character.toUpperCase(string3.charAt(0)) + string3.substring(1);
            if (!(sourceHolder.hasGetterMethod(string3) || bl && !this.isInstanceOf(javaField.getType(), RProperty.class))) {
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append("public " + string + " get" + string4 + "() {\n");
                if (bl) {
                    ((StringBuilder)charSequence).append("    return " + string2 + ".get();\n");
                } else {
                    ((StringBuilder)charSequence).append("    return " + string2 + ";\n");
                }
                ((StringBuilder)charSequence).append("}\n");
                list.add(((StringBuilder)charSequence).toString());
            }
            if (sourceHolder.hasSetterMethod(string3) || bl && !this.isInstanceOf(javaField.getType(), WProperty.class)) continue;
            charSequence = string3 + "0";
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("public void set" + string4 + "(" + string + " " + (String)charSequence + ") {\n");
            if (bl) {
                stringBuilder.append("    " + string2 + ".set(" + (String)charSequence + ");\n");
            } else {
                stringBuilder.append("    " + string2 + " = " + (String)charSequence + ";\n");
            }
            stringBuilder.append("}\n");
            list.add(stringBuilder.toString());
        }
        return StringX.join((Iterable)list, (String)"\n");
    }

    public static class ColumnSig {
        String typeName;
        String columnName;

        ColumnSig(ColumnContext columnContext) {
            this.columnName = columnContext.getName().replace("#", "n");
            Class<Long> clazz = columnContext.getSqlType().getJavaType();
            if (clazz == BigInteger.class) {
                clazz = Long.class;
            }
            this.typeName = ClassX.getShortName(clazz);
        }
    }
}

