/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.scanning.rpc;

import com.ahsrcm.client.tools.rpc.RPCAction;
import com.ahsrcm.scanning.rpc.RPCClient;
import com.ahsrcm.util.UserContext;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.java.dev.properties.jdbc.CurrentSession;
import net.java.dev.properties.jdbc.Session;
import net.java.dev.properties.jdbc.SessionConfiguration;
import net.model3.lang.StopWatch;
import net.model3.lang.ThrowableX;
import net.model3.logging.Log;
import net.model3.logging.LogHelper;
import org.apache.log4j.NDC;

@Singleton
public class RPCServlet
extends HttpServlet {
    private static final Log logger = LogHelper.getLog();
    private static final long serialVersionUID = -6653607363560507968L;
    private SessionConfiguration _sessionConfiguration;
    @Inject
    UserContext _userContext;

    public SessionConfiguration getSessionConfiguration() {
        if (this._sessionConfiguration == null) {
            this._sessionConfiguration = CurrentSession.get().getConfig();
        }
        return this._sessionConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Object object;
        StopWatch stopWatch = new StopWatch();
        boolean bl = Boolean.valueOf(httpServletRequest.getHeader("X-gzipped"));
        try {
            RPCAction rPCAction = null;
            try {
                String string = "";
                if (this._userContext.getAuthenticator() != null) {
                    string = this._userContext.getAuthenticator().getUserLogin();
                }
                ServletInputStream servletInputStream = httpServletRequest.getInputStream();
                rPCAction = RPCClient.deserializeRPCAction((InputStream)servletInputStream, bl);
                NDC.push((String)("RPC=" + rPCAction.getName() + " user=" + string));
                Object object2 = rPCAction.execute();
                object = RPCClient.serializeObject(object2, bl);
                Session session = CurrentSession.get((boolean)false);
                if (session != null) {
                    session.commit();
                    session.close();
                }
            }
            catch (Exception exception) {
                object = RPCClient.serializeObject(ThrowableX.makeSafelySerializableException((Throwable)exception), bl);
                String string = "";
                if (rPCAction != null && rPCAction.getName() != null) {
                    string = rPCAction.getName();
                }
                logger.warn((Object)"execution completed with an exception for RPCAction={}", (Object)string, (Object)exception);
            }
            if (bl) {
                httpServletResponse.setHeader("X-gzipped", String.valueOf(true));
            }
            httpServletResponse.getOutputStream().write(object);
        }
        catch (Throwable throwable) {
            logger.debug((Object)"request completed in {}", (Object)stopWatch.stop());
            Session session = CurrentSession.get((boolean)false);
            if (session != null) {
                session.close();
            }
            NDC.pop();
            throw throwable;
        }
        logger.debug((Object)"request completed in {}", (Object)stopWatch.stop());
        object = CurrentSession.get((boolean)false);
        if (object != null) {
            object.close();
        }
        NDC.pop();
    }
}

