/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.scanning.rpc;

import com.ahsrcm.client.tools.ServerUrlProvider;
import com.ahsrcm.client.tools.SessionIdProvider;
import com.ahsrcm.client.tools.http.ServerUnavailableException;
import com.ahsrcm.client.tools.login.NotAuthorizedException;
import com.ahsrcm.client.tools.rpc.RPCAction;
import com.ahsrcm.client.tools.rpc.RPCClientInterface;
import com.ahsrcm.client.tools.rpc.RPCException;
import com.ahsrcm.client.tools.rpc.RPCStatusChecker;
import com.ahsrcm.core.util.DeployEdgeProperties;
import com.ahsrcm.scanning.rpc.BeanPropsObjectInputStream;
import com.ahsrcm.scanning.rpc.BeanPropsObjectOutputStream;
import com.ahsrcm.scanning.rpc.FlattenedBeanPropsObject;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.java.dev.properties.jdbc.CurrentSession;
import net.model3.io.IOHelper;
import net.model3.lang.ByteSize;
import net.model3.lang.StopWatch;
import net.model3.lang.Throughput;
import net.model3.lang.TimeDuration;
import net.model3.logging.Log;
import net.model3.logging.LogHelper;
import net.model3.net.UrlX;
import org.apache.commons.httpclient.URI;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.HttpClients;

@Singleton
public class RPCClient
implements RPCClientInterface {
    public static final String PARM_SESSION_ID = "sess";
    public static final String HEADER_GZIPPED = "X-gzipped";
    private static final Log logger = LogHelper.getLog();
    ThreadLocal<HttpClient> _client = new ThreadLocal();
    @Inject
    ServerUrlProvider _ServerUrlProvider;
    @Inject
    SessionIdProvider _sessionIdProvider;
    @Inject
    RPCStatusChecker _rpcStatusChecker;
    @Inject
    DeployEdgeProperties _deployedgeProperties;

    public String getServerUrl() {
        return ((UrlX)this._ServerUrlProvider.get()).getRootUrl() + "rpc";
    }

    public String getSessionId() {
        return (String)this._sessionIdProvider.get();
    }

    HttpClient getClient() {
        if (this._client.get() == null) {
            this._client.set((HttpClient)HttpClients.createDefault());
        }
        return this._client.get();
    }

    public RequestConfig getHttpRequestConfig() {
        return RequestConfig.custom().setConnectTimeout(30000).setSocketTimeout(this._deployedgeProperties.getHttpSocketTimeout().intValue()).build();
    }

    public <T> T execute(RPCAction rPCAction) throws RPCException {
        this._rpcStatusChecker.validateClientStatus();
        T t = null;
        try {
            t = this.postWithRetry(rPCAction, 5);
        }
        catch (Exception exception) {
            logger.warn((Object)("failure in remote action " + rPCAction.getName()), (Object)exception);
            if (exception instanceof ServerUnavailableException) {
                throw (ServerUnavailableException)exception;
            }
            if (exception instanceof NotAuthorizedException) {
                throw (NotAuthorizedException)exception;
            }
            throw new RuntimeException("Exception while executing remote action " + rPCAction.getClass().getName() + " at " + this.getServerUrl(), exception);
        }
        if (t instanceof Exception) {
            logger.warn((Object)("failure in remote action " + rPCAction.getName()), t);
            logger.warn((Object)("stack trace for previous exception " + rPCAction.getName()), (Object)new Exception());
            throw new RPCException("Exception while executing remote action " + rPCAction.getClass().getName() + " at " + this.getServerUrl(), (Throwable)((Exception)t));
        }
        logger.debug((Object)("successful remote action " + rPCAction.getName()));
        return t;
    }

    public <T> T postWithRetry(RPCAction rPCAction, int n) {
        Object object = null;
        try {
            StopWatch stopWatch = new StopWatch();
            logger.debug((Object)"executing remote action {}, retriesLeft {}", (Object)rPCAction.getName(), (Object)n);
            String string = this.getServerUrl() + "/" + rPCAction.getShortName() + "?" + PARM_SESSION_ID + "=" + this.getSessionId();
            URI uRI = new URI(string, true);
            HttpPost httpPost = new HttpPost(uRI.toString());
            byte[] byArray = this.serializeRPCAction(rPCAction);
            if (rPCAction.isGzippedPayload()) {
                httpPost.addHeader(HEADER_GZIPPED, String.valueOf(true));
                byArray = IOHelper.gzip((byte[])byArray);
            }
            httpPost.setEntity((HttpEntity)new ByteArrayEntity(byArray));
            httpPost.setConfig(this.getHttpRequestConfig());
            HttpResponse httpResponse = this.getClient().execute((HttpUriRequest)httpPost);
            int n2 = httpResponse.getStatusLine().getStatusCode();
            boolean bl = false;
            Header header = httpResponse.getFirstHeader(HEADER_GZIPPED);
            if (header != null) {
                bl = Boolean.valueOf(header.getValue());
            }
            byte[] byArray2 = IOHelper.readFully((InputStream)httpResponse.getEntity().getContent());
            ByteSize byteSize = new ByteSize((long)byArray2.length);
            if (bl) {
                byArray2 = IOHelper.gunzip((byte[])byArray2);
            }
            TimeDuration timeDuration = stopWatch.stop();
            Throughput throughput = new Throughput(byteSize, timeDuration);
            logger.debug(new Object[]{"remote action {}, completed in {} - {} - {}", rPCAction.getName(), timeDuration, byteSize, throughput});
            this._rpcStatusChecker.processHttpStatus(n2, byArray2);
            T t = this.deserializeResponse(byArray2);
            object = t instanceof FlattenedBeanPropsObject ? ((FlattenedBeanPropsObject)t).getEntity(CurrentSession.get().getConfig()) : (Object)t;
        }
        catch (Exception exception) {
            logger.warn((Object)("failure in remote action " + rPCAction.getName()), (Object)exception);
            if (exception instanceof ServerUnavailableException) {
                if (n > 0) {
                    int n3 = n - 1;
                    logger.warn((Object)"postWithRetry -- about to retry for the {} time", (Object)n3);
                    this.postWithRetry(rPCAction, n3);
                }
                logger.warn((Object)"postWithRetry -- no retries left");
                throw (ServerUnavailableException)exception;
            }
            if (exception instanceof NotAuthorizedException) {
                throw (NotAuthorizedException)exception;
            }
            throw new RuntimeException("Exception while executing remote action " + rPCAction.getClass().getName() + " at " + this.getServerUrl(), exception);
        }
        return (T)object;
    }

    public byte[] serializeRPCAction(RPCAction rPCAction) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            BeanPropsObjectOutputStream beanPropsObjectOutputStream = new BeanPropsObjectOutputStream(byteArrayOutputStream);
            beanPropsObjectOutputStream.writeObject(rPCAction);
            beanPropsObjectOutputStream.close();
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public <T> T deserializeResponse(byte[] byArray) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            BeanPropsObjectInputStream beanPropsObjectInputStream = new BeanPropsObjectInputStream(byteArrayInputStream);
            Object t = beanPropsObjectInputStream.readObject();
            beanPropsObjectInputStream.close();
            byteArrayInputStream.close();
            return t;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static RPCAction deserializeRPCAction(InputStream inputStream, boolean bl) {
        try {
            if (bl) {
                inputStream = new GZIPInputStream(inputStream);
            }
            BeanPropsObjectInputStream beanPropsObjectInputStream = new BeanPropsObjectInputStream(inputStream);
            return (RPCAction)beanPropsObjectInputStream.readObject();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static byte[] serializeObject(Object object, boolean bl) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            BeanPropsObjectOutputStream beanPropsObjectOutputStream = bl ? new BeanPropsObjectOutputStream(new GZIPOutputStream(byteArrayOutputStream)) : new BeanPropsObjectOutputStream(byteArrayOutputStream);
            beanPropsObjectOutputStream.writeObject(object);
            beanPropsObjectOutputStream.close();
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }
}

