/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.scanning.rpc;

import com.ahsrcm.client.tools.ServerUrlProvider;
import com.ahsrcm.scanning.rpc.UpStreamServerUrlProvider;
import com.ahsrcm.scanning.rpc.UpStreamServerUrlProviderImpl;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.Inet4Address;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.URLConnection;
import java.util.Collections;
import java.util.List;
import net.model3.collections.ListX;
import net.model3.guice.LifeCycleListeners;
import net.model3.guice.LifeCycleManager;
import net.model3.guice.Value;
import net.model3.guice.ValueChangedListener;
import net.model3.io.IOHelper;
import net.model3.lang.ExceptionPropagator;
import net.model3.lang.StringX;
import net.model3.lang.ThreadScheduler;
import net.model3.lang.TimeDuration;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.net.UrlX;

@Singleton
public class ProviderUpStreamUrlProviderForClient
implements Provider<UpStreamServerUrlProvider> {
    Logger logger = LoggerHelper.getLogger();
    @Inject
    ServerUrlProvider _serverUrlProvider;
    @Inject
    ThreadScheduler _scheduler;
    @Inject
    UpStreamServerUrlProviderImpl _upStreamServerUrlProviderImpl;
    @Inject
    LifeCycleManager _lifeCycleManager;
    List<UrlX> _cacheServersFromClientConfig = ListX.create();
    TimeDuration _cacheServerRecheckFrequency = new TimeDuration("5 minutes");
    TimeDuration _readTimeout = new TimeDuration("5 seconds");
    TimeDuration _connectTimeout = new TimeDuration("5 seconds");
    UrlX _activeCacheServer;

    public UpStreamServerUrlProvider get() {
        this._lifeCycleManager.register((LifeCycleListeners.LifeCycleListener)new LifeCycleListeners.Config(){

            public void configComplete() throws Exception {
                ProviderUpStreamUrlProviderForClient.this.scheduleChecks();
            }
        });
        this._serverUrlProvider.eventHandler().addListener((Object)new ValueChangedListener<UrlX>(){

            public void valueChanged(Value<UrlX> value, UrlX urlX, UrlX urlX2) {
                if (ProviderUpStreamUrlProviderForClient.this._activeCacheServer == null) {
                    ProviderUpStreamUrlProviderForClient.this._upStreamServerUrlProviderImpl.set(urlX2);
                }
            }
        });
        if (this._serverUrlProvider.get() != null) {
            this._upStreamServerUrlProviderImpl.set((UrlX)this._serverUrlProvider.get());
        }
        return this._upStreamServerUrlProviderImpl;
    }

    public void setCacheServersFromClientConfig(List<UrlX> list) {
        this.logger.debug((Object)"setCacheServersFromClientConfig() {}", (Object)StringX.join(list, (String)" "));
        this._cacheServersFromClientConfig = list;
    }

    void scheduleChecks() {
        this._scheduler.scheduleRepeating("cache-server-check", this._cacheServerRecheckFrequency, new Runnable(){

            @Override
            public void run() {
                ProviderUpStreamUrlProviderForClient.this.check();
            }
        });
    }

    void check() {
        UrlX urlX;
        this._activeCacheServer = urlX = this.getFirstValidCacheServer();
        if (urlX == null) {
            this._upStreamServerUrlProviderImpl.set((UrlX)this._serverUrlProvider.get());
        } else {
            this._upStreamServerUrlProviderImpl.set(urlX);
        }
    }

    List<String> getInterfaceAddresses() {
        try {
            List list = ListX.create();
            for (NetworkInterface networkInterface : Collections.list(NetworkInterface.getNetworkInterfaces())) {
                for (InterfaceAddress interfaceAddress : networkInterface.getInterfaceAddresses()) {
                    if (!(interfaceAddress.getAddress() instanceof Inet4Address)) continue;
                    list.add(interfaceAddress.getAddress().getHostAddress());
                }
            }
            return list;
        }
        catch (Exception exception) {
            throw ExceptionPropagator.throwUnchecked((Throwable)exception);
        }
    }

    boolean isValidCacheServer(UrlX urlX) {
        UrlX urlX2 = urlX.getRootUrl();
        try {
            UrlX urlX3 = urlX2.getRootUrl().subPath("api").subPath("images").subPath("ping");
            URLConnection uRLConnection = urlX3.asUrl().openConnection();
            uRLConnection.setConnectTimeout((int)this._connectTimeout.inMilliseconds());
            uRLConnection.setReadTimeout((int)this._readTimeout.inMilliseconds());
            uRLConnection.connect();
            InputStream inputStream = uRLConnection.getInputStream();
            String string = IOHelper.readFully((Reader)new InputStreamReader(inputStream));
            if (string.trim().toLowerCase().equals("pong")) {
                this.logger.debug((Object)"{} IS a valid cache server", (Object)urlX2);
                return true;
            }
            this.logger.debug((Object)"{} not a valid cache server response was {}", (Object)urlX2, (Object)string);
            return false;
        }
        catch (Exception exception) {
            this.logger.debug((Object)"{} is not a valid cache server", (Object)urlX2, (Object)exception);
            return false;
        }
    }

    UrlX getFirstValidCacheServer() {
        List list = ListX.create();
        list.addAll(this._cacheServersFromClientConfig);
        list.addAll(this.rpcGetCacheServers());
        this.logger.debug((Object)("getFirstValidCacheServer() trying " + StringX.join((Iterable)list, (String)" ")));
        for (UrlX urlX : list) {
            if (!this.isValidCacheServer(urlX)) continue;
            return urlX;
        }
        return null;
    }

    List<UrlX> rpcGetCacheServers() {
        String string = StringX.join(this.getInterfaceAddresses(), (String)":");
        UrlX urlX = new UrlX(((UrlX)this._serverUrlProvider.get()).subPath("api").subPath("images").subPath("getCacheServerUrl") + "?addresses=" + string);
        List list = ListX.create();
        String string2 = urlX.getContentAsString();
        this.logger.debug((Object)"rpcGetCacheServers() \n\trequest to {}\n\tresponse from {}", (Object)urlX, (Object)string2);
        for (String string3 : StringX.lines((String)urlX.getContentAsString())) {
            try {
                list.add(new UrlX(string3));
            }
            catch (Exception exception) {
                this.logger.debug((Object)exception);
            }
        }
        return list;
    }
}

