/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.scanning.rpc;

import com.ahsrcm.corp.BaseBusinessBean;
import com.ahsrcm.scanning.dao.ScanningDao;
import com.ahsrcm.scanning.rpc.FlattenedBeanPropsObject;
import com.ahsrcm.scanning.rpc.Inflater;
import com.google.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.java.dev.properties.RProperty;
import net.java.dev.properties.jdbc.SessionConfiguration;
import net.model3.collections.ListX;
import net.model3.collections.MapX;
import net.model3.guice.DependencyInjector;
import net.model3.io.IOHelper;
import net.model3.lang.StringX;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;

public class BeanPropsObjectInputStream {
    static final Logger logger = LoggerHelper.getLogger();
    Map<KeyWrapper, Object> _resolvedBeans = MapX.create();
    @Inject
    SessionConfiguration _sessionConfiguration;
    @Inject
    ScanningDao _dao;
    ObjectInputStream _ois;
    Inflater _inflater = new BeanPropsInflater();

    public BeanPropsObjectInputStream(InputStream inputStream) {
        try {
            this._ois = new ObjectInputStream(inputStream);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        DependencyInjector.inject((Object)this);
    }

    public <T> T readObject() {
        Inflater inflater = Inflater.get();
        try {
            Inflater.set(this._inflater);
            Object object = this._ois.readObject();
            return (T)object;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        finally {
            Inflater.set(inflater);
        }
    }

    public void close() {
        IOHelper.close((InputStream)this._ois);
    }

    String primaryKeysToString(List<Object[]> list) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("List{");
        for (Object[] objectArray : list) {
            stringBuilder.append("[");
            stringBuilder.append(StringX.join((Object[])objectArray, (String)","));
            stringBuilder.append("]");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    class KeyWrapper {
        final Class<?> _type;
        final Object[] _key;

        public KeyWrapper(Class<?> clazz, Object[] objectArray) {
            this._type = clazz;
            this._key = objectArray;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + this.getOuterType().hashCode();
            n = 31 * n + Arrays.hashCode(this._key);
            n = 31 * n + (this._type == null ? 0 : this._type.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            KeyWrapper keyWrapper = (KeyWrapper)object;
            if (!this.getOuterType().equals(keyWrapper.getOuterType())) {
                return false;
            }
            if (!Arrays.equals(this._key, keyWrapper._key)) {
                return false;
            }
            return !(this._type == null ? keyWrapper._type != null : !this._type.equals(keyWrapper._type));
        }

        public String toString() {
            return "[" + this._type.getName() + "," + StringX.join((Object[])this._key, (String)",") + "]";
        }

        private BeanPropsObjectInputStream getOuterType() {
            return BeanPropsObjectInputStream.this;
        }
    }

    class BeanPropsInflater
    extends Inflater {
        BeanPropsInflater() {
        }

        @Override
        public Object fetch(Class<?> clazz, Object ... objectArray) {
            KeyWrapper keyWrapper = new KeyWrapper(clazz, objectArray);
            if (BeanPropsObjectInputStream.this._resolvedBeans.containsKey(keyWrapper)) {
                logger.trace((Object)("fetch() from inflater -- " + clazz + " " + keyWrapper));
                return BeanPropsObjectInputStream.this._resolvedBeans.get(keyWrapper);
            }
            logger.trace((Object)("fetch() from dao -- " + clazz + " " + keyWrapper));
            return BeanPropsObjectInputStream.this._dao.fetch(clazz, objectArray);
        }

        @Override
        public List<Object> fetchBeanList(Class<?> clazz, List<Object[]> list) {
            logger.trace((Object)("fetchBeanList() " + clazz + " " + BeanPropsObjectInputStream.this.primaryKeysToString(list)));
            List list2 = ListX.create();
            for (Object[] object : list) {
                Object[] objectArray = new KeyWrapper(clazz, object);
                if (BeanPropsObjectInputStream.this._resolvedBeans.containsKey(objectArray)) continue;
                list2.add(object);
            }
            if (!list2.isEmpty()) {
                for (BaseBusinessBean baseBusinessBean : BeanPropsObjectInputStream.this._dao.fetchBeanList(clazz, list2)) {
                    BeanPropsObjectInputStream.this._resolvedBeans.put(new KeyWrapper(clazz, baseBusinessBean.getPrimaryKey()), baseBusinessBean);
                }
            }
            Iterator<?> iterator = ListX.create();
            for (Object[] objectArray : list) {
                iterator.add((Object)BeanPropsObjectInputStream.this._resolvedBeans.get(new KeyWrapper(clazz, objectArray)));
            }
            return iterator;
        }

        @Override
        public Object fetchProperty(RProperty<?> rProperty) {
            return BeanPropsObjectInputStream.this._dao.fetchProperty(rProperty);
        }

        @Override
        public Object readResolve(FlattenedBeanPropsObject flattenedBeanPropsObject) {
            Object object = flattenedBeanPropsObject.getEntity(BeanPropsObjectInputStream.this._sessionConfiguration);
            KeyWrapper keyWrapper = new KeyWrapper(flattenedBeanPropsObject.getType(), flattenedBeanPropsObject.getPrimaryKey());
            BeanPropsObjectInputStream.this._resolvedBeans.put(keyWrapper, object);
            return object;
        }
    }
}

