/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.scanning.printing;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.util.Locale;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.attribute.HashDocAttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.DocumentName;
import javax.print.attribute.standard.Fidelity;
import javax.print.attribute.standard.MediaPrintableArea;
import net.model3.imaging.ImageUtils;
import net.model3.logging.Log;
import net.model3.logging.LogHelper;
import net.model3.logging.SimpleLoggingConfigurator;
import net.model3.newfile.File;

public class PrintDriverThread {
    private static final Log LOG = LogHelper.getLog();

    public void print(File file) throws Exception {
        LOG.debug((Object)("printing " + file.getName()));
        PrintMe printMe = new PrintMe(file);
        HashDocAttributeSet hashDocAttributeSet = new HashDocAttributeSet();
        hashDocAttributeSet.add(new DocumentName(file.getName(), Locale.getDefault()));
        SimpleDoc simpleDoc = new SimpleDoc(printMe, DocFlavor.SERVICE_FORMATTED.PRINTABLE, hashDocAttributeSet);
        PrintService printService = PrintServiceLookup.lookupDefaultPrintService();
        DocPrintJob docPrintJob = printService.createPrintJob();
        HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
        hashPrintRequestAttributeSet.add(Fidelity.FIDELITY_TRUE);
        PrintDriverThread.setPrintableArea(printService, hashPrintRequestAttributeSet);
        docPrintJob.print(simpleDoc, hashPrintRequestAttributeSet);
    }

    private static void setPrintableArea(PrintService printService, PrintRequestAttributeSet printRequestAttributeSet) {
        MediaPrintableArea[] mediaPrintableAreaArray = (MediaPrintableArea[])printService.getSupportedAttributeValues(MediaPrintableArea.class, null, null);
        for (int i = 0; i < mediaPrintableAreaArray.length; ++i) {
            MediaPrintableArea mediaPrintableArea = mediaPrintableAreaArray[i];
            double d = mediaPrintableArea.getWidth(25400);
            double d2 = mediaPrintableArea.getHeight(25400);
            LOG.debug((Object)"MediaPrintableArea {}x{}", (Object)d, (Object)d2);
            if (d != 8.5 || d2 != 11.0) continue;
            printRequestAttributeSet.add(mediaPrintableArea);
            return;
        }
        throw new RuntimeException("no media printable area found");
    }

    public static void main(String[] stringArray) throws Exception {
        new SimpleLoggingConfigurator().addConsoleAppender();
        PrintDriverThread printDriverThread = new PrintDriverThread();
        printDriverThread.print(new File("images/8x11-300dpi-bnw.jpg"));
    }

    class PrintMe
    implements Printable {
        private File imageFile_;

        PrintMe(File file) {
            this.imageFile_ = file;
        }

        @Override
        public int print(Graphics graphics, PageFormat pageFormat, int n) {
            if (n != 0) {
                return 1;
            }
            double d = pageFormat.getImageableX();
            double d2 = pageFormat.getImageableY();
            double d3 = pageFormat.getImageableHeight();
            double d4 = pageFormat.getImageableWidth();
            switch (pageFormat.getOrientation()) {
                case 1: {
                    break;
                }
                default: {
                    throw new RuntimeException("unsupported page orienation " + pageFormat.getOrientation());
                }
            }
            BufferedImage bufferedImage = ImageUtils.loadImage((File)this.imageFile_);
            if (bufferedImage.getWidth() > bufferedImage.getHeight()) {
                BufferedImage bufferedImage2 = bufferedImage;
                bufferedImage = ImageUtils.createRotatedImage((Image)bufferedImage);
                bufferedImage2.flush();
            }
            int n2 = (int)d4;
            int n3 = (int)d3;
            int n4 = (int)d;
            int n5 = (int)d2;
            graphics.drawImage(bufferedImage, n4, n5, n2, n3, null);
            bufferedImage.flush();
            return 0;
        }
    }
}

