/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.scanning.device;

import com.ahsrcm.scanning.device.ImageReaderWriter;
import com.ahsrcm.scanning.device.JaiTiffReaderWriter;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import net.model3.imaging.ImageUtils;
import net.model3.imaging.Size;
import net.model3.io.IOHelper;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.newfile.File;

public class TextToTiffCopier {
    static final Logger logger = LoggerHelper.getLogger();
    int _pixelsPerInch = 150;
    double _widthInInches = 8.5;
    double _heightInInches = 11.0;
    int _columns = 80;
    int _rows = 66;
    Size _imageSize = new Size((int)((double)this._pixelsPerInch * this._widthInInches), (int)((double)this._pixelsPerInch * this._heightInInches));
    ImageReaderWriter _imageReaderWriter = new JaiTiffReaderWriter();

    public void outputPages(List<Page> list) {
        for (Page page : list) {
            this.outputPage(page);
        }
    }

    void convertToImage(File file) {
        logger.debug((Object)"processing {}", (Object)file);
        int n = 1;
        for (Page page : this.getPages(IOHelper.readFully((Reader)file.createReader()), "xyzpdq")) {
            page.outputFile = new File(file.getCanonicalPath() + ".p" + n + ".tiff");
            this.outputPage(page);
            ++n;
        }
    }

    private void outputPage(Page page) {
        BufferedImage bufferedImage = ImageUtils.createOpaqueImage((Size)this._imageSize);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        this.setFont(graphics2D);
        graphics2D.setColor(Color.WHITE);
        graphics2D.fillRect(0, 0, this._imageSize.getWidth(), this._imageSize.getHeight());
        graphics2D.setColor(Color.BLACK);
        int n = graphics2D.getFontMetrics().getHeight();
        int n2 = 0;
        for (String string : page.lines) {
            graphics2D.drawString(string, 10, n2 += n);
        }
        graphics2D.dispose();
        this._imageReaderWriter.saveImage(bufferedImage, page.outputFile);
        bufferedImage.flush();
    }

    public List<Page> getPages(String string, String string2) {
        Object object2;
        StringReader stringReader = new StringReader(string);
        ArrayList<Page> arrayList = new ArrayList<Page>();
        ArrayDeque<Object> arrayDeque = new ArrayDeque<Object>();
        arrayDeque.add("HL7 Accession #: " + string2);
        boolean bl = false;
        for (Object object2 : IOHelper.readLines((Reader)stringReader)) {
            if (!bl && this.isReportStart((String)object2)) {
                bl = true;
                if (((String)object2).startsWith("OBX|1|TX|||")) {
                    object2 = ((String)object2).substring("OBX|1|TX|||".length());
                }
            } else if (bl && this.isReportEnd((String)object2)) {
                bl = false;
            }
            if (!bl) continue;
            while (((String)object2).length() > this._columns) {
                arrayDeque.add(((String)object2).substring(0, this._columns));
                object2 = ((String)object2).substring(this._columns);
            }
            arrayDeque.add(object2);
        }
        boolean bl2 = false;
        object2 = null;
        while (arrayDeque.size() > 0) {
            if (object2 == null || ((Page)object2).lines.size() >= this._rows) {
                object2 = new Page();
                arrayList.add((Page)object2);
            }
            ((Page)object2).lines.add((String)arrayDeque.pop());
        }
        return arrayList;
    }

    void setFont(Graphics2D graphics2D) {
        int n = this._imageSize.getHeight() / this._rows;
        Font font = new Font("Monospaced", 0, n - 1);
        graphics2D.setFont(font);
    }

    boolean isReportStart(String string) {
        return string.startsWith("OBX|");
    }

    boolean isReportEnd(String string) {
        boolean bl = string.length() >= 4 && string.charAt(3) == '|';
        return bl;
    }

    public class Page {
        public File outputFile;
        public List<String> lines = new ArrayList<String>();
    }
}

