/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.scanning.device;

import com.ahsrcm.util.Reference;
import com.sun.media.imageioimpl.plugins.tiff.TIFFImageReader;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import net.model3.logging.Log;
import net.model3.logging.LogHelper;
import net.model3.newfile.File;

public class MultipageTiffReader {
    private static final Log logger = LogHelper.getLog(MultipageTiffReader.class);
    public static final Reference<MultipageTiffReader> instance = new Reference<MultipageTiffReader>(new MultipageTiffReader());

    private MultipageTiffReader() {
    }

    public List<BufferedImage> readMultipageTiff(File file) {
        ArrayList<BufferedImage> arrayList = new ArrayList<BufferedImage>();
        ImageInputStream imageInputStream = null;
        try {
            Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName("tiff");
            while (iterator.hasNext()) {
                ImageReader imageReader = iterator.next();
                if (!(imageReader instanceof TIFFImageReader)) continue;
                TIFFImageReader tIFFImageReader = (TIFFImageReader)imageReader;
                imageInputStream = ImageIO.createImageInputStream(file.asFile());
                tIFFImageReader.setInput((Object)imageInputStream);
                int n = tIFFImageReader.getNumImages(true);
                logger.trace((Object)"Tiff file {} has {} pages.", (Object)file.getCanonicalPath(), (Object)n);
                for (int i = 0; i < n; ++i) {
                    arrayList.add(tIFFImageReader.read(i));
                }
            }
        }
        catch (Exception exception) {
            throw new MultipageTiffException("error loading image " + file.getCanonicalPath(), exception);
        }
        finally {
            try {
                imageInputStream.close();
            }
            catch (Exception exception) {}
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int readAndProcessMultipageTiff(File file, ImageProcessor imageProcessor) {
        ImageInputStream imageInputStream = null;
        try {
            Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName("tiff");
            while (iterator.hasNext()) {
                ImageReader imageReader = iterator.next();
                if (imageReader instanceof TIFFImageReader) {
                    TIFFImageReader tIFFImageReader = (TIFFImageReader)imageReader;
                    imageInputStream = ImageIO.createImageInputStream(file.asFile());
                    tIFFImageReader.setInput((Object)imageInputStream);
                    int n = tIFFImageReader.getNumImages(true);
                    logger.trace((Object)"Tiff file {} has {} pages.", (Object)file.getCanonicalPath(), (Object)n);
                    int n2 = 0;
                    while (true) {
                        if (n2 >= n) {
                            n2 = n;
                            return n2;
                        }
                        logger.debug((Object)"processing image {} of {}", (Object)(n2 + 1), (Object)n);
                        imageProcessor.processImage(tIFFImageReader.read(n2));
                        ++n2;
                    }
                }
            }
            throw new RuntimeException("No TIFFImageReader found unable to read " + file.getCanonicalPath());
        }
        catch (Exception exception) {
            throw new MultipageTiffException(exception);
        }
        finally {
            try {
                imageInputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    public static class MultipageTiffException
    extends RuntimeException {
        private static final long serialVersionUID = -7145701447546331061L;

        public MultipageTiffException(Throwable throwable) {
            super(throwable);
        }

        public MultipageTiffException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }

    public static interface ImageProcessor {
        public void processImage(BufferedImage var1) throws Exception;
    }
}

