/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.scanning.device;

import com.ahsrcm.scanning.device.ImageReaderWriter;
import com.sun.media.imageio.plugins.tiff.TIFFImageWriteParam;
import com.sun.media.imageioimpl.plugins.tiff.TIFFImageWriter;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.stream.ImageOutputStream;
import net.model3.newfile.File;

public class JaiTiffReaderWriter
implements ImageReaderWriter {
    @Override
    public BufferedImage loadImage(URL uRL) {
        return this.loadImage(new File(uRL));
    }

    @Override
    public BufferedImage loadImage(File file) {
        try {
            BufferedImage bufferedImage = ImageIO.read(file.asFile());
            return bufferedImage;
        }
        catch (Exception exception) {
            throw new RuntimeException("error loading image " + file.getCanonicalPath(), exception);
        }
    }

    @Override
    public BufferedImage loadImage(ByteArrayInputStream byteArrayInputStream) {
        try {
            BufferedImage bufferedImage = ImageIO.read(byteArrayInputStream);
            return bufferedImage;
        }
        catch (Exception exception) {
            throw new RuntimeException("error loading image from ByteArrayInputStream " + byteArrayInputStream, exception);
        }
    }

    @Override
    public void saveImage(BufferedImage bufferedImage, File file) {
        try {
            ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(file.asFile());
            this.writeImage(bufferedImage, imageOutputStream);
            imageOutputStream.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @Override
    public void saveImages(List<BufferedImage> list, File file) {
        try {
            Object object;
            Object object2;
            BufferedImage bufferedImage2;
            ArrayList<BufferedImage> arrayList = new ArrayList<BufferedImage>();
            for (BufferedImage bufferedImage2 : list) {
                int n = bufferedImage2.getWidth();
                int n2 = bufferedImage2.getHeight();
                object2 = new byte[]{0, -1};
                object = new IndexColorModel(1, 2, (byte[])object2, (byte[])object2, (byte[])object2);
                BufferedImage bufferedImage3 = new BufferedImage(n, n2, 12, (IndexColorModel)object);
                Graphics2D graphics2D = bufferedImage3.createGraphics();
                graphics2D.drawRenderedImage(bufferedImage2, null);
                graphics2D.dispose();
                arrayList.add(bufferedImage3);
            }
            TIFFImageWriter tIFFImageWriter = (TIFFImageWriter)ImageIO.getImageWritersByFormatName("tiff").next();
            bufferedImage2 = (TIFFImageWriteParam)tIFFImageWriter.getDefaultWriteParam();
            bufferedImage2.setCompressionMode(2);
            bufferedImage2.setCompressionType("CCITT T.6");
            ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(file.asFile());
            tIFFImageWriter.setOutput((Object)imageOutputStream);
            tIFFImageWriter.prepareWriteSequence(null);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                object2 = (BufferedImage)iterator.next();
                object = new IIOImage((RenderedImage)object2, null, null);
                tIFFImageWriter.writeToSequence((IIOImage)object, (ImageWriteParam)((Object)bufferedImage2));
            }
            tIFFImageWriter.dispose();
            imageOutputStream.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @Override
    public byte[] getImageBytes(BufferedImage bufferedImage) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(byteArrayOutputStream);
            this.writeImage(bufferedImage, imageOutputStream);
            imageOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private void writeImage(BufferedImage bufferedImage, ImageOutputStream imageOutputStream) {
        try {
            int n = bufferedImage.getWidth();
            int n2 = bufferedImage.getHeight();
            byte[] byArray = new byte[]{0, -1};
            IndexColorModel indexColorModel = new IndexColorModel(1, 2, byArray, byArray, byArray);
            BufferedImage bufferedImage2 = new BufferedImage(n, n2, 12, indexColorModel);
            Graphics2D graphics2D = bufferedImage2.createGraphics();
            graphics2D.drawRenderedImage(bufferedImage, null);
            graphics2D.dispose();
            TIFFImageWriter tIFFImageWriter = (TIFFImageWriter)ImageIO.getImageWritersByFormatName("tiff").next();
            TIFFImageWriteParam tIFFImageWriteParam = (TIFFImageWriteParam)tIFFImageWriter.getDefaultWriteParam();
            tIFFImageWriteParam.setCompressionMode(2);
            tIFFImageWriteParam.setCompressionType("CCITT T.6");
            tIFFImageWriter.setOutput((Object)imageOutputStream);
            IIOImage iIOImage = new IIOImage(bufferedImage2, null, null);
            tIFFImageWriter.write(null, iIOImage, (ImageWriteParam)tIFFImageWriteParam);
            tIFFImageWriter.dispose();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }
}

