/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.scanning.dao;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import net.model3.logging.Log;
import net.model3.logging.LogHelper;

public class DaoBackgroundExecutor {
    private static final Log logger = LogHelper.getLog();
    private static final int NUMBER_OF_THREADS = 5;
    private static final ExecutorService _executor = new ThreadPoolExecutor(5, 5, 0L, TimeUnit.MILLISECONDS, (BlockingQueue)new LinkedBlockingQueue()){

        @Override
        protected void beforeExecute(Thread thread, Runnable runnable) {
            DaoBackgroundExecutor.beforeExecute(runnable);
        }

        @Override
        protected void afterExecute(Runnable runnable, Throwable throwable) {
            DaoBackgroundExecutor.afterExecute(runnable, throwable);
        }
    };

    private static void afterExecute(Runnable runnable, Throwable throwable) {
        if (throwable == null) {
            logger.debug((Object)"done executing task {}", (Object)runnable);
        } else {
            logger.warn((Object)"error executing task {}", (Object)runnable, (Object)throwable);
        }
    }

    private static void beforeExecute(Runnable runnable) {
        logger.debug((Object)"start executing task {}", (Object)runnable);
    }

    public static void executeInGuiBackground(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            DaoBackgroundExecutor.execute(runnable);
        } else {
            DaoBackgroundExecutor.beforeExecute(runnable);
            try {
                runnable.run();
                DaoBackgroundExecutor.afterExecute(runnable, null);
            }
            catch (Exception exception) {
                DaoBackgroundExecutor.afterExecute(runnable, exception);
            }
        }
    }

    public static void execute(Runnable runnable) {
        _executor.execute(runnable);
    }

    static {
        _executor.execute(new Runnable(){

            @Override
            public void run() {
                logger.info((Object)"this is the initial DaoBackgroundExecutor thread");
            }
        });
    }
}

