/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.scanning.dao;

import ca.odell.glazedlists.EventList;
import com.ahsrcm.client.tools.SessionIdProvider;
import com.ahsrcm.client.tools.rpc.RPCAction;
import com.ahsrcm.client.tools.rpc.RPCClientInterface;
import com.ahsrcm.core.crypto.CryptoEngine;
import com.ahsrcm.core.localcacheclient.ImageProvider;
import com.ahsrcm.core.util.DeployEdgeProperties;
import com.ahsrcm.core.virtualmanager.PatientDTO;
import com.ahsrcm.core.virtualmanager.ReferralDTO;
import com.ahsrcm.corp.BaseBusinessBean;
import com.ahsrcm.corp.BatchType;
import com.ahsrcm.corp.BusinessEntity;
import com.ahsrcm.corp.Company;
import com.ahsrcm.corp.Database;
import com.ahsrcm.corp.Division;
import com.ahsrcm.corp.Doctor;
import com.ahsrcm.corp.DocumentType;
import com.ahsrcm.corp.HasCDLEntity;
import com.ahsrcm.corp.ISeries;
import com.ahsrcm.corp.Location;
import com.ahsrcm.corp.PatientFile;
import com.ahsrcm.corp.ScanBatch;
import com.ahsrcm.corp.ScannedImage;
import com.ahsrcm.corp.SecurityToken;
import com.ahsrcm.corp.SecurityTokenProperty;
import com.ahsrcm.corp.User;
import com.ahsrcm.corp.WorkflowNoteType;
import com.ahsrcm.corp.beanprops.StickyObjects;
import com.ahsrcm.corp.dto.CompanyCPTCodes;
import com.ahsrcm.corp.dto.ScanBatchDTO;
import com.ahsrcm.corp.orm.ClientSideSession;
import com.ahsrcm.corp.rules.RuleManager;
import com.ahsrcm.corp.rules.Stage;
import com.ahsrcm.corp.rules.UserRole;
import com.ahsrcm.scanning.app.client.GetImageResult;
import com.ahsrcm.scanning.dao.AbstractScanningDao;
import com.ahsrcm.scanning.dao.AuthorizationException;
import com.ahsrcm.scanning.dao.ClientScanningDao;
import com.ahsrcm.scanning.dao.InitialDataLoad;
import com.ahsrcm.scanning.dao.ScanningDao;
import com.ahsrcm.scanning.dao.ServerScanningDao;
import com.ahsrcm.scanning.rpc.FlattenedBeanPropsObject;
import com.ahsrcm.util.ForbiddenException;
import com.ahsrcm.util.UserContext;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.Date;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.java.dev.properties.Property;
import net.java.dev.properties.RProperty;
import net.java.dev.properties.container.BeanContainer;
import net.java.dev.properties.container.IPropertyContext;
import net.java.dev.properties.jdbc.CurrentSession;
import net.java.dev.properties.jdbc.EntityPersister;
import net.java.dev.properties.jdbc.InternalSession;
import net.java.dev.properties.jdbc.Session;
import net.java.dev.properties.jdbc.SessionConfiguration;
import net.java.dev.properties.jdbc.SessionContextStrategy;
import net.java.dev.properties.jdbc.UpdateQuery;
import net.java.dev.properties.jdbc.handlers.ManyEntityHandler;
import net.java.dev.properties.jdbc.handlers.ManyToManyHandler;
import net.java.dev.properties.jdbc.handlers.TypeHandler;
import net.java.dev.properties.util.Utils;
import net.model3.bean.converters.Converter;
import net.model3.bean.converters.ConverterAdapter;
import net.model3.chrono.DateTime;
import net.model3.collections.ListX;
import net.model3.collections.SetX;
import net.model3.guice.DependencyInjector;
import net.model3.lang.ClassX;
import net.model3.lang.ExceptionPropagator;
import net.model3.lang.ObjectX;
import net.model3.lang.StringX;
import net.model3.logging.Log;
import net.model3.logging.LogHelper;
import net.model3.servlet.HttpResponseException;
import net.model3.util.DateX;
import net.model3.util.StringJoiner;
import net.model3x.datafeed.DataFeedService;

@Singleton
public class ClientScanningDaoImpl
extends AbstractScanningDao
implements ClientScanningDao,
Serializable {
    private static final Log logger = LogHelper.getLog();
    private static final long serialVersionUID = -8845463789855968935L;
    private static final Set<String> _propertiesToNotUpdate = new HashSet<String>();
    @Inject
    transient SessionIdProvider _sessionIdProvider;
    @Inject
    transient ImageProvider _localCacheProvider;
    @Inject
    transient UserContext _userContext;
    @Inject
    transient DataFeedService _dataFeedService;
    @Inject
    transient SessionContextStrategy _sessionContextStrategy;
    @Inject
    transient RPCClientInterface _client;
    @Inject
    transient DeployEdgeProperties _deployProperties;
    @Inject
    transient CryptoEngine _cryptoEngine;
    transient InitialDataLoad _initialDataLoad;
    transient Boolean _useEncryption;

    @Inject
    protected ClientScanningDaoImpl() {
    }

    @Override
    public void finishScanning(ScanBatch scanBatch, Stage stage, User user) {
        final long l = (Long)scanBatch.id.get();
        final String string = user != null ? (String)user.id.get() : null;
        final String string2 = (String)stage.id.get();
        String string3 = user != null ? user.getLoginName() : "null";
        this.executeAction(new RPCAction("finishScanning/" + scanBatch.getId() + "/" + stage.getId() + "/" + string3){
            private static final long serialVersionUID = 3265247505161337353L;

            public Void executeImpl() {
                Stage stage = Stage.fetchByPk(string2);
                User user = null;
                if (string != null) {
                    user = User.fetchByPk(string);
                }
                ScanBatch scanBatch = (ScanBatch)CurrentSession.get().fetchByPK(ScanBatch.class, new Object[]{l});
                ClientScanningDaoImpl.this.validateForUpdate(scanBatch);
                ((ScanningDao)ServerScanningDao.Impl.get()).finishScanning(scanBatch, stage, user);
                return null;
            }
        });
    }

    @Override
    public Stage updateStage(PatientFile patientFile, Stage stage, User user) {
        final long l = (Long)patientFile.id.get();
        final String string = (String)stage.id.get();
        final String string2 = user != null ? (String)user.id.get() : "";
        Stage stage2 = (Stage)this.executeAction(new RPCAction("updateStage/" + patientFile.getId() + "/" + stage.getId() + "/" + string2){
            private static final long serialVersionUID = -4396646540212100256L;

            public Stage executeImpl() {
                Stage stage = Stage.fetchByPk(string);
                User user = User.fetchByPk(string2);
                PatientFile patientFile = (PatientFile)CurrentSession.get().fetchByPK(PatientFile.class, new Object[]{l});
                ClientScanningDaoImpl.this.validateForUpdate(patientFile);
                return ((ScanningDao)ServerScanningDao.Impl.get()).updateStage(patientFile, stage, user);
            }
        });
        patientFile.updateStage(stage, user);
        ((ScanBatch)patientFile.batch.get()).stage.set((Object)stage2);
        return stage2;
    }

    protected <T> T executeAction(RPCAction rPCAction) {
        return (T)this.getRPCClient().execute(rPCAction);
    }

    @Override
    public GetImageResult getImageData(ScannedImage scannedImage) {
        GetImageResult getImageResult = null;
        try {
            getImageResult = this._localCacheProvider.getImageData((String)this._sessionIdProvider.get(), (Long)((ScanBatch)scannedImage.batch.get()).id.get(), (Long)scannedImage.id.get(), scannedImage.getVersion());
        }
        catch (HttpResponseException httpResponseException) {
            if (httpResponseException.getResponseStatusCode() == 440) {
                getImageResult = new GetImageResult(httpResponseException.getResponseStatusCode(), null);
            }
            throw httpResponseException;
        }
        return getImageResult;
    }

    @Override
    public <T> EventList<T> selectAll(Class<T> clazz) {
        return this._dataFeedService.getDataFeed(clazz, true);
    }

    public <T extends BaseBusinessBean> List<T> selectAllImpl(final Class<T> clazz) {
        return (List)this.executeAction(new RPCAction("selectAll(" + ClassX.getShortName(clazz) + ")"){
            private static final long serialVersionUID = 6875960855957395314L;

            public Object executeImpl() {
                if (clazz.equals(DocumentType.class) || clazz.equals(UserRole.class) || clazz.equals(BatchType.class) || clazz.equals(Stage.class) || clazz.equals(WorkflowNoteType.class) || clazz.equals(ISeries.class) || clazz.equals(Database.class)) {
                    List list = ((ScanningDao)ServerScanningDao.Impl.get()).selectAll(clazz);
                    return list;
                }
                throw new RuntimeException("type " + clazz + " not supported");
            }
        });
    }

    @Override
    public <T> T fetch(Class<T> clazz, Object ... objectArray) {
        return (T)CurrentSession.get().fetchByPK(clazz, objectArray);
    }

    public <T extends BaseBusinessBean> T fetchBean(Class<T> clazz, Object ... objectArray) {
        if (objectArray.length == 1 && objectArray[0] instanceof String && StringX.isBlank((String)((String)objectArray[0]))) {
            return null;
        }
        List<T> list = this.fetchBeanImpl(clazz, false, objectArray);
        if (list == null || list.isEmpty()) {
            return null;
        }
        if (list.size() == 1) {
            return (T)((BaseBusinessBean)list.get(0));
        }
        throw new RuntimeException("too many results found");
    }

    public <T extends BaseBusinessBean> List<T> fetchBeanImpl(final Class clazz, final boolean bl, final Object ... objectArray) {
        return (List)this.executeAction(new RPCAction("fetchBean(" + ClassX.getShortName((Class)clazz) + ", " + bl + ", [" + new StringJoiner(objectArray, ",") + "] )"){
            private static final long serialVersionUID = -7405556252527009122L;

            public List<FlattenedBeanPropsObject> executeImpl() {
                BaseBusinessBean baseBusinessBean = (BaseBusinessBean)((ScanningDao)ServerScanningDao.Impl.get()).fetch(clazz, objectArray);
                if (baseBusinessBean == null) {
                    return null;
                }
                List list = ListX.create();
                list.add(new FlattenedBeanPropsObject(baseBusinessBean, ClientScanningDaoImpl.getSessionConfiguration()));
                if (bl) {
                    IdentityHashMap<BaseBusinessBean, FlattenedBeanPropsObject> identityHashMap = new IdentityHashMap<BaseBusinessBean, FlattenedBeanPropsObject>();
                    this.fetchChildren(identityHashMap, baseBusinessBean);
                    list.addAll(identityHashMap.values());
                }
                return list;
            }

            void fetchChildren(IdentityHashMap<BaseBusinessBean, FlattenedBeanPropsObject> identityHashMap, BaseBusinessBean baseBusinessBean) {
                EntityPersister entityPersister = ClientScanningDaoImpl.getSessionConfiguration().getPersister(baseBusinessBean.getClass());
                for (IPropertyContext iPropertyContext : entityPersister.getPropertyContexts()) {
                    Property property = (Property)iPropertyContext.getProperty((Object)baseBusinessBean);
                    for (Object e : Utils.getPropertyAsCollection((Property)property)) {
                        BaseBusinessBean baseBusinessBean2 = (BaseBusinessBean)e;
                        if (identityHashMap.containsKey(baseBusinessBean2)) continue;
                        identityHashMap.put(baseBusinessBean2, new FlattenedBeanPropsObject(baseBusinessBean2, ClientScanningDaoImpl.getSessionConfiguration()));
                        this.fetchChildren(identityHashMap, baseBusinessBean2);
                    }
                }
            }
        });
    }

    public void update(final BaseBusinessBean baseBusinessBean) {
        logger.debug((Object)"updating {}", (Object)ClientScanningDaoImpl.beanToDatabaseValueString(baseBusinessBean));
        this.executeAction(new RPCAction("update/" + ClientScanningDaoImpl.beanKeysToPath(baseBusinessBean)){
            private static final long serialVersionUID = 3265247505161337353L;

            public Void executeImpl() {
                logger.debug((Object)"updating {}", (Object)ClientScanningDaoImpl.beanToDatabaseValueString(baseBusinessBean));
                Session session = CurrentSession.get();
                BaseBusinessBean baseBusinessBean2 = (BaseBusinessBean)session.fetchByPK(baseBusinessBean.getClass(), baseBusinessBean.getPrimaryKey());
                logger.debug((Object)"resolved bean - {}", (Object)ClientScanningDaoImpl.beanToDatabaseValueString(baseBusinessBean2));
                ClientScanningDaoImpl.this.validateForUpdate(baseBusinessBean2);
                EntityPersister entityPersister = ((SessionConfiguration)DependencyInjector.getInstance(SessionConfiguration.class)).getPersister(baseBusinessBean.getClass());
                for (IPropertyContext iPropertyContext : BeanContainer.get().getContext((Object)baseBusinessBean).getProperties()) {
                    TypeHandler typeHandler;
                    if (iPropertyContext.isTransient() || !iPropertyContext.isWritable() || _propertiesToNotUpdate.contains(iPropertyContext.getName()) || (typeHandler = entityPersister.getTypeHandler(iPropertyContext)) instanceof ManyEntityHandler || typeHandler instanceof ManyToManyHandler) continue;
                    Object object = iPropertyContext.getValue((Object)baseBusinessBean);
                    iPropertyContext.setValue((Object)baseBusinessBean2, object);
                }
                session.update((Object)baseBusinessBean2);
                return null;
            }
        });
    }

    @Override
    public <T extends BaseBusinessBean<T>> void delete(Class<T> clazz, Object ... objectArray) {
        logger.debug((Object)"deleting {} - {}", (Object)clazz.getName(), (Object)ClientScanningDaoImpl.beanToDatabaseValueString(objectArray));
        final String string = clazz.getName();
        final String string2 = StringX.join((Object[])objectArray, (String)":");
        this.executeAction(new RPCAction("delete/" + ClassX.getShortName(clazz) + "/" + StringX.join((Object[])objectArray, (String)"/")){
            private static final long serialVersionUID = 3265247505161337353L;

            public Void executeImpl() {
                Class clazz = ClassX.load((String)string);
                Object[] objectArray = string2.split(":");
                logger.debug((Object)"deleting {} - {}", (Object)clazz.getName(), (Object)ClientScanningDaoImpl.beanToDatabaseValueString(objectArray));
                BaseBusinessBean baseBusinessBean = (BaseBusinessBean)((ScanningDao)ServerScanningDao.Impl.get()).fetch(clazz, objectArray);
                ClientScanningDaoImpl.this.validateForUpdate(baseBusinessBean);
                ((ScanningDao)ServerScanningDao.Impl.get()).delete(clazz, objectArray);
                return null;
            }
        });
    }

    public RPCClientInterface getRPCClient() {
        return this._client;
    }

    @Override
    public CompanyCPTCodes getCPTCodesForCompany(final String string, final DateX dateX) {
        return (CompanyCPTCodes)this.executeAction(new RPCAction("getCPTCodesForCompany"){
            private static final long serialVersionUID = 8219569857153013548L;

            public Object executeImpl() {
                return ((ScanningDao)ScanningDao.Impl.get()).getCPTCodesForCompany(string, dateX);
            }
        });
    }

    public void insert(final BaseBusinessBean baseBusinessBean) {
        logger.debug((Object)"inserting {}", (Object)ClientScanningDaoImpl.beanToDatabaseValueString(baseBusinessBean));
        this.executeAction(new RPCAction("insert/" + ClientScanningDaoImpl.beanKeysToPath(baseBusinessBean)){
            private static final long serialVersionUID = 3265247505161337353L;

            public Void executeImpl() {
                logger.debug((Object)"inserting {}", (Object)ClientScanningDaoImpl.beanToDatabaseValueString(baseBusinessBean));
                try {
                    BaseBusinessBean baseBusinessBean2 = (BaseBusinessBean)baseBusinessBean.getClass().newInstance();
                    for (TypeHandler typeHandler : ClientScanningDaoImpl.getSessionConfiguration().getPersister(baseBusinessBean.getClass()).getTypeHandlers()) {
                        IPropertyContext iPropertyContext = typeHandler.getPropertyContext();
                        Object object = iPropertyContext.getValue((Object)baseBusinessBean);
                        iPropertyContext.setValue((Object)baseBusinessBean2, object);
                    }
                    ClientScanningDaoImpl.this.validateForUpdate(baseBusinessBean2);
                    ((ScanningDao)ServerScanningDao.Impl.get()).insert(baseBusinessBean2);
                    return null;
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
        });
    }

    @Override
    public long nextControlNumber(final Class<?> clazz) {
        return (Long)this.executeAction(new RPCAction("nextControlNumber( " + ClassX.getShortName(clazz) + " )"){
            private static final long serialVersionUID = -2564410484125513470L;

            public Long executeImpl() {
                return ((ScanningDao)ServerScanningDao.Impl.get()).nextControlNumber(clazz);
            }
        });
    }

    void validateForUpdate(BaseBusinessBean baseBusinessBean) {
        ((UserContext)DependencyInjector.getInstance(UserContext.class)).getAuthenticator().validateForUpdate(baseBusinessBean);
    }

    @Override
    public Object fetchProperty(RProperty<?> rProperty) {
        return ((ClientSideSession)CurrentSession.get()).fetchProperty(rProperty);
    }

    public Object fetchPropertyImpl(RProperty<?> rProperty) {
        final Class<?> clazz = rProperty.getParent().getClass();
        final Object[] objectArray = ((BaseBusinessBean)rProperty.getParent()).getPrimaryKey();
        final String string = rProperty.getContext().getName();
        return this.executeAction(new RPCAction("fetchProperty(" + ClassX.getShortName(rProperty.getParent().getClass()) + "." + string + ", [" + new StringJoiner(objectArray, ",") + "] )"){
            private static final long serialVersionUID = 6875960855957395314L;

            public Object executeImpl() {
                BaseBusinessBean baseBusinessBean = (BaseBusinessBean)((ScanningDao)ServerScanningDao.Impl.get()).fetch(clazz, objectArray);
                IPropertyContext iPropertyContext = BeanContainer.get().getContext((Object)baseBusinessBean).getProperty(string);
                return iPropertyContext.getValue((Object)baseBusinessBean);
            }
        });
    }

    @Override
    public void doHeartbeat() {
        this.executeAction(new RPCAction("doHeartbeat()"){
            private static final long serialVersionUID = 3265247505161337353L;

            public Void executeImpl() {
                return null;
            }
        });
    }

    protected Set<Class<?>> getInitialDataLoadClasses() {
        return (Set)ObjectX.magicast(StickyObjects.getStickyClasses());
    }

    @Override
    public void initialDataLoad() {
        this._initialDataLoad = (InitialDataLoad)this.executeAction(new RPCAction("initialDataLoad"){
            private static final long serialVersionUID = 162576918842371927L;

            public InitialDataLoad executeImpl() {
                User user = ((UserContext)DependencyInjector.getInstance(UserContext.class)).getUser();
                InitialDataLoad initialDataLoad = new InitialDataLoad();
                initialDataLoad._user = user;
                List<User> list = user.getColleagues();
                list.add(user);
                Set<Class<?>> set = ClientScanningDaoImpl.this.getInitialDataLoadClasses();
                initialDataLoad._selectAlls.put(BusinessEntity.class, this.getBusinessEntities(list));
                initialDataLoad._selectAlls.put(Company.class, user.allowedCompanies.get());
                initialDataLoad._selectAlls.put(Division.class, user.allowedDivisions.get());
                initialDataLoad._selectAlls.put(Location.class, user.allowedLocations.get());
                initialDataLoad._selectAlls.put(Doctor.class, this.getDoctors());
                initialDataLoad._selectAlls.put(User.class, list);
                for (Class<?> clazz : set) {
                    if (initialDataLoad._selectAlls.containsKey(clazz)) continue;
                    initialDataLoad._selectAlls.put(clazz, CurrentSession.get().selectAll(clazz));
                }
                return initialDataLoad;
            }

            List<Doctor> getDoctors() {
                List list = ListX.create();
                for (Division division : ((UserContext)DependencyInjector.getInstance(UserContext.class)).getUser().allowedDivisions) {
                    list.addAll(division.doctors.get());
                }
                return list;
            }

            List<BusinessEntity> getBusinessEntities(List<User> list) {
                List list2 = ListX.create();
                for (User user : list) {
                    list2.addAll((Collection)user.businessEntities.get());
                }
                return list2;
            }
        });
        this.processInitialDataLoad();
    }

    @Override
    public void resetSession() {
        Session session = this._sessionContextStrategy.currentSession(false);
        if (session != null) {
            this._sessionContextStrategy.close(session);
        }
        this.processInitialDataLoad();
    }

    private void processInitialDataLoad() {
        if (this._initialDataLoad != null) {
            InitialDataLoad initialDataLoad = this._initialDataLoad;
            this._userContext.setAuthenticator(initialDataLoad._user.getAuthenticator());
            logger.info((Object)"user is {}", (Object)initialDataLoad._user);
            ClientSideSession clientSideSession = (ClientSideSession)CurrentSession.get();
            for (Map.Entry<Class<?>, List<?>> entry : initialDataLoad._selectAlls.entrySet()) {
                Class<?> clazz = entry.getKey();
                EventList eventList = this._dataFeedService.getDataFeed(clazz, true);
                eventList.clear();
                eventList.addAll((Collection)entry.getValue());
            }
            for (Map.Entry<Class<?>, List<?>> entry : initialDataLoad._selectAlls.entrySet()) {
                this.addObjectsToSession((Collection)entry.getValue(), entry.getKey().toString());
            }
        }
    }

    @Override
    public void cancelScanBatch(ScanBatch scanBatch) {
        scanBatch.setStage(Stage.Canceled.get());
        scanBatch.update();
        List<PatientFile> list = scanBatch.getPatientFiles();
        if (list != null) {
            for (PatientFile patientFile : list) {
                patientFile.setStage(Stage.Canceled.get());
                patientFile.update();
            }
        }
        CurrentSession.get().commit();
    }

    @Override
    public ScanBatch loadScanBatch(final long l, final long l2) {
        ScanBatchLoader scanBatchLoader = (ScanBatchLoader)this.executeAction(new RPCAction("loadScanBatch-" + l + "-" + l2){
            private static final long serialVersionUID = -6873514421303426746L;

            public ScanBatchLoader executeImpl() {
                ScanBatchLoader scanBatchLoader = new ScanBatchLoader();
                ScanBatch scanBatch = null;
                if (l != 0L) {
                    scanBatch = ScanBatch.fetchByPk(l);
                }
                if (scanBatch == null && l2 != 0L) {
                    scanBatch = (ScanBatch)PatientFile.fetchByPk((Long)Long.valueOf((long)l2)).batch.get();
                }
                scanBatchLoader._batch = scanBatch;
                scanBatchLoader._objects = ListX.create();
                scanBatchLoader._objects.add(scanBatch);
                scanBatchLoader._objects.addAll(scanBatch.patientFiles.get());
                scanBatchLoader._objects.addAll(scanBatch.getAllImages());
                scanBatchLoader._objects.addAll(scanBatch.transactions.get());
                scanBatchLoader._objects.addAll(scanBatch.getNotes());
                scanBatchLoader._objects.addAll(scanBatch.getCharges());
                return scanBatchLoader;
            }
        });
        this.addObjectsToSession(scanBatchLoader._objects, "scan batch " + l);
        return scanBatchLoader._batch;
    }

    public void addObjectsToSession(Collection<?> collection, String string) {
        ClientSideSession clientSideSession = (ClientSideSession)CurrentSession.get();
        SessionConfiguration sessionConfiguration = ClientScanningDaoImpl.getSessionConfiguration();
        for (Object obj : collection) {
            if (obj == null) {
                logger.warn((Object)("null found in " + string));
                continue;
            }
            if (sessionConfiguration.getPersister(obj.getClass()) == null) {
                logger.warn((Object)"non persistent object found {} - {}", obj.getClass(), obj);
                continue;
            }
            clientSideSession.addToCache(obj);
        }
    }

    @Override
    public <T> List<T> fetchBeanList(final Class<T> clazz, List<Object[]> list) {
        InternalSession internalSession = (InternalSession)CurrentSession.get();
        List list2 = ListX.create();
        final List list3 = ListX.create();
        for (Object[] objectArray : list) {
            Object object = internalSession.fetchFromCache(clazz, true, objectArray);
            if (object != null) {
                list2.add(object);
                continue;
            }
            list3.add(objectArray);
        }
        if (list3.size() > 0) {
            List list4 = (List)this.executeAction(new RPCAction("fetchBeanList"){
                private static final long serialVersionUID = 8219569857153013548L;

                public Object executeImpl() {
                    return ((ScanningDao)ScanningDao.Impl.get()).fetchBeanList(clazz, list3);
                }
            });
            list2.addAll(list4);
        }
        return list2;
    }

    @Override
    public SecurityToken resolveSecurityToken(final String string) {
        List list = (List)this.executeAction(new RPCAction("resolveSecurityToken(" + string + ")"){
            private static final long serialVersionUID = 8219569857153013548L;

            public Object executeImpl() {
                List list = ListX.create();
                SecurityToken securityToken = SecurityToken.resolve(string);
                list.add(securityToken);
                for (SecurityTokenProperty securityTokenProperty : securityToken.properties) {
                    list.add(securityTokenProperty);
                }
                securityToken.createLogin();
                return list;
            }
        });
        return (SecurityToken)list.get(0);
    }

    public String urlEncode(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw ExceptionPropagator.throwUnchecked((Throwable)unsupportedEncodingException);
        }
    }

    @Override
    public List<PatientDTO> patientLookup(Division division, final String string) {
        final Object[] objectArray = division.getPrimaryKey();
        return (List)this.executeAction(new RPCAction("patientLookup/" + ClientScanningDaoImpl.beanKeysToPath(division) + "/" + this.urlEncode(string)){
            private static final long serialVersionUID = 8219569857153013548L;

            public Object executeImpl() {
                Division division = (Division)CurrentSession.get().fetchByPK(Division.class, objectArray);
                User user = ((UserContext)DependencyInjector.getInstance(UserContext.class)).getUser();
                if (!user.isAuthorizedTo(division.getCDLEntity())) {
                    throw new ForbiddenException("not authorized to " + division);
                }
                return ((ScanningDao)ScanningDao.Impl.get()).patientLookup(division, string);
            }
        });
    }

    @Override
    public List<ReferralDTO> referralLookup(Division division, final String string) {
        final Object[] objectArray = division.getPrimaryKey();
        return (List)this.executeAction(new RPCAction("referralLookup/" + ClientScanningDaoImpl.beanKeysToPath(division) + "/" + this.urlEncode(string)){
            private static final long serialVersionUID = -4534252870444588481L;

            protected Object executeImpl() {
                Division division = (Division)CurrentSession.get().fetchByPK(Division.class, objectArray);
                User user = ((UserContext)DependencyInjector.getInstance(UserContext.class)).getUser();
                if (!user.isAuthorizedTo(division.getCDLEntity())) {
                    throw new ForbiddenException("not authorized to " + division);
                }
                return ((ScanningDao)ScanningDao.Impl.get()).referralLookup(division, string);
            }
        });
    }

    @Override
    public ScanBatchDTO getScanBatchDTO(final long l) {
        return (ScanBatchDTO)this.executeAction(new RPCAction("getScanBatchDTO/" + l){
            private static final long serialVersionUID = -4534252870444588481L;

            protected Object executeImpl() {
                return ((ScanningDao)ScanningDao.Impl.get()).getScanBatchDTO(l);
            }
        });
    }

    static String beanKeysToPath(BaseBusinessBean baseBusinessBean) {
        return ClassX.getShortName(baseBusinessBean.getClass()) + "/" + StringX.join((Object[])baseBusinessBean.getPrimaryKey(), (String)"/");
    }

    public static String beanToDatabaseValueString(Object object) {
        if (object instanceof BaseBusinessBean) {
            FlattenedBeanPropsObject flattenedBeanPropsObject = new FlattenedBeanPropsObject(object);
            Object[] objectArray = flattenedBeanPropsObject.getFlattenedEntity();
            List<TypeHandler<Object>> list = flattenedBeanPropsObject.getHandlers();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(ClassX.getShortName(object.getClass()));
            stringBuilder.append("{");
            for (int i = 0; i < objectArray.length; ++i) {
                if (i != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(list.get(i).getPropertyContext().getName());
                stringBuilder.append(": ");
                stringBuilder.append(ClientScanningDaoImpl.beanToDatabaseValueString(objectArray[i]));
            }
            stringBuilder.append("}");
            return stringBuilder.toString();
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            if (objectArray.length == 1) {
                return ClientScanningDaoImpl.beanToDatabaseValueString(objectArray[0]);
            }
            return "[" + StringX.join((Object[])objectArray, (String)",") + "]";
        }
        if (object instanceof List) {
            return "List(" + StringX.join((Iterable)((List)object), (String)",", (Converter)new ConverterAdapter<Object>(){

                public String valueToString(Object object) {
                    return ClientScanningDaoImpl.beanToDatabaseValueString(object);
                }
            }) + ")";
        }
        if (object != null) {
            return object.toString();
        }
        return "null";
    }

    @Override
    public ScanningDao getWrappedDao() {
        return this;
    }

    @Override
    public Boolean validateUserToObject(final Class<? extends HasCDLEntity> clazz, final Long l) {
        return (Boolean)this.executeAction(new RPCAction("validateUserToObject/" + clazz.getSimpleName() + "/" + l){
            private static final long serialVersionUID = -7734778484667349566L;

            protected Boolean executeImpl() {
                Boolean bl = null;
                try {
                    HasCDLEntity hasCDLEntity = (HasCDLEntity)CurrentSession.get().fetchByPK(clazz, new Object[]{l});
                    if (hasCDLEntity != null) {
                        bl = true;
                    }
                }
                catch (AuthorizationException authorizationException) {
                    bl = false;
                }
                return bl;
            }
        });
    }

    @Override
    public void splitPatientFile(final PatientFile patientFile, final int n, Stage stage) {
        final String string = stage.getId();
        this.executeAction(new RPCAction("splitPatientFile/" + patientFile.getId() + "/" + n + "/" + stage.getId()){
            private static final long serialVersionUID = 6217762493085533841L;

            protected Object executeImpl() {
                ClientScanningDaoImpl.this.doSplitPatientFile(patientFile, Stage.fetchByPk(string), n);
                return null;
            }
        });
    }

    private void doSplitPatientFile(PatientFile patientFile, Stage stage, int n) {
        Object object;
        PatientFile patientFile2;
        DateTime dateTime = new DateTime();
        logger.debug((Object)("doSplitPatientFile -- start=" + dateTime.asFriendlyString()));
        try {
            patientFile2 = patientFile.getBatch().addPatientFile();
            object = patientFile.getAllImages();
            List list = ListX.create();
            Object object2 = object.iterator();
            while (object2.hasNext()) {
                ScannedImage scannedImage = (ScannedImage)object2.next();
                if (!scannedImage.isVisible() || scannedImage.getPageNumber() < n) continue;
                list.add(scannedImage.getId().toString());
            }
            object2 = "update espscnpd set EESGR = " + patientFile2.getId() + " where EEDID in (" + StringX.join((Iterable)list, (String)",") + ")";
            new UpdateQuery((String)object2).execute();
            patientFile2.setStage(stage);
            patientFile2.setCoder(patientFile.getCoder());
            patientFile2.setReworker(patientFile.getReworker());
            patientFile2.setDataEntryUser(patientFile.getDataEntryUser());
            patientFile2.update();
        }
        catch (Exception exception) {
            object = new DateTime();
            long l = dateTime.absDiff((DateTime)object).inMilliseconds();
            logger.warn((Object)("doSplitPatientFile -- end=" + object.asFriendlyString() + " diff=" + l + "ms"), (Object)exception);
        }
        patientFile2 = new DateTime();
        long l = dateTime.absDiff((DateTime)patientFile2).inMilliseconds();
        logger.debug((Object)("doSplitPatientFile -- end=" + patientFile2.asFriendlyString() + " diff=" + l + "ms"));
    }

    static SessionConfiguration getSessionConfiguration() {
        return (SessionConfiguration)DependencyInjector.getInstance(SessionConfiguration.class);
    }

    @Override
    public void finishScanBatch(final long l, final boolean bl, final boolean bl2, final Date date, final int n, final int n2, User user) {
        final String string = user != null ? (String)user.id.get() : null;
        this.executeAction(new RPCAction("finishScanBatch/" + l){

            void pruneEmptyVisits(ScanBatch scanBatch) {
                Set<PatientFile> set = this.getPruneableVisits(scanBatch);
                for (PatientFile patientFile : set) {
                    ((ScanBatch)patientFile.batch.get()).patientFiles.remove((Object)patientFile);
                    patientFile.batch.set(null);
                }
                for (PatientFile patientFile : set) {
                    logger.debug((Object)"Calling delete on patient file -- {}", (Object)patientFile);
                    ((ScanningDao)ScanningDao.Impl.get()).delete(patientFile);
                }
            }

            private Set<PatientFile> getPruneableVisits(ScanBatch scanBatch) {
                Set set = SetX.create();
                for (PatientFile patientFile : scanBatch.patientFiles) {
                    List<ScannedImage> list = patientFile.getAllImages();
                    if (!list.isEmpty() || !patientFile.getStage().equals(Stage.ScanningInProgress.get())) continue;
                    set.add(patientFile);
                }
                return set;
            }

            protected Object executeImpl() {
                ScanBatch scanBatch = ScanBatch.fetchByPk(l);
                User user = null;
                if (string != null) {
                    user = User.fetchByPk(string);
                }
                this.pruneEmptyVisits(scanBatch);
                if (!bl) {
                    scanBatch.dateOfService.set((Object)date);
                    scanBatch.expectedImageCount.set((Object)n);
                    scanBatch.expectedVisitCount.set((Object)n2);
                    logger.debug((Object)"Update batch with new dateOfService and image counts");
                    scanBatch.update();
                    boolean bl3 = false;
                    for (PatientFile patientFile : scanBatch.patientFiles) {
                        if (Stage.ScanningInProgress.get().equals(patientFile.getStage())) {
                            bl3 = true;
                            break;
                        }
                        logger.debug((Object)"Visit {} was at stage {}", (Object)patientFile.getId(), (Object)patientFile.getStage().getVisualId());
                    }
                    if (bl3) {
                        Stage stage = (Stage)((RuleManager)scanBatch.ruleManager.get()).getNextRequiredRule((Stage)Stage.ScanningInProgress.get()).stage.get();
                        logger.debug((Object)"Moving batch {} to stage {}", (Object)scanBatch.getId(), (Object)stage.getVisualId());
                        ((ScanningDao)ScanningDao.Impl.get()).finishScanning(scanBatch, stage, user);
                    } else {
                        logger.debug((Object)"Finish Scanning will not be called on batch {}", (Object)scanBatch);
                    }
                } else if (bl2) {
                    logger.debug((Object)"Cancel newly created batch {}", (Object)scanBatch);
                    ((ScanningDao)ScanningDao.Impl.get()).finishScanning(scanBatch, Stage.Canceled.get(), null);
                } else {
                    logger.debug((Object)"Batch {} was cancelled but was not a newly created batch.");
                }
                return null;
            }
        });
    }

    @Override
    public Boolean useImageEncryption() {
        if (this._useEncryption == null) {
            this._useEncryption = this._deployProperties.getUseImageEncryption();
        }
        return this._useEncryption;
    }

    @Override
    public CryptoEngine getCryptoEngine() {
        return this._cryptoEngine;
    }

    @Override
    public boolean practiceGroupExists(final long l, final String string, final String string2) {
        return (Boolean)this.executeAction(new RPCAction("practiceGroupExists/" + l + "/" + string + "/" + string2){
            private static final long serialVersionUID = 3308617502223477465L;

            protected Object executeImpl() {
                return ((ScanningDao)ScanningDao.Impl.get()).practiceGroupExists(l, string, string2);
            }
        });
    }

    static {
        _propertiesToNotUpdate.add(Stage.$creationDate.getName());
        _propertiesToNotUpdate.add(Stage.$creationUser.getName());
        _propertiesToNotUpdate.add(Stage.$creationTime.getName());
        _propertiesToNotUpdate.add(Stage.$lastChangeDate.getName());
        _propertiesToNotUpdate.add(Stage.$lastChangeUser.getName());
        _propertiesToNotUpdate.add(Stage.$lastChangeTime.getName());
    }

    public static class ScanBatchLoader
    implements Serializable {
        private static final long serialVersionUID = 7571186514288725988L;
        ScanBatch _batch;
        List<Object> _objects;
    }
}

