/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.scanning.app.server;

import com.ahsrcm.core.crypto.AESCryptoConfig;
import com.ahsrcm.core.hermes.HermesConfig;
import com.ahsrcm.core.localcacheclient.LoomConfig;
import com.ahsrcm.core.localcacheclient.PdfToTifConfig;
import com.ahsrcm.scanning.app.server.DatabaseConfig;
import com.ahsrcm.scanning.app.server.DeployEdgeConfig;
import com.ahsrcm.scanning.app.server.DeployEdgeDirectConfig;
import com.ahsrcm.scanning.app.server.EmailConfig;
import com.ahsrcm.scanning.app.server.EsbConfig;
import com.ahsrcm.scanning.app.server.StickiesConfig;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import net.model3.chrono.TimeOnly;
import net.model3.guice.bootstrap.ConfigurationDirectory;
import net.model3.lang.StringX;
import net.model3.lang.TimeDuration;
import net.model3.newfile.Directory;
import net.model3.newfile.File;
import net.model3.xstream.XmlSerializableConfig;

@Singleton
public class ServerAppConfig
extends XmlSerializableConfig {
    String _configName = "";
    boolean _startEsbDirectListeners = false;
    boolean _esbJdbcLogging = false;
    boolean _mockISeriesMode = false;
    String _serverUrl = "https://scan.ahsrcm.com/";
    boolean _mobidashModelDiskCache = false;
    TimeDuration _mobidashModelRefreshRate = new TimeDuration("1 minute");
    String _eaxUrl = "https://eax.ahsrcm.com/";
    String _eaxLoginDomain = "AHS";
    String _cacheServerUid = null;
    boolean _useProdDataSource = false;
    String _portalFilesDirectory = "./portal-files";
    String _infoedgeEmailNotificationProcessTime = null;
    DatabaseConfig _prodDatabaseConfig = new DatabaseConfig("jdbc:log4jdbc:as400://ead0001;naming=system;libraries=EAD0001,EAX_PF010,EAX_PB010;date format=usa;errors=full");
    DatabaseConfig _testDatabaseConfig = new DatabaseConfig("jdbc:log4jdbc:as400://ead6001;naming=system;libraries=EAD6001,EAX_PF010T,EAX_PB010;date format=usa;errors=full");
    DatabaseConfig _jiraDatabaseConfig = new DatabaseConfig("jdbc:log4jdbc:postgresql://172.28.26.143:5432/jiradb2");
    TimeDuration _secondLevelCacheTimeout = new TimeDuration("10 minutes");
    int _secondLevelCacheMaxEntries = 5000;
    String _imageCacheDirectory = "./encrypted-ahs-scanned-images/";
    String _imageIncrementalDirectory = null;
    String _dataQueueEventDirectory = "./ahs-esb-events/";
    Directory _dataQueueEventDirectoryImpl;
    TimeDuration _sessionNoUpdateWindow = new TimeDuration("5 minutes");
    String _upStreamServerUrl = "";
    String _superUserToken = "";
    StickiesConfig _stickiesConfig = new StickiesConfig();
    String _infoedgeDataLibrary = "GLEN";
    boolean _useImageEncryption = false;
    AESCryptoConfig _aesCryptoConfig = null;
    LoomConfig _loomConfig = new LoomConfig();
    EmailConfig _emailConfig = new EmailConfig();
    PdfToTifConfig _pdfToTifConfig = new PdfToTifConfig();
    boolean _isFileExchangeReadOnly = false;
    DeployEdgeDirectConfig _directConfig = new DeployEdgeDirectConfig();
    EsbConfig _esbConfig = new EsbConfig();
    DeployEdgeConfig _deployEdgeConfig = new DeployEdgeConfig();
    HermesConfig _hermesConfig = new HermesConfig();
    String _qubesServerUrl = "https://infoedge-bi.ahsrcm.com";
    String _conversionServerUrl = null;

    public ServerAppConfig() {
    }

    @Inject
    public ServerAppConfig(ConfigurationDirectory configurationDirectory) {
        this.load(new File((Directory)configurationDirectory.get(), "server.xml"));
        this.saveSample(new ServerAppConfig());
    }

    public boolean usingDeveloperDatabase() {
        return !this.getDatabaseConfig().getUrl().contains(":as400:");
    }

    public boolean mockISeriesMode() {
        return this._mockISeriesMode;
    }

    public String getEaxUrl() {
        return this._eaxUrl;
    }

    public DatabaseConfig getDatabaseConfig() {
        if (this._useProdDataSource) {
            return this.getProdDatabaseConfig();
        }
        return this.getTestDatabaseConfig();
    }

    public Directory getDataQueueEventDirectory() {
        if (this._dataQueueEventDirectoryImpl == null) {
            this._dataQueueEventDirectoryImpl = new Directory(this._dataQueueEventDirectory);
        }
        return this._dataQueueEventDirectoryImpl;
    }

    public String getImageCacheDirectory() {
        return this._imageCacheDirectory;
    }

    public String getImageIncrementalDirectory() {
        return this._imageIncrementalDirectory;
    }

    public String getServerUrl() {
        return this._serverUrl;
    }

    public TimeDuration getSecondLevelCacheTimeout() {
        return this._secondLevelCacheTimeout;
    }

    public int getSecondLevelCacheMaxEntries() {
        return this._secondLevelCacheMaxEntries;
    }

    public String getEaxLoginDomain() {
        return this._eaxLoginDomain;
    }

    public TimeDuration getSessionNoUpdateWindow() {
        return this._sessionNoUpdateWindow;
    }

    public DatabaseConfig getProdDatabaseConfig() {
        return this._prodDatabaseConfig;
    }

    public DatabaseConfig getTestDatabaseConfig() {
        return this._testDatabaseConfig;
    }

    public boolean useProdDataSource() {
        return this._useProdDataSource;
    }

    public boolean getEsbJdbcLogging() {
        return this._esbJdbcLogging;
    }

    public Directory getPortalFilesDirectory() {
        return new Directory(this._portalFilesDirectory);
    }

    public String getEnterpriseDatabaseId() {
        if (this.useProdDataSource()) {
            return "0001";
        }
        return "6001";
    }

    public String getUpStreamServerUrl() {
        return this._upStreamServerUrl;
    }

    public String getPatientPortalCustomDirectory() {
        return this.getImageCacheDirectory() + "/patient-portal-images/";
    }

    public String getSuperUserToken() {
        return this._superUserToken;
    }

    public boolean getStartEsbDirectListeners() {
        return this._startEsbDirectListeners;
    }

    public TimeOnly getInfoedgeEmailNotificationProcessTime() {
        if (StringX.isNotBlank((String)this._infoedgeEmailNotificationProcessTime)) {
            return new TimeOnly(this._infoedgeEmailNotificationProcessTime);
        }
        return null;
    }

    public StickiesConfig getStickiesConfig() {
        if (this._stickiesConfig == null) {
            this._stickiesConfig = new StickiesConfig();
        }
        return this._stickiesConfig;
    }

    public boolean getMobidashModelDiskCache() {
        return this._mobidashModelDiskCache;
    }

    public TimeDuration getMobidashModelRefreshRate() {
        return this._mobidashModelRefreshRate;
    }

    public DatabaseConfig getJiraDatabaseConfig() {
        return this._jiraDatabaseConfig;
    }

    public String getInfoedgeDataLibrary() {
        return this._infoedgeDataLibrary;
    }

    public String getConfigName() {
        return this._configName;
    }

    public String getCacheServerUid() {
        return this._cacheServerUid;
    }

    public AESCryptoConfig getAESCryptoConfig() {
        return this._aesCryptoConfig;
    }

    public boolean getUseImageEncryption() {
        return this._useImageEncryption;
    }

    public LoomConfig getLoomConfig() {
        return this._loomConfig;
    }

    public EmailConfig getEmailConfig() {
        return this._emailConfig;
    }

    public PdfToTifConfig getPdfToTifConfig() {
        return this._pdfToTifConfig;
    }

    public DeployEdgeDirectConfig getDeployEdgeDirectConfig() {
        return this._directConfig;
    }

    public EsbConfig getEsbConfig() {
        return this._esbConfig;
    }

    public boolean getIsFileExchangeReadOnly() {
        return this._isFileExchangeReadOnly;
    }

    public DeployEdgeConfig getDeployEdgeConfig() {
        return this._deployEdgeConfig;
    }

    public HermesConfig getHermesConfig() {
        return this._hermesConfig;
    }

    public String getQubesServerUrl() {
        return this._qubesServerUrl;
    }

    public String getConversionServerUrl() {
        return this._conversionServerUrl;
    }
}

