/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.scanning.app.server;

import com.ahsrcm.corp.AbstractAuthenticator;
import com.ahsrcm.corp.Company;
import com.ahsrcm.corp.Division;
import com.ahsrcm.corp.Location;
import com.ahsrcm.corp.OrmBean;
import com.ahsrcm.corp.PatientFile;
import com.ahsrcm.corp.ScanBatch;
import com.ahsrcm.corp.SecurityToken;
import com.ahsrcm.corp.User;
import com.ahsrcm.corp.cdl.CDLAuthenticator;
import com.ahsrcm.corp.cdl.CDLFactory;
import com.ahsrcm.corp.rules.UserRole;
import java.util.Set;
import net.java.dev.properties.container.BeanContainer;

public class SecurityTokenAuthenticator
extends AbstractAuthenticator {
    CDLAuthenticator _authenticator;
    SecurityToken _securityToken;
    PatientFile _patientFile;
    User _user;

    public SecurityTokenAuthenticator(SecurityToken securityToken) {
        BeanContainer.bind((Object)this);
        this._patientFile = PatientFile.fetchByPk((Long)securityToken.patientFileId.get());
        this._securityToken = securityToken;
        this._authenticator = CDLFactory.get().getCDL((Division)securityToken.division.get());
        this._user = User.fetchByLoginOrId(this._securityToken.getUserId());
    }

    @Override
    public User getUser() {
        return this._user;
    }

    @Override
    public CDLAuthenticator getCDLAuthenticator() {
        return this._authenticator;
    }

    PatientFile getPatientFile() {
        return this._patientFile;
    }

    ScanBatch getScanBatch() {
        if (this.getPatientFile() != null) {
            return (ScanBatch)this.getPatientFile().batch.get();
        }
        return null;
    }

    Company getCompany() {
        if (this.getDivision() != null) {
            return (Company)this.getDivision().company.get();
        }
        return null;
    }

    Location getLocation() {
        if (this.getScanBatch() != null) {
            return (Location)this.getScanBatch().location.get();
        }
        return null;
    }

    Division getDivision() {
        if (this.getLocation() != null) {
            return (Division)this.getLocation().division.get();
        }
        return null;
    }

    @Override
    public String getUserId() {
        if (this.getUser() == null) {
            return (String)this._securityToken.userId.get();
        }
        return super.getUserLogin();
    }

    @Override
    public String getUserLogin() {
        if (this.getUser() == null) {
            return "TKN:" + (String)this._securityToken.userId.get();
        }
        return super.getUserLogin();
    }

    @Override
    public boolean isAdministrator() {
        return false;
    }

    @Override
    public boolean canAccessAllInfoEdgeUsers() {
        return this._user.canAccessAllInfoEdgeUsers();
    }

    @Override
    public Set<String> getIfsFileRoles() {
        return this._user.getIfsFileRoles();
    }

    @Override
    public boolean hasRole(UserRole userRole) {
        return this._user.hasRole(userRole);
    }

    @Override
    public boolean canCancelBatchesAndVisits() {
        return false;
    }

    @Override
    public boolean canEnterCharges() {
        return false;
    }

    @Override
    public String getUserDescription() {
        if (this.getUser() == null) {
            return "TKN:" + (String)this._securityToken.userId.get();
        }
        return super.getUserLogin();
    }

    public boolean isAuthorized(ScanBatch scanBatch) {
        return this.getScanBatch() != null && this.getScanBatch().equals(scanBatch);
    }

    @Override
    public void validateForUpdate(OrmBean ormBean) {
        throw new RuntimeException("no upating allowed with security tokens");
    }
}

