/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.scanning.app.server;

import com.ibm.as400.access.AS400JDBCDriver;
import java.sql.Driver;
import java.sql.DriverManager;
import net.model3.lang.TimeDuration;
import net.model3.logging.Log;
import net.model3.logging.LogHelper;
import net.sf.log4jdbc.DriverSpy;
import org.apache.commons.dbcp.BasicDataSource;

public class DatabaseConfig {
    private static final Log logger = LogHelper.getLog();
    private String _driver = "net.sf.log4jdbc.DriverSpy";
    private String _url = "jdbc:log4jdbc:as400://172.28.4.56;naming=system;libraries=EAD6001,EAX_PF010T,EAX_PB010;errors=full";
    private String _user = "";
    private String _password = "";
    private int _maxActive = 20;
    private int _minIdle = 3;
    private boolean _testOnBorrow = true;
    private boolean _testWhileIdle = true;
    private boolean _testOnReturn = true;
    private TimeDuration _timeBetweenEvictionRunsMillis = new TimeDuration("5 minutes");
    private int _numberOfTestsPerEvictionRun = 10;
    private boolean _poolPreparedStatements = true;
    private boolean _defaultAutoCommit = true;
    private int _initialSize = 1;
    private TimeDuration _maxWait = new TimeDuration("30 seconds");
    private String _validationQuery = "select 1+1 from ESPCON fetch first 1 rows only";
    boolean _logAbandoned = true;
    boolean _removeAbandoned = true;
    TimeDuration _removeAbandonedTimeout = new TimeDuration("30 minutes");

    public DatabaseConfig() {
    }

    public DatabaseConfig(String string) {
        this._url = string;
    }

    public BasicDataSource createDataSource() {
        System.setProperty("log4jdbc.no_line_breaks", "true");
        try {
            DriverManager.registerDriver((Driver)new AS400JDBCDriver());
            DriverManager.registerDriver((Driver)new DriverSpy());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        logger.info((Object)"jdbc url = {}", (Object)this._url);
        BasicDataSource basicDataSource = new BasicDataSource();
        basicDataSource.setDriverClassName(this._driver);
        basicDataSource.setUrl(this._url);
        basicDataSource.setUsername(this._user);
        basicDataSource.setPassword(this._password);
        basicDataSource.setMaxActive(this._maxActive);
        basicDataSource.setMinIdle(this._minIdle);
        basicDataSource.setInitialSize(this._initialSize);
        if (this._maxWait != null) {
            basicDataSource.setMaxWait(this._maxWait.inMilliseconds());
        }
        basicDataSource.setTestOnBorrow(this._testOnBorrow);
        basicDataSource.setTestOnReturn(this._testOnReturn);
        basicDataSource.setTestWhileIdle(this._testWhileIdle);
        if (this._timeBetweenEvictionRunsMillis != null) {
            basicDataSource.setTimeBetweenEvictionRunsMillis(this._timeBetweenEvictionRunsMillis.inMilliseconds());
        }
        basicDataSource.setNumTestsPerEvictionRun(this._numberOfTestsPerEvictionRun);
        basicDataSource.setDefaultAutoCommit(this._defaultAutoCommit);
        basicDataSource.setPoolPreparedStatements(this._poolPreparedStatements);
        basicDataSource.setValidationQuery(this._validationQuery);
        basicDataSource.setLogAbandoned(this._logAbandoned);
        basicDataSource.setRemoveAbandoned(this._removeAbandoned);
        basicDataSource.setRemoveAbandonedTimeout((int)this._removeAbandonedTimeout.inSeconds());
        return basicDataSource;
    }

    public String getUser() {
        return this._user;
    }

    public String getDriver() {
        return this._driver;
    }

    public String getPassword() {
        return this._password;
    }

    public String getUrl() {
        return this._url;
    }

    public void setUrl(String string) {
        this._url = string;
    }

    public void setUser(String string) {
        this._user = string;
    }

    public void setPassword(String string) {
        this._password = string;
    }

    public boolean getLogAbandoned() {
        return this._logAbandoned;
    }

    public boolean getRemoveAbandoned() {
        return this._removeAbandoned;
    }

    public TimeDuration getRemoveAbandonedTimeout() {
        return this._removeAbandonedTimeout;
    }
}

