/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.scanning.app.client;

import com.ahsrcm.client.tools.SessionIdProvider;
import com.ahsrcm.core.localcacheclient.RemoteImageProvider;
import com.ahsrcm.corp.ScannedImage;
import com.ahsrcm.scanning.app.client.ImageUploadService;
import com.ahsrcm.util.guice.Directories;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.model3.guice.LifeCycleListeners;
import net.model3.lang.StringX;
import net.model3.lang.ThreadScheduler;
import net.model3.lang.TimeDuration;
import net.model3.logging.Log;
import net.model3.logging.LogHelper;
import net.model3.newfile.Directory;
import net.model3.newfile.File;

@Singleton
public class ImageUploadServiceImpl
implements ImageUploadService,
LifeCycleListeners.Config,
LifeCycleListeners.Destroy {
    private static final Log logger = LogHelper.getLog();
    @Inject
    SessionIdProvider _sessionIdProvider;
    @Inject
    RemoteImageProvider _imageUploader;
    @Inject
    ThreadScheduler _threadScheduler;
    @Inject
    Directories _directories;
    final Object _imageReadWriteLock = new Object();
    final Lock _runningLock = new ReentrantLock();
    final AtomicBoolean _isRunning = new AtomicBoolean(false);
    private Runnable _runnable = new Runnable(){

        @Override
        public void run() {
            ImageUploadServiceImpl.this.processImageUploadQueue();
        }
    };

    @Inject
    private ImageUploadServiceImpl() {
    }

    boolean tryToAquireLock() {
        boolean bl = this._runningLock.tryLock();
        logger.debug((Object)"tryToAquireLock() => {}", (Object)bl);
        return bl;
    }

    void releaseLock() {
        this._runningLock.unlock();
        logger.debug((Object)"lock released");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processImageUploadQueue() {
        logger.trace((Object)"processing image upload queue");
        if (StringX.isBlank((String)((String)this._sessionIdProvider.get()))) {
            logger.trace((Object)"skipping processing as we don't have a session id yet");
        } else if (this.tryToAquireLock()) {
            try {
                logger.debug((Object)"starting main image upload loop");
                for (int i = 0; i < 5; ++i) {
                    List list = this._directories.scannedImageUploadQueue().files();
                    if (list.isEmpty()) {
                        logger.debug((Object)("no files left in queue -- " + this._directories.scannedImageUploadQueue()));
                    }
                    logger.debug((Object)"try # {}", (Object)i);
                    for (File file : list) {
                        logger.debug((Object)("processing " + file.getName()));
                        Long l = null;
                        try {
                            Object object;
                            int n;
                            long l2;
                            String[] stringArray = file.getBaseFilename().split("-");
                            if (stringArray.length == 2) {
                                l2 = Long.parseLong(stringArray[0]);
                                n = Integer.parseInt(stringArray[1]);
                            } else if (stringArray.length == 3) {
                                l = Long.parseLong(stringArray[0]);
                                l2 = Long.parseLong(stringArray[1]);
                                n = Integer.parseInt(stringArray[2]);
                            } else {
                                this.moveToErrorQueue(file);
                                throw new RuntimeException("invalid # of parts in " + file.getBaseFilename());
                            }
                            if (l == null) {
                                object = ScannedImage.fetchByPk(l2);
                                try {
                                    l = ((ScannedImage)object).getBatch().getId();
                                }
                                catch (NullPointerException nullPointerException) {
                                    this.moveToErrorQueue(file);
                                    throw new RuntimeException("unable to get scanned image or batch id from scanned image", nullPointerException);
                                }
                            }
                            if (l != null) {
                                logger.debug((Object)"starting upload of {} - {} bytes", (Object)file.getName(), (Object)file.length());
                                Object object2 = this._imageReadWriteLock;
                                synchronized (object2) {
                                    object = file.readBytes();
                                }
                                object2 = (String)this._sessionIdProvider.get();
                                if (this._imageUploader != null) {
                                    this._imageUploader.uploadImageData((String)object2, l, l2, n, (byte[])object);
                                    logger.debug((Object)"completed upload of {} - {} bytes", (Object)file.getName(), (Object)file.length());
                                    file.delete();
                                    continue;
                                }
                                logger.error((Object)"image uploader is null this is bad bad bad");
                                this.moveToErrorQueue(file);
                                continue;
                            }
                            logger.error((Object)"no scanned image found for {}", (Object)l2);
                            this.moveToErrorQueue(file);
                        }
                        catch (Exception exception) {
                            logger.warn((Object)"failed to upload {} - {} bytes", (Object)file.getName(), (Object)file.length(), (Object)exception);
                            this.moveToErrorQueue(file);
                        }
                    }
                }
            }
            finally {
                this.releaseLock();
            }
        } else {
            logger.debug((Object)"skipping processing the running lock is held by another thread");
        }
    }

    public void configComplete() throws Exception {
        this.start();
    }

    public void preDestroy() throws Exception {
        logger.warn((Object)"ImageUploadServiceImpl has a thread and it won't actually shutdown on a guice destroy");
    }

    final void start() {
        boolean bl = this._isRunning.getAndSet(true);
        if (bl) {
            logger.warn((Object)"Another attempt to start the Image Uploader thread has occurred", (Object)new RuntimeException("ImageUploader already running"));
        } else {
            logger.debug((Object)"Starting the ImageUploader");
            this._threadScheduler.schedule("initial-image-upload-check", new TimeDuration("15 seconds"), this._runnable);
            this._threadScheduler.scheduleRepeating("image-upload-check", new TimeDuration("5 minutes"), false, this._runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveToErrorQueue(File file) {
        logger.error((Object)"moving {} to error queue", (Object)file);
        try {
            Directory directory = this._directories.scannedImageUploadQueue().subDirectory(".errors");
            Object object = this._imageReadWriteLock;
            synchronized (object) {
                File file2 = directory.file(file.getName());
                int n = 0;
                while (file2.exists()) {
                    file2 = directory.file(file.getName() + "." + n);
                    ++n;
                }
                file2.getParent().makeDirectories();
                file.moveTo(file2);
            }
        }
        catch (Exception exception) {
            logger.error((Object)"unable to move file to error queue", (Object)exception);
        }
    }

    @Override
    public void tickle() {
        logger.debug((Object)"tickle()");
        this._threadScheduler.submit("imageUploadViaTickle", this._runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void queue(long l, long l2, int n, byte[] byArray) {
        Object object = this._imageReadWriteLock;
        synchronized (object) {
            ScannedImage.getQueuedFile(l, l2, n).write(byArray);
            this.tickle();
        }
    }
}

