/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.iseries;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Bin2;
import com.ibm.as400.access.AS400Bin4;
import com.ibm.as400.access.AS400Bin8;
import com.ibm.as400.access.AS400ByteArray;
import com.ibm.as400.access.AS400DataType;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import java.util.List;
import net.model3.collections.ListX;
import net.model3.lang.ExceptionPropagator;
import net.model3.lang.StringX;

public class ProgramCallDefinition {
    String _library;
    String _program;
    List<AS400DataType> _parameterDefinitions = ListX.create();

    public ProgramCallDefinition(String string) {
        this("*LIBL", string);
    }

    public ProgramCallDefinition(String string, String string2) {
        this._library = string;
        this._program = string2;
    }

    public ProgramCallDefinition addAlphaParm(int n) {
        this._parameterDefinitions.add((AS400DataType)new AS400Text(n));
        return this;
    }

    public ProgramCallDefinition addBufferParm(int n) {
        this._parameterDefinitions.add((AS400DataType)new AS400ByteArray(n));
        return this;
    }

    public ProgramCallDefinition addIntParm() {
        this._parameterDefinitions.add((AS400DataType)new AS400Bin4());
        return this;
    }

    public ProgramCallDefinition addShortParm() {
        this._parameterDefinitions.add((AS400DataType)new AS400Bin2());
        return this;
    }

    public ProgramCallDefinition addLongParm() {
        this._parameterDefinitions.add((AS400DataType)new AS400Bin8());
        return this;
    }

    public ProgramInvoker createInvokerInstance() {
        return new ProgramInvoker();
    }

    public class Parameter {
        AS400DataType _dataType;
        ProgramParameter _jtProgramParameter;

        Parameter(AS400DataType aS400DataType) {
            try {
                this._dataType = aS400DataType;
                this._jtProgramParameter = new ProgramParameter();
                this._jtProgramParameter.setInputData(new byte[this._dataType.getByteLength()]);
                this._jtProgramParameter.setOutputDataLength(this._dataType.getByteLength());
            }
            catch (Exception exception) {
                throw ExceptionPropagator.wrap((Throwable)exception);
            }
        }

        public Parameter setValue(Object object) {
            try {
                if (this._dataType instanceof AS400Text && object != null) {
                    String string = (String)object;
                    AS400Text aS400Text = (AS400Text)this._dataType;
                    if (string.length() > aS400Text.getByteLength()) {
                        object = string.substring(0, aS400Text.getByteLength());
                    }
                }
                this._jtProgramParameter.setInputData(this._dataType.toBytes(object));
                return this;
            }
            catch (Exception exception) {
                throw ExceptionPropagator.wrap((Throwable)exception);
            }
        }

        public <T> T getValue() {
            try {
                return (T)this._dataType.toObject(this._jtProgramParameter.getOutputData());
            }
            catch (Exception exception) {
                throw ExceptionPropagator.wrap((Throwable)exception);
            }
        }
    }

    public class ProgramInvoker {
        List<Parameter> _parameters = ListX.create();
        ProgramParameter[] _jtParmList;

        public ProgramInvoker() {
            for (AS400DataType aS400DataType : ProgramCallDefinition.this._parameterDefinitions) {
                this._parameters.add(new Parameter(aS400DataType));
            }
            this._jtParmList = new ProgramParameter[this._parameters.size()];
            for (int i = 0; i < this._parameters.size(); ++i) {
                this._jtParmList[i] = this._parameters.get((int)i)._jtProgramParameter;
            }
        }

        public void invoke(AS400 aS400) {
            try {
                ProgramCall programCall = new ProgramCall(aS400);
                if (ProgramCallDefinition.this._library.equals("QSYS")) {
                    programCall.setProgram("/QSYS.LIB/" + ProgramCallDefinition.this._program + ".PGM");
                } else {
                    programCall.setProgram("/QSYS.LIB/" + ProgramCallDefinition.this._library + ".LIB/" + ProgramCallDefinition.this._program + ".PGM");
                }
                programCall.setParameterList(this._jtParmList);
                if (!programCall.run()) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (AS400Message aS400Message : programCall.getMessageList()) {
                        stringBuilder.append(aS400Message.getText());
                        stringBuilder.append("\n");
                    }
                    throw new RuntimeException("call to " + ProgramCallDefinition.this._library + "/" + ProgramCallDefinition.this._program + " on " + aS400.getSystemName() + " failed.  Job log follows\n" + StringX.indent((String)"     ", (String)stringBuilder.toString()));
                }
            }
            catch (Exception exception) {
                throw ExceptionPropagator.wrap((Throwable)exception);
            }
        }

        public Parameter getParm(int n) {
            return this._parameters.get(n);
        }
    }
}

