/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.esb.synch.routing;

import com.ahsrcm.corp.Company;
import com.ahsrcm.corp.Division;
import com.ahsrcm.esb.synch.SynchEvent;
import com.ahsrcm.esb.synch.TableInfoPlugin;
import com.ahsrcm.esb.synch.routing.EndPoint;
import com.ahsrcm.esb.synch.routing.EndPointTemplate;
import java.util.List;
import net.model3.collections.ListX;
import net.model3.guice.DependencyInjector;

public enum SynchPer {
    Database{

        @Override
        public List<EndPoint> getEndPoints(EndPointTemplate endPointTemplate) {
            return ListX.create((Object[])new EndPoint[]{new EndPoint(endPointTemplate)});
        }
    }
    ,
    Company{

        @Override
        public List<EndPoint> getEndPoints(EndPointTemplate endPointTemplate) {
            List list = ListX.create();
            for (Company company : SynchEvent.get().getCompanies()) {
                list.add(new EndPoint(endPointTemplate, company));
            }
            return list;
        }
    }
    ,
    Division{
        TableInfoPlugin _tableInfoPlugin = (TableInfoPlugin)DependencyInjector.getInstance(TableInfoPlugin.class);

        @Override
        public List<EndPoint> getEndPoints(EndPointTemplate endPointTemplate) {
            List list = ListX.create();
            for (Division division : endPointTemplate.getDivisions()) {
                list.add(new EndPoint(endPointTemplate, division));
            }
            return this._tableInfoPlugin.processEndPointsForMembers(list, endPointTemplate);
        }
    }
    ,
    FirstDivisionInCompany{
        TableInfoPlugin _tableInfoPlugin = (TableInfoPlugin)DependencyInjector.getInstance(TableInfoPlugin.class);

        @Override
        public List<EndPoint> getEndPoints(EndPointTemplate endPointTemplate) {
            List list = ListX.create();
            for (Company company : SynchEvent.get().getCompanies()) {
                if (company.divisions.size() <= 0) continue;
                list.add(new EndPoint(endPointTemplate, (Division)company.divisions.get(0)));
            }
            return this._tableInfoPlugin.processEndPointsForMembers(list, endPointTemplate);
        }
    };


    public abstract List<EndPoint> getEndPoints(EndPointTemplate var1);
}

