/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.esb.synch.routing;

import com.ahsrcm.corp.Company;
import com.ahsrcm.corp.Database;
import com.ahsrcm.corp.Division;
import com.ahsrcm.esb.EsbEvent;
import com.ahsrcm.esb.synch.SynchEvent;
import com.ahsrcm.esb.synch.Table;
import java.util.List;
import net.model3.collections.ListX;
import net.model3.lang.ObjectX;

public class EndPointTemplate
implements Cloneable,
Comparable<EndPointTemplate> {
    private SynchEvent _event;
    private Database _database;
    private Company _company;
    private Division _division;
    private Table _table;

    public EndPointTemplate(String string) {
        this(string, "", "");
    }

    public EndPointTemplate(String string, String string2, String string3) {
        this._database = Database.fetchByPk(string);
        this._company = Company.fetchByPk(string2);
        this._division = Division.fetchByPk(string2, string3);
    }

    public EndPointTemplate(SynchEvent synchEvent, String string, String string2, String string3, Table table) {
        this(string, string2, string3);
        this._event = synchEvent;
        this._table = table;
    }

    public SynchEvent getEvent() {
        return this._event;
    }

    public Database getDatabase() {
        if (this._database == null && this._company != null) {
            this._database = (Database)this._company.database.get();
        }
        return this._database;
    }

    public String getCompanyId() {
        if (this._company == null) {
            return "";
        }
        return (String)this._company.id.get();
    }

    public Company getCompany() {
        return this._company;
    }

    public List<Company> getCompanies() {
        List list = ListX.create();
        if (this.getCompany() != null) {
            list.add(this.getCompany());
        } else {
            Database database = this.getDatabase();
            if (database.isEnterprise()) {
                database = EsbEvent.get().getClientDatabase();
            }
            for (Company company : database.companies) {
                list.add(company);
            }
        }
        return list;
    }

    public List<Division> getDivisions() {
        List list = ListX.create();
        if (this.getDivision() != null) {
            list.add(this.getDivision());
        } else {
            for (Company company : this.getCompanies()) {
                list.addAll(company.divisions.get());
            }
        }
        return list;
    }

    public String getDatabaseId() {
        return (String)this._database.id.get();
    }

    public Division getDivision() {
        return this._division;
    }

    public String getDivisionId() {
        if (this._division == null) {
            return "";
        }
        return (String)this._division.id.get();
    }

    public boolean isEnterprise() {
        return this.getDatabase().isEnterprise();
    }

    public String toString() {
        return this.getDatabaseId() + ":" + this.getCompanyId() + ":" + this.getDivisionId();
    }

    @Override
    public int compareTo(EndPointTemplate endPointTemplate) {
        return ObjectX.compareTo((Object[])new Object[]{this.getDatabaseId(), this.getCompanyId(), this.getDivisionId()}, (Object[])new Object[]{endPointTemplate.getDatabaseId(), endPointTemplate.getCompanyId(), endPointTemplate.getDivisionId()});
    }

    public Table getTable() {
        return this._table;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        EndPointTemplate endPointTemplate = (EndPointTemplate)object;
        if (!(this._database == endPointTemplate._database || this._database != null && this._database.equals(endPointTemplate._database))) {
            return false;
        }
        if (!(this._company == endPointTemplate._company || this._company != null && this._company.equals(endPointTemplate._company))) {
            return false;
        }
        if (!(this._division == endPointTemplate._division || this._division != null && this._division.equals(endPointTemplate._division))) {
            return false;
        }
        return this._table == endPointTemplate._table || this._table != null && this._table.equals(endPointTemplate._table);
    }

    public int hashCode() {
        int n = 5;
        n = 97 * n + (this._database != null ? this._database.hashCode() : 0);
        n = 97 * n + (this._company != null ? this._company.hashCode() : 0);
        n = 97 * n + (this._division != null ? this._division.hashCode() : 0);
        n = 97 * n + (this._table != null ? this._table.hashCode() : 0);
        return n;
    }
}

