/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.esb.synch.routing;

import com.ahsrcm.corp.Company;
import com.ahsrcm.corp.Database;
import com.ahsrcm.corp.Division;
import com.ahsrcm.esb.EsbEvent;
import com.ahsrcm.esb.synch.Table;
import com.ahsrcm.esb.synch.routing.EndPointTemplate;
import java.util.List;
import net.model3.collections.ListX;
import net.model3.lang.ObjectX;

public class EndPoint
implements Cloneable,
Comparable<EndPoint> {
    private EndPointTemplate _template;
    private Company _company;
    private Division _division;
    private String _member;

    public EndPoint(EndPointTemplate endPointTemplate) {
        this._template = endPointTemplate;
    }

    public EndPoint(EndPointTemplate endPointTemplate, String string, String string2) {
        this(endPointTemplate);
        this._company = Company.fetchByPk(string);
        this._division = Division.fetchByPk(string, string2);
    }

    public EndPoint(EndPointTemplate endPointTemplate, String string, String string2, String string3) {
        this(endPointTemplate);
        this._company = Company.fetchByPk(string);
        this._division = Division.fetchByPk(string, string2);
        this._member = string3;
    }

    public EndPoint(EndPointTemplate endPointTemplate, Company company) {
        this(endPointTemplate);
        this._company = company;
    }

    public EndPoint(EndPointTemplate endPointTemplate, Division division) {
        this(endPointTemplate);
        this._company = (Company)division.company.get();
        this._division = division;
    }

    public EndPoint(EndPointTemplate endPointTemplate, Division division, String string) {
        this(endPointTemplate);
        this._company = (Company)division.company.get();
        this._division = division;
        this._member = string;
    }

    public Database getDatabase() {
        return this._template.getDatabase();
    }

    public String getCompanyId() {
        if (this._company == null) {
            return "";
        }
        return (String)this._company.id.get();
    }

    public Company getCompany() {
        return this._company;
    }

    public List<Company> getCompanies() {
        List list = ListX.create();
        if (this.getCompany() != null) {
            list.add(this.getCompany());
        } else {
            for (Company company : this.getDatabase().companies) {
                list.add(company);
            }
        }
        return list;
    }

    public List<Division> getDivisions() {
        List list = ListX.create();
        if (this.getDivision() != null) {
            list.add(this.getDivision());
        } else {
            for (Company company : this.getCompanies()) {
                list.addAll(company.divisions.get());
            }
        }
        return list;
    }

    public String getDatabaseId() {
        return (String)this.getDatabase().id.get();
    }

    public Division getDivision() {
        return this._division;
    }

    public String getDivisionId() {
        if (this._division == null) {
            return "";
        }
        return (String)this._division.id.get();
    }

    public boolean isEnterprise() {
        return this.getDatabase().isEnterprise();
    }

    public String getMember() {
        return this._member;
    }

    public String toString() {
        if (this.getMember() != null) {
            return this.getDatabaseId() + ":" + this.getCompanyId() + ":" + this.getDivisionId() + ":" + this.getMember();
        }
        return this.getDatabaseId() + ":" + this.getCompanyId() + ":" + this.getDivisionId();
    }

    void addPropertiesToEvent(EsbEvent esbEvent, String string) {
        this.addPropertyToEvent(esbEvent, string, "databaseId", this.getDatabaseId());
        this.addPropertyToEvent(esbEvent, string, "companyId", this.getCompanyId());
        this.addPropertyToEvent(esbEvent, string, "divisionId", this.getDivisionId());
        this.addPropertyToEvent(esbEvent, string, "member", this.getMember());
    }

    void addPropertyToEvent(EsbEvent esbEvent, String string, String string2, Object object) {
        if (object != null) {
            esbEvent.addRuntimeParameter(string + string2, object);
        }
    }

    @Override
    public int compareTo(EndPoint endPoint) {
        return ObjectX.compareTo((Object[])new Object[]{this.getDatabaseId(), this.getCompanyId(), this.getDivisionId(), this.getMember()}, (Object[])new Object[]{endPoint.getDatabaseId(), endPoint.getCompanyId(), endPoint.getDivisionId(), endPoint.getMember()});
    }

    public int hashCode() {
        String string = this.getDatabaseId();
        String string2 = this.getCompanyId();
        String string3 = this.getDivisionId();
        int n = 1;
        n = 31 * n + (string2 == null ? 0 : string2.hashCode());
        n = 31 * n + (string == null ? 0 : string.hashCode());
        n = 31 * n + (string3 == null ? 0 : string3.hashCode());
        n = 31 * n + (this._member == null ? 0 : this._member.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        EndPoint endPoint = (EndPoint)object;
        String string = this.getDatabaseId();
        String string2 = this.getCompanyId();
        String string3 = this.getDivisionId();
        String string4 = endPoint.getDatabaseId();
        String string5 = endPoint.getCompanyId();
        String string6 = endPoint.getDivisionId();
        if (string2 == null ? string5 != null : !string2.equals(string5)) {
            return false;
        }
        if (string == null ? string4 != null : !string.equals(string4)) {
            return false;
        }
        if (string3 == null ? string6 != null : !string3.equals(string6)) {
            return false;
        }
        return !(this._member == null ? endPoint._member != null : !this._member.equals(endPoint._member));
    }

    public Table getTable() {
        return this._template.getTable();
    }
}

