/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.esb.synch;

import com.ahsrcm.esb.ConnectionTransaction;
import com.ahsrcm.esb.EsbEvent;
import com.ahsrcm.esb.synch.Column;
import com.ahsrcm.esb.synch.MatchingRecordReader;
import com.ahsrcm.esb.synch.RecordSynch;
import com.ahsrcm.esb.synch.SynchEvent;
import com.ahsrcm.esb.synch.Synchronization;
import com.ahsrcm.esb.synch.Table;
import com.ahsrcm.esb.synch.routing.EndPoint;
import com.ahsrcm.esb.synch.routing.Route;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import java.util.concurrent.Callable;
import net.model3.collections.ListX;
import net.model3.collections.PropertiesX;
import net.model3.guice.DependencyInjector;
import net.model3.lang.StringX;
import net.model3.logging.Log;
import net.model3.logging.LogHelper;
import net.model3.transaction.TransactionManager;

public class TableSynch {
    private static final Log logger = LogHelper.getLog();
    private Synchronization _synchronization;
    private Route _route;
    @Inject
    TransactionManager _transactionManager;
    @Inject
    Injector _injector;

    public TableSynch(SynchEvent synchEvent, Route route) {
        DependencyInjector.inject((Object)this);
        this._route = route;
        this._synchronization = synchEvent.synchronization;
    }

    public void run() {
        logger.debug((Object)"performing table synch {} from ({}) to ({})", (Object)this._synchronization.getId(), (Object)this._route.from(), (Object)this._route.to());
        this._transactionManager.run((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ConnectionTransaction connectionTransaction = (ConnectionTransaction)TableSynch.this._injector.getInstance(ConnectionTransaction.class);
                Connection connection = connectionTransaction.getConnection(TableSynch.this._route.from());
                EsbEvent esbEvent = EsbEvent.get();
                TableSynch.this._route.addPropertiesToEvent(esbEvent);
                Connection connection2 = connectionTransaction.getConnection(TableSynch.this._route.to());
                TableSynch.this.doTableSynch(TableSynch.this._synchronization, connection, connection2);
                return null;
            }
        });
    }

    private void doTableSynch(Synchronization synchronization, Connection connection, Connection connection2) throws Exception {
        ResultSet resultSet = this.doQuery(synchronization, connection, synchronization.getFromTable(), this._route.from());
        ResultSet resultSet2 = this.doQuery(synchronization, connection2, synchronization.getToTable(), this._route.to());
        MatchingRecordReader matchingRecordReader = new MatchingRecordReader(resultSet, resultSet2, synchronization);
        RecordSynch recordSynch = new RecordSynch(connection2, this._route.to(), synchronization);
        matchingRecordReader.synchResultSets(recordSynch);
    }

    private ResultSet doQuery(Synchronization synchronization, Connection connection, Table table, EndPoint endPoint) throws Exception {
        Object object;
        String string = table.getSelectColumns();
        String string2 = table.getSelectKeys();
        List list = ListX.create();
        String string3 = "select " + string + " from " + table.getResolvedName(endPoint);
        Object object2 = "";
        if (StringX.isNotBlank((String)table.getWhereClause())) {
            object2 = PropertiesX.processStringForVariables((String)table.getWhereClause(), (boolean)true, (PropertiesX.VariableResolver)new PropertiesX.VariableResolver(){

                public Object getVariableValue(String string) {
                    return EsbEvent.get().getProperty(string);
                }
            });
        }
        for (Column column : table.getKeyColumns()) {
            if (!column.getSiblingColumn().isCalculatedValue()) continue;
            object = column.getName() + " = ?";
            list.add(column.getSiblingColumn().getValue(null));
            if (StringX.isNotBlank((String)object2)) {
                object2 = (String)object2 + " and " + (String)object;
                continue;
            }
            object2 = object;
        }
        if (StringX.isNotBlank((String)object2)) {
            string3 = string3 + " where " + (String)object2;
        }
        string3 = string3 + " order by " + string2;
        if (table.isOverrideDatabaseFileNeeded()) {
            table.createAlias(connection, endPoint);
        }
        PreparedStatement preparedStatement = connection.prepareStatement(string3);
        int n = 1;
        for (Object e : list) {
            preparedStatement.setObject(n, e);
            ++n;
        }
        object = preparedStatement.executeQuery();
        return object;
    }
}

