/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.esb.synch;

import com.ahsrcm.corp.Company;
import com.ahsrcm.corp.Database;
import com.ahsrcm.corp.Division;
import com.ahsrcm.esb.ConnectionTransaction;
import com.ahsrcm.esb.synch.TableInfo;
import com.ahsrcm.esb.synch.TableInfoPlugin;
import com.ahsrcm.esb.synch.routing.EndPoint;
import com.ahsrcm.esb.synch.routing.EndPointTemplate;
import com.google.inject.Singleton;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.java.dev.properties.jdbc.QueryForString;
import net.java.dev.properties.jdbc.SelectQuery;
import net.model3.collections.GeneratedMap;
import net.model3.collections.ListX;
import net.model3.lang.StringX;

@Singleton
public class TableInfoPluginImpl
implements TableInfoPlugin {
    Map<String, TableInfoImpl> _tableNameToTableInfoMap = new ConcurrentHashMap<String, TableInfoImpl>();

    @Override
    public TableInfo getTableInfo(String string, Database database) {
        TableInfoImpl tableInfoImpl = this._tableNameToTableInfoMap.get(string = string.toUpperCase());
        if (tableInfoImpl == null) {
            tableInfoImpl = new TableInfoImpl();
            tableInfoImpl._tableName = string;
            tableInfoImpl._databaseRelationColumn = this.getDatabaseRelationColumn(string, database);
            this._tableNameToTableInfoMap.put(string, tableInfoImpl);
        }
        return tableInfoImpl;
    }

    @Override
    public List<EndPoint> processEndPointsForMembers(List<EndPoint> list, EndPointTemplate endPointTemplate) {
        if (endPointTemplate.getTable().isOverrideDatabaseFileNeeded()) {
            return this.calculateEndPointsViaClientDatabase(list, endPointTemplate, ConnectionTransaction.get().getConnection(endPointTemplate.getDatabase()));
        }
        return list;
    }

    String getDatabaseRelationColumn(String string, Database database) {
        if (database.isClient()) {
            Connection connection = ConnectionTransaction.get().getConnection(database);
            return (String)new SelectQuery<String>("select OKDIV from o1pmbr where OKFIL = ?", connection, new Object[]{string}){

                protected String processRow(ResultSet resultSet) throws SQLException {
                    return resultSet.getString("OKDIV");
                }
            }.getResult();
        }
        return null;
    }

    List<EndPoint> calculateEndPointsViaClientDatabase(List<EndPoint> list, final EndPointTemplate endPointTemplate, Connection connection) {
        Object object2;
        GeneratedMap<Company, List<EndPoint>> generatedMap = new GeneratedMap<Company, List<EndPoint>>(){

            public List<EndPoint> generate(Company company) {
                return ListX.create();
            }
        };
        for (EndPoint object22 : list) {
            ((List)generatedMap.get(object22.getCompany())).add(object22);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Object object2 : generatedMap.keySet()) {
            List list2 = (List)generatedMap.get(object2);
            if (list2.size() <= 0) continue;
            if (stringBuilder.length() == 0) {
                stringBuilder.append(" and ( ");
            } else {
                stringBuilder.append(" or ");
            }
            stringBuilder.append("(a.CAOFX5 = '").append((String)((Company)object2).id.get()).append("' and a.CADIV in (");
            boolean bl = true;
            for (EndPoint endPoint : list2) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(",");
                }
                stringBuilder.append("'").append(endPoint.getDivisionId()).append("'");
            }
            stringBuilder.append("))");
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.append(" ) ");
        }
        String string = "CB" + endPointTemplate.getTable().getDatabaseRelationColumn();
        object2 = new SelectQuery<EndPoint>("select a.CAOFX5,a.CADIV," + string + " from C1PDIV a,C1PDBR,C1PDIV b where a.CADIV = CBDIV and b.CADIV = " + string + stringBuilder, connection){

            protected EndPoint processRow(ResultSet resultSet) throws SQLException {
                String string = StringX.trimRight((String)resultSet.getString(1));
                String string2 = StringX.trimRight((String)resultSet.getString(2));
                String string3 = StringX.trimRight((String)resultSet.getString(3));
                return new EndPoint(endPointTemplate, string, string2, string3);
            }
        }.getResults();
        return object2;
    }

    class TableInfoImpl
    implements TableInfo {
        String _tableName;
        String _databaseRelationColumn;
        Map<String, String> _members = new ConcurrentHashMap<String, String>();

        TableInfoImpl() {
        }

        @Override
        public String name() {
            return this._tableName;
        }

        @Override
        public String databaseRelationColumn() {
            return this._databaseRelationColumn;
        }

        @Override
        public boolean overrideDatabaseFileNeeded() {
            return this.databaseRelationColumn() != null;
        }

        @Override
        public String getMemberName(Division division, Connection connection) {
            String string = (String)((Company)division.company.get()).id.get() + ":" + (String)division.id.get();
            String string2 = this._members.get(string);
            if (string2 == null) {
                String string3 = "select CB" + this._databaseRelationColumn + " from c1pdbr where CBDIV = ?";
                string2 = (String)new QueryForString(string3, connection, new Object[]{division.id.get()}).getResult();
                this._members.put(string, string2);
            }
            return string2;
        }
    }
}

