/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.esb.synch;

import com.ahsrcm.esb.EsbEvent;
import com.ahsrcm.esb.synch.Column;
import com.ahsrcm.esb.synch.ColumnMapping;
import com.ahsrcm.esb.synch.Synchronization;
import com.ahsrcm.esb.synch.TableInfo;
import com.ahsrcm.esb.synch.TableInfoPlugin;
import com.ahsrcm.esb.synch.routing.EndPoint;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import net.model3.bean.converters.Converter;
import net.model3.bean.converters.ConverterAdapter;
import net.model3.collections.ListX;
import net.model3.guice.DependencyInjector;
import net.model3.jdbc.JdbcHelper;
import net.model3.lang.StringX;
import net.model3.util.StringJoiner;

public class Table {
    String name;
    String whereClause;
    Boolean addKeySelectionOnRecordSynch = true;
    List<Column> _insertColumns;
    List<Column> _nonKeyColumns;
    List<Column> _keyColumns;
    List<Column> _columns;
    boolean _fromTable;
    Synchronization _synchronization;
    TableInfo _tableInfo;

    public void setFromTable(boolean bl) {
        this._fromTable = bl;
    }

    public boolean isFromTable() {
        return this._fromTable;
    }

    public String getName() {
        return this.name;
    }

    public String getResolvedName(EndPoint endPoint) {
        if (this.isOverrideDatabaseFileNeeded()) {
            return "QTEMP/" + this.getName() + "_" + endPoint.getCompanyId() + "_" + endPoint.getDivisionId();
        }
        return this.getName();
    }

    TableInfo getTableInfo() {
        if (this._tableInfo == null) {
            this._tableInfo = ((TableInfoPlugin)DependencyInjector.getInstance(TableInfoPlugin.class)).getTableInfo(this.name, EsbEvent.get().getClientDatabase());
        }
        return this._tableInfo;
    }

    public boolean isOverrideDatabaseFileNeeded() {
        return this.getTableInfo().overrideDatabaseFileNeeded();
    }

    public String getDatabaseRelationColumn() {
        return this.getTableInfo().databaseRelationColumn();
    }

    public List<Column> getNonKeyColumns() {
        return this._nonKeyColumns;
    }

    public List<Column> getKeyColumns() {
        return this._keyColumns;
    }

    public List<Column> getColumns() {
        if (this._columns == null) {
            this._columns = ListX.create();
            this._columns.addAll(this.getNonKeyColumns());
            this._columns.addAll(this.getKeyColumns());
        }
        return this._columns;
    }

    public String getSelectColumns() {
        return new StringJoiner(this.getColumns(), ",", (Converter)new ConverterAdapter<Column>(){

            public String valueToString(Column column) {
                if (column.isCalculatedValue()) {
                    return null;
                }
                if (StringX.isNotBlank((String)column.getSqlExpression())) {
                    return column.getSqlExpression() + " as " + column.getName();
                }
                return column.getName();
            }
        }).toString();
    }

    public String getSelectKeys() {
        return new StringJoiner(this.getKeyColumns(), ",", (Converter)new ConverterAdapter<Column>(){

            public String valueToString(Column column) {
                if (column.isCalculatedValue()) {
                    return null;
                }
                return column.getName();
            }
        }).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createAlias(Connection connection, EndPoint endPoint) throws SQLException {
        if (this.isOverrideDatabaseFileNeeded()) {
            Statement statement = connection.createStatement();
            try {
                statement.execute("CREATE ALIAS " + this.getResolvedName(endPoint) + " FOR " + this.getName() + "(" + endPoint.getMember() + ")");
            }
            catch (SQLException sQLException) {
            }
            finally {
                JdbcHelper.close((Statement)statement);
            }
        }
    }

    public List<Column> getInsertColumns() {
        return this._insertColumns;
    }

    public void setSynchronization(Synchronization synchronization, boolean bl) {
        this._synchronization = synchronization;
        this._insertColumns = this.createColumnsFromMappings(this._synchronization.getInsertMappings(), bl);
        this._keyColumns = this.createColumnsFromMappings(this._synchronization.getKeyMappings(), bl);
        this._nonKeyColumns = this.createColumnsFromMappings(this._synchronization.getColumnMappings(), bl);
        this._fromTable = bl;
    }

    private List<Column> createColumnsFromMappings(List<ColumnMapping> list, boolean bl) {
        List list2 = ListX.create();
        for (ColumnMapping columnMapping : list) {
            String string;
            String string2 = null;
            if (bl) {
                string = columnMapping.getFrom();
                string2 = columnMapping.getFromExpression();
            } else {
                string = columnMapping.getTo();
            }
            Column column = new Column(columnMapping, string, string2);
            list2.add(column);
            if (bl) {
                columnMapping.setFromColumn(column);
                continue;
            }
            columnMapping.setToColumn(column);
        }
        return list2;
    }

    public String getWhereClause() {
        return this.whereClause;
    }

    public boolean addKeySelectionOnRecordSynch() {
        if (this.addKeySelectionOnRecordSynch == null) {
            this.addKeySelectionOnRecordSynch = true;
        }
        return this.addKeySelectionOnRecordSynch;
    }
}

