/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.esb.synch;

import com.ahsrcm.esb.synch.ColumnMapping;
import com.ahsrcm.esb.synch.Table;
import com.ahsrcm.esb.synch.routing.Routing;
import com.ahsrcm.esb.synch.routing.SynchPer;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.util.List;
import java.util.Set;
import net.java.dev.properties.container.BeanContainer;
import net.model3.collections.CaseInsensitiveSetWrapper;
import net.model3.collections.ListX;
import net.model3.guice.DependencyInjector;
import net.model3.lang.StringX;
import net.model3.logging.Log;
import net.model3.logging.LogHelper;

@XStreamAlias(value="synchronization")
public class Synchronization {
    private static final Log logger = LogHelper.getLog();
    private String id;
    @XStreamAlias(value="routing")
    private Routing _routing;
    @XStreamAlias(value="synchPer")
    SynchPer _synchPer;
    private Table fromTable;
    private Table toTable;
    @XStreamImplicit(itemFieldName="insertColumn")
    private List<ColumnMapping> _insertMappings;
    @XStreamImplicit(itemFieldName="column")
    private List<ColumnMapping> _columnMappings;
    @XStreamImplicit(itemFieldName="keyColumn")
    private List<ColumnMapping> _keyMappings;
    private boolean insert = true;
    private boolean update = true;
    private boolean delete = true;
    private String auditColumnPrefix;
    @XStreamAlias(value="categories")
    private String _categoriesAsCommaSeparatedList;
    private Set<String> _categories;

    public Synchronization() {
        BeanContainer.bind((Object)this);
        DependencyInjector.inject((Object)this);
    }

    public String getId() {
        return this.id;
    }

    public Set<String> getCategories() {
        if (this._categories == null) {
            this._categories = Synchronization.convertCategoryStringToSet(this._categoriesAsCommaSeparatedList);
        }
        return this._categories;
    }

    public static Set<String> convertCategoryStringToSet(String string) {
        CaseInsensitiveSetWrapper caseInsensitiveSetWrapper = new CaseInsensitiveSetWrapper();
        if (StringX.isNotBlank((String)string)) {
            for (String string2 : string.split(",")) {
                if (!StringX.isNotBlank((String)(string2 = string2.trim()))) continue;
                caseInsensitiveSetWrapper.add(string2);
            }
        }
        return caseInsensitiveSetWrapper;
    }

    public void init() {
        if (this._insertMappings == null) {
            this._insertMappings = ListX.create();
        }
        if (StringX.isNotBlank((String)this.auditColumnPrefix)) {
            this.getColumnMappings().add(new ColumnMapping(":nowDate", this.auditColumnPrefix + "DATL"));
            this.getColumnMappings().add(new ColumnMapping(":nowTime", this.auditColumnPrefix + "TIML"));
            this.getColumnMappings().add(new ColumnMapping(":esbUser", this.auditColumnPrefix + "USRL"));
            this.getInsertMappings().add(new ColumnMapping(":nowDate", this.auditColumnPrefix + "DATE"));
            this.getInsertMappings().add(new ColumnMapping(":nowTime", this.auditColumnPrefix + "TIME"));
            this.getInsertMappings().add(new ColumnMapping(":esbUser", this.auditColumnPrefix + "USRE"));
        }
        this.setToTable(this.toTable);
        this.setFromTable(this.fromTable);
        if (this._columnMappings == null) {
            this._columnMappings = ListX.create();
        }
        if (this._keyMappings == null) {
            this._keyMappings = ListX.create();
        }
    }

    public List<ColumnMapping> getColumnMappings() {
        return this._columnMappings;
    }

    public List<ColumnMapping> getKeyMappings() {
        return this._keyMappings;
    }

    public Table getFromTable() {
        return this.fromTable;
    }

    public void setFromTable(Table table) {
        this.fromTable = table;
        if (table != null) {
            table.setSynchronization(this, true);
        }
    }

    public Table getToTable() {
        return this.toTable;
    }

    public void setToTable(Table table) {
        this.toTable = table;
        if (table != null) {
            table.setSynchronization(this, false);
        }
    }

    public boolean doInserts() {
        return this.insert;
    }

    public boolean doUpdates() {
        return this.update;
    }

    public List<ColumnMapping> getInsertMappings() {
        return this._insertMappings;
    }

    public boolean doDeletes() {
        return this.delete;
    }

    public Routing getRouting() {
        return this._routing;
    }

    public String toString() {
        return this.getId();
    }

    public SynchPer getSynchPer() {
        if (this._synchPer == null) {
            this._synchPer = SynchPer.Database;
        }
        return this._synchPer;
    }

    static {
        logger.toString();
    }
}

