/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.esb.synch;

import com.ahsrcm.corp.Company;
import com.ahsrcm.corp.Database;
import com.ahsrcm.esb.EsbEvent;
import com.ahsrcm.esb.synch.Synchronization;
import com.ahsrcm.esb.synch.routing.EndPoint;
import com.ahsrcm.esb.synch.routing.EndPointTemplate;
import com.ahsrcm.esb.synch.routing.Route;
import java.util.List;
import net.model3.collections.ListX;
import net.model3.lang.StringX;

public class SynchEvent {
    private static final ThreadLocal<SynchEvent> context = new ThreadLocal();
    public final Synchronization synchronization;
    public final EsbEvent event;
    private transient EndPointTemplate _from;
    private transient EndPointTemplate _to;

    public static SynchEvent get() {
        if (context.get() == null) {
            throw new RuntimeException("no synch event found");
        }
        return context.get();
    }

    public static SynchEvent set(EsbEvent esbEvent, Synchronization synchronization) {
        context.set(new SynchEvent(synchronization, esbEvent));
        return SynchEvent.get();
    }

    public static void reset() {
        context.remove();
    }

    private SynchEvent(Synchronization synchronization, EsbEvent esbEvent) {
        this.synchronization = synchronization;
        this.event = esbEvent;
    }

    public List<Company> getCompanies() {
        if (StringX.isBlank((String)((String)this.event.companyId.get()))) {
            return this.event.getClientDatabase().companies.get();
        }
        return ListX.create((Object[])new Company[]{this.event.getCompany()});
    }

    public Iterable<Route> getRoutes() {
        List list = ListX.create();
        List<EndPoint> list2 = this.synchronization.getSynchPer().getEndPoints(this.getFromTemplate());
        List<EndPoint> list3 = this.synchronization.getSynchPer().getEndPoints(this.getToTemplate());
        block0: for (EndPoint endPoint : list2) {
            for (EndPoint endPoint2 : list3) {
                if (!endPoint2.getCompanyId().equals(endPoint.getCompanyId()) || !endPoint2.getDivisionId().equals(endPoint.getDivisionId())) continue;
                list.add(new Route(endPoint, endPoint2));
                continue block0;
            }
        }
        return list;
    }

    public EndPointTemplate getFromTemplate() {
        if (this._from == null) {
            this._from = new EndPointTemplate(this, (String)this.event.fromDatabaseId.get(), (String)this.event.companyId.get(), (String)this.event.divisionId.get(), this.synchronization.getFromTable());
        }
        return this._from;
    }

    public EndPointTemplate getToTemplate() {
        if (this._to == null) {
            if (StringX.isBlank((String)((String)this.event.toDatabaseId.get()))) {
                if (this.getFromTemplate().getDatabase().isEnterprise()) {
                    this.event.toDatabaseId.set((Object)((String)((Database)this.event.getCompany().database.get()).id.get()));
                } else {
                    this.event.toDatabaseId.set((Object)((String)Database.getEnterpriseDatabase().id.get()));
                }
            }
            this._to = new EndPointTemplate(this, (String)this.event.toDatabaseId.get(), (String)this.event.companyId.get(), (String)this.event.divisionId.get(), this.synchronization.getToTable());
        }
        return this._to;
    }
}

