/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.esb.synch;

import com.ahsrcm.esb.synch.Column;
import com.ahsrcm.esb.synch.Synchronization;
import com.ahsrcm.esb.synch.Table;
import com.ahsrcm.esb.synch.routing.EndPoint;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import net.model3.guice.DependencyInjector;
import net.model3.logging.Log;
import net.model3.logging.LogHelper;

public class RecordSynch {
    private static final Log logger = LogHelper.getLog();
    private Synchronization _synchronization;
    private Connection _toConnection;
    private EndPoint _toRoute;
    private int _batchSize = 2000;
    private StatementBatcher _inserter = new StatementBatcher();
    private StatementBatcher _updater = new StatementBatcher();
    private StatementBatcher _deleter = new StatementBatcher();

    public RecordSynch(Connection connection, EndPoint endPoint, Synchronization synchronization) {
        DependencyInjector.inject((Object)this);
        this._toConnection = connection;
        this._synchronization = synchronization;
        this._toRoute = endPoint;
    }

    public void insert(ResultSet resultSet) throws Exception {
        PreparedStatement preparedStatement = this.getInsertStatement();
        Table table = this._synchronization.getFromTable();
        this.appendValues(resultSet, table.getColumns(), preparedStatement, 1);
        this.appendValues(resultSet, table.getInsertColumns(), preparedStatement, table.getColumns().size() + 1);
        this.processBatching("insert(s)", this._inserter, true);
    }

    void processBatching(String string, StatementBatcher statementBatcher, boolean bl) throws Exception {
        if (bl) {
            statementBatcher._statement.addBatch();
            ++statementBatcher._count;
        }
        if (statementBatcher._count >= this._batchSize) {
            logger.debug((Object)"executing {} {} on {}", (Object)statementBatcher._count, (Object)string, (Object)this._toRoute);
            statementBatcher._statement.executeBatch();
            statementBatcher._statement.clearBatch();
            statementBatcher._count = 0;
        }
    }

    PreparedStatement getInsertStatement() throws Exception {
        if (this._inserter._statement == null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("insert into " + this._synchronization.getToTable().getResolvedName(this._toRoute) + " (");
            boolean bl = true;
            StringBuilder stringBuilder2 = new StringBuilder();
            for (Column column : this._synchronization.getToTable().getColumns()) {
                if (!bl) {
                    stringBuilder.append(",");
                    stringBuilder2.append(",");
                }
                bl = false;
                stringBuilder.append(column.getName());
                stringBuilder2.append("?");
            }
            for (Column column : this._synchronization.getToTable().getInsertColumns()) {
                if (!bl) {
                    stringBuilder.append(",");
                    stringBuilder2.append(",");
                }
                bl = false;
                stringBuilder.append(column.getName());
                stringBuilder2.append("?");
            }
            stringBuilder.append(") VALUES( ");
            stringBuilder.append((CharSequence)stringBuilder2);
            stringBuilder.append(")");
            this._inserter._statement = this._toConnection.prepareStatement(stringBuilder.toString());
        }
        return this._inserter._statement;
    }

    public void delete(ResultSet resultSet) throws Exception {
        PreparedStatement preparedStatement = this.getDeleteStatement();
        StringBuilder stringBuilder = new StringBuilder();
        int n = 1;
        for (Column column : this._synchronization.getToTable().getKeyColumns()) {
            Object object = column.getValue(resultSet);
            stringBuilder.append(" " + object);
            preparedStatement.setObject(n, object);
            ++n;
        }
        logger.info((Object)("deleting " + stringBuilder));
        this.processBatching("delete(s)", this._deleter, true);
    }

    PreparedStatement getDeleteStatement() throws SQLException {
        if (this._deleter._statement == null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("delete from " + this._synchronization.getToTable().getResolvedName(this._toRoute) + " where ");
            boolean bl = true;
            for (Column column : this._synchronization.getToTable().getKeyColumns()) {
                if (!bl) {
                    stringBuilder.append(" and ");
                }
                bl = false;
                stringBuilder.append(column.getName());
                stringBuilder.append(" = ?");
            }
            this._deleter._statement = this._toConnection.prepareStatement(stringBuilder.toString());
        }
        return this._deleter._statement;
    }

    private void appendValues(ResultSet resultSet, List<Column> list, PreparedStatement preparedStatement, int n) throws SQLException {
        int n2 = n;
        for (Column column : list) {
            Object object = column.getValue(resultSet);
            preparedStatement.setObject(n2, object);
            ++n2;
        }
    }

    public void update(ResultSet resultSet) throws Exception {
        PreparedStatement preparedStatement = this.getUpdateStatement();
        this.appendValues(resultSet, this._synchronization.getFromTable().getNonKeyColumns(), preparedStatement, 1);
        this.appendValues(resultSet, this._synchronization.getFromTable().getKeyColumns(), preparedStatement, this._synchronization.getFromTable().getNonKeyColumns().size() + 1);
        this.processBatching("update(s)", this._updater, true);
    }

    public PreparedStatement getUpdateStatement() throws SQLException {
        if (this._updater._statement == null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("update " + this._synchronization.getToTable().getResolvedName(this._toRoute) + " set ");
            boolean bl = true;
            for (Column column : this._synchronization.getToTable().getNonKeyColumns()) {
                if (!bl) {
                    stringBuilder.append(", ");
                }
                bl = false;
                stringBuilder.append(column.getName());
                stringBuilder.append(" = ");
                stringBuilder.append("?");
            }
            stringBuilder.append(" where ");
            bl = true;
            for (Column column : this._synchronization.getToTable().getKeyColumns()) {
                if (!bl) {
                    stringBuilder.append(" and ");
                }
                bl = false;
                stringBuilder.append(column.getName());
                stringBuilder.append(" = ");
                stringBuilder.append("?");
            }
            this._updater._statement = this._toConnection.prepareStatement(stringBuilder.toString());
        }
        return this._updater._statement;
    }

    public void executeUnfinishedBatches() throws Exception {
        int n = this._batchSize;
        this._batchSize = 1;
        this.processBatching("delete(s)", this._deleter, false);
        this.processBatching("insert(s)", this._inserter, false);
        this.processBatching("update(s)", this._updater, false);
        this._batchSize = n;
    }

    static {
        logger.toString();
    }

    class StatementBatcher {
        PreparedStatement _statement;
        int _count = 0;

        StatementBatcher() {
        }
    }
}

