/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.esb.synch;

import com.google.inject.Singleton;
import com.ibm.as400.access.AS400Bin2;
import com.ibm.as400.access.AS400Bin4;
import com.ibm.as400.access.AS400Bin8;
import com.ibm.as400.access.AS400PackedDecimal;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.AS400ZonedDecimal;
import com.ibm.as400.access.BinaryFieldDescription;
import com.ibm.as400.access.CharacterFieldDescription;
import com.ibm.as400.access.FieldDescription;
import com.ibm.as400.access.PackedDecimalFieldDescription;
import com.ibm.as400.access.RecordFormat;
import com.ibm.as400.access.ZonedDecimalFieldDescription;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Singleton
public class RecordFormatFactory {
    private final ColumnType[] HANDLERS = new ColumnType[]{new AlhpaColumnType(), new ZonedDecimaldColumnType(), new PackedDecimaldColumnType(), new BinaryColumnType()};

    public FieldDescription getFieldDescription(String string, String string2) {
        for (ColumnType columnType : this.HANDLERS) {
            FieldDescription fieldDescription = columnType.getFieldDescription(string2, string);
            if (fieldDescription == null) continue;
            return fieldDescription;
        }
        return null;
    }

    public RecordFormat convertFieldTypesToRecordFormat(List<String> list, String string) {
        RecordFormat recordFormat = new RecordFormat();
        int n = 0;
        for (String string2 : list) {
            FieldDescription fieldDescription = this.getFieldDescription(string + ++n, string2);
            recordFormat.addFieldDescription(fieldDescription);
        }
        return recordFormat;
    }

    class BinaryColumnType
    extends ColumnType {
        BinaryColumnType() {
            super("(\\d+)b");
        }

        @Override
        FieldDescription createFieldDescription(String[] stringArray, String string) {
            int n = Integer.parseInt(stringArray[1]);
            if (n == 4) {
                return new BinaryFieldDescription(new AS400Bin2(), string);
            }
            if (n == 8) {
                return new BinaryFieldDescription(new AS400Bin4(), string);
            }
            if (n == 16) {
                return new BinaryFieldDescription(new AS400Bin8(), string);
            }
            throw new RuntimeException("invalid field length " + n);
        }
    }

    class PackedDecimaldColumnType
    extends ColumnType {
        PackedDecimaldColumnType() {
            super("(\\d+)p(\\d)");
        }

        @Override
        FieldDescription createFieldDescription(String[] stringArray, String string) {
            int n = Integer.parseInt(stringArray[1]);
            int n2 = Integer.parseInt(stringArray[2]);
            return new PackedDecimalFieldDescription(new AS400PackedDecimal(n, n2), string);
        }
    }

    class ZonedDecimaldColumnType
    extends ColumnType {
        ZonedDecimaldColumnType() {
            super("(\\d+)s(\\d)");
        }

        @Override
        FieldDescription createFieldDescription(String[] stringArray, String string) {
            int n = Integer.parseInt(stringArray[1]);
            int n2 = Integer.parseInt(stringArray[2]);
            return new ZonedDecimalFieldDescription(new AS400ZonedDecimal(n, n2), string);
        }
    }

    class AlhpaColumnType
    extends ColumnType {
        AlhpaColumnType() {
            super("(\\d+)a");
        }

        @Override
        FieldDescription createFieldDescription(String[] stringArray, String string) {
            int n = Integer.parseInt(stringArray[1]);
            return new CharacterFieldDescription(new AS400Text(n), string);
        }
    }

    abstract class ColumnType {
        Pattern _definitionPattern;

        ColumnType(String string) {
            this._definitionPattern = Pattern.compile(string);
        }

        Matcher matches(String string) {
            return this._definitionPattern.matcher(string);
        }

        FieldDescription getFieldDescription(String string, String string2) {
            Matcher matcher = this._definitionPattern.matcher(string);
            if (!matcher.matches()) {
                return null;
            }
            String[] stringArray = new String[matcher.groupCount() + 1];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = matcher.group(i);
            }
            return this.createFieldDescription(stringArray, string2);
        }

        abstract FieldDescription createFieldDescription(String[] var1, String var2);
    }
}

