/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.esb.synch;

import com.ahsrcm.esb.synch.Column;
import com.ahsrcm.esb.synch.EbcdicStringCompare;
import com.ahsrcm.esb.synch.RecordSynch;
import com.ahsrcm.esb.synch.Synchronization;
import com.ahsrcm.esb.synch.Table;
import java.sql.ResultSet;
import net.model3.lang.ExceptionPropagator;
import net.model3.lang.ObjectX;
import net.model3.lang.StringX;

public class MatchingRecordReader {
    private Synchronization _synchronization;
    private ResultSet _fromResultSet;
    private ResultSet _toResultSet;
    private Key _currentFrom;
    private Key _currentTo;
    private MatchingRecord _currentMatching;

    public MatchingRecordReader(ResultSet resultSet, ResultSet resultSet2, Synchronization synchronization) {
        this._fromResultSet = resultSet;
        this._synchronization = synchronization;
        this._toResultSet = resultSet2;
    }

    public MatchingRecord nextRecord() {
        if (this._currentMatching == null) {
            this._currentMatching = new MatchingRecord();
            this.incrementFrom();
            this.incrementTo();
        } else {
            if (this._currentMatching.hasFrom()) {
                this.incrementFrom();
            }
            if (this._currentMatching.hasTo()) {
                this.incrementTo();
            }
        }
        int n = this._currentFrom != null && this._currentTo != null ? this._currentFrom.compareTo(this._currentTo) : (this._currentFrom == null ? 1 : -1);
        this._currentMatching._fromKey = this._currentFrom;
        this._currentMatching._toKey = this._currentTo;
        if (n > 0) {
            this._currentMatching._fromKey = null;
        } else if (n < 0) {
            this._currentMatching._toKey = null;
        }
        if (this._currentFrom == null && this._currentTo == null) {
            return null;
        }
        return this._currentMatching;
    }

    void incrementFrom() {
        this._currentFrom = this.incremement(this._fromResultSet, this._synchronization.getFromTable());
    }

    void incrementTo() {
        this._currentTo = this.incremement(this._toResultSet, this._synchronization.getToTable());
    }

    Key incremement(ResultSet resultSet, Table table) {
        try {
            if (resultSet.next()) {
                int n = table.getKeyColumns().size();
                Key key = new Key();
                Key.access$202(key, new Comparable[n]);
                for (int i = 0; i < n; ++i) {
                    Column column = table.getKeyColumns().get(i);
                    ((Key)key)._columns[i] = (Comparable)column.getValue(resultSet);
                }
                return key;
            }
            return null;
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap((Throwable)exception);
        }
    }

    public void synchResultSets(RecordSynch recordSynch) throws Exception {
        MatchingRecord matchingRecord;
        while ((matchingRecord = this.nextRecord()) != null) {
            if (matchingRecord.hasBoth()) {
                if (!this._synchronization.doUpdates() || !matchingRecord.needsUpdate()) continue;
                recordSynch.update(this._fromResultSet);
                continue;
            }
            if (matchingRecord.hasFrom()) {
                if (!this._synchronization.doInserts()) continue;
                recordSynch.insert(this._fromResultSet);
                continue;
            }
            if (matchingRecord.hasTo()) {
                if (!this._synchronization.doDeletes()) continue;
                recordSynch.delete(this._toResultSet);
                continue;
            }
            throw new RuntimeException("this should never happen");
        }
        recordSynch.executeUnfinishedBatches();
    }

    public class Key {
        private Comparable[] _columns;

        int compareTo(Key key) {
            for (int i = 0; i < this._columns.length; ++i) {
                int n;
                Object object = this._columns[i];
                Object object2 = key._columns[i];
                if (object instanceof String) {
                    object = StringX.trimRight((String)((String)object));
                    object2 = StringX.trimRight((String)((String)object2));
                    n = EbcdicStringCompare.compare((String)object, (String)object2);
                } else {
                    n = object.compareTo(object2);
                }
                if (n == 0) continue;
                return n;
            }
            return 0;
        }

        public String toString() {
            return StringX.arrayToString((Object[])this._columns, (boolean)true);
        }

        static /* synthetic */ Comparable[] access$202(Key key, Comparable[] comparableArray) {
            key._columns = comparableArray;
            return comparableArray;
        }
    }

    public class MatchingRecord {
        private Key _fromKey;
        private Key _toKey;

        public boolean hasBoth() {
            return this.hasTo() && this.hasFrom();
        }

        public boolean hasTo() {
            return this._toKey != null;
        }

        public boolean hasFrom() {
            return this._fromKey != null;
        }

        public boolean needsUpdate() {
            try {
                for (Column column : MatchingRecordReader.this._synchronization.getFromTable().getNonKeyColumns()) {
                    Column column2 = column.getSiblingColumn();
                    if (column.isCalculatedValue() || column2.isCalculatedValue()) continue;
                    Object object = column.getValue(MatchingRecordReader.this._fromResultSet);
                    Object object2 = column2.getValue(MatchingRecordReader.this._toResultSet);
                    if (object instanceof String && object2 instanceof String) {
                        object2 = StringX.trimRight((String)((String)object2));
                        object = StringX.trimRight((String)((String)object));
                    }
                    if (ObjectX.equals((Object)object, (Object)object2)) continue;
                    return true;
                }
                return false;
            }
            catch (Exception exception) {
                throw ExceptionPropagator.wrap((Throwable)exception);
            }
        }
    }
}

