/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.esb.synch;

import com.ahsrcm.esb.EsbEvent;
import com.ahsrcm.esb.synch.ColumnMapping;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.model3.lang.StringX;

public class Column {
    private final String name;
    private final String sqlExpression;
    private final ColumnMapping columnMapping;

    public Column(ColumnMapping columnMapping, String string, String string2) {
        this.columnMapping = columnMapping;
        this.name = string;
        this.sqlExpression = string2;
    }

    public ColumnMapping getColumnMapping() {
        return this.columnMapping;
    }

    public String getSqlExpression() {
        return this.sqlExpression;
    }

    public String getName() {
        return this.name;
    }

    public boolean isProperty() {
        return this.name.startsWith(":");
    }

    public boolean isStringLiteral() {
        return this.name.startsWith("\"");
    }

    public boolean isNumericLiteral() {
        return Character.isDigit(this.name.charAt(0));
    }

    public boolean isCalculatedValue() {
        return this.isStringLiteral() || this.isNumericLiteral() || this.isProperty();
    }

    public Object getCalculatedValue() {
        if (this.isStringLiteral()) {
            return StringX.unQuote((String)this.name);
        }
        if (this.isNumericLiteral()) {
            return new BigDecimal(this.name);
        }
        if (this.isProperty()) {
            String string = this.name.substring(1);
            return EsbEvent.get().getProperties().get(string);
        }
        return null;
    }

    public Object getValue(ResultSet resultSet) throws SQLException {
        if (this.isCalculatedValue()) {
            return this.getCalculatedValue();
        }
        return resultSet.getObject(this.name);
    }

    public Column getSiblingColumn() {
        if (this.columnMapping.getFromColumn() == this) {
            return this.columnMapping.getToColumn();
        }
        if (this.columnMapping.getToColumn() == this) {
            return this.columnMapping.getFromColumn();
        }
        throw new RuntimeException("unable to find sibling column");
    }

    public String toString() {
        return this.name;
    }
}

