/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.esb.dataqueue;

import com.ahsrcm.esb.synch.RecordFormatFactory;
import com.ibm.as400.access.FieldDescription;
import com.ibm.as400.access.RecordFormat;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.util.List;
import net.model3.collections.ListX;
import net.model3.guice.DependencyInjector;

@XStreamAlias(value="dataStructure")
public class ISeriesDataStructure {
    private int version;
    @XStreamImplicit(itemFieldName="field")
    private List<Field> _fields = ListX.create();
    private Integer _length;
    private RecordFormat _recordFormat;

    public ISeriesDataStructure() {
    }

    ISeriesDataStructure(int n) {
        this.version = n;
    }

    public List<Field> getFields() {
        return this._fields;
    }

    public int getLength() {
        if (this._length == null) {
            int n = 0;
            for (Field field : this.getFields()) {
                n += field.getFieldDescription().getDataType().getByteLength();
            }
            this._length = n;
        }
        return this._length;
    }

    public int getVersion() {
        return this.version;
    }

    public void addField(String string, String string2) {
        this.getFields().add(new Field(string, string2));
    }

    public RecordFormat asRecordFormat() {
        if (this._recordFormat == null) {
            RecordFormat recordFormat = new RecordFormat();
            for (Field field : this._fields) {
                recordFormat.addFieldDescription(field.getFieldDescription());
            }
            this._recordFormat = recordFormat;
        }
        return this._recordFormat;
    }

    @XStreamAlias(value="fieldFormat")
    public static class Field {
        private String name;
        private String type;

        public Field() {
        }

        private Field(String string, String string2) {
            this.name = string;
            this.type = string2;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public FieldDescription getFieldDescription() {
            RecordFormatFactory recordFormatFactory = (RecordFormatFactory)DependencyInjector.get().getInstance(RecordFormatFactory.class);
            return recordFormatFactory.getFieldDescription(this.name.toUpperCase(), this.type);
        }
    }
}

