/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.esb.dataqueue;

import net.java.dev.properties.jdbc.handlers.DefaultTypeHandler;
import net.java.dev.properties.jdbc.handlers.ObjectToStringHandler;

@DefaultTypeHandler(value=OrmHandler.class)
public enum DataQueueStatus {
    Disabled(" "),
    Reading("R"),
    Processing("P"),
    Down("D");

    String _vmDatabaseFlag;

    private DataQueueStatus(String string2) {
        this._vmDatabaseFlag = string2;
    }

    public String getVmDatabaseFlag() {
        return this._vmDatabaseFlag;
    }

    public boolean isProcessing() {
        return this == Processing;
    }

    public boolean isReadingAllowed() {
        return this == Reading || this == Processing;
    }

    public boolean isRunning() {
        return this.isReadingAllowed();
    }

    public static DataQueueStatus get(String string) {
        for (DataQueueStatus dataQueueStatus : DataQueueStatus.values()) {
            if (!dataQueueStatus.getVmDatabaseFlag().equals(string)) continue;
            return dataQueueStatus;
        }
        return Disabled;
    }

    public static class OrmHandler
    extends ObjectToStringHandler<DataQueueStatus> {
        public String convertObjectToString(DataQueueStatus dataQueueStatus) {
            return dataQueueStatus.getVmDatabaseFlag();
        }

        public DataQueueStatus convertStringToObject(String string) {
            return DataQueueStatus.get(string);
        }
    }
}

