/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.esb.dataqueue;

import com.ibm.as400.access.FieldDescription;
import com.ibm.as400.access.Record;
import com.ibm.as400.access.RecordFormat;
import java.math.BigDecimal;
import net.model3.lang.ClassX;
import net.model3.lang.ExceptionPropagator;

public abstract class DataQueueRecord {
    RecordFormat _format;
    int _formatLength;
    private Record _record;
    private byte[] _eventData;

    public DataQueueRecord(RecordFormat recordFormat) {
        try {
            this.initFormat(recordFormat);
            this._record = this._format.getNewRecord();
            this._eventData = new byte[0];
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap((Throwable)exception);
        }
    }

    protected String getStringField(String string) {
        int n = this._format.getIndexOfFieldName(string);
        if (n > 0) {
            try {
                String string2 = (String)this._record.getField(n);
                return string2.trim();
            }
            catch (Exception exception) {
                throw ExceptionPropagator.wrap((Throwable)exception);
            }
        }
        return null;
    }

    public DataQueueRecord(RecordFormat recordFormat, byte[] byArray) {
        try {
            this.initFormat(recordFormat);
            this._record = this._format.getNewRecord(byArray);
            this._eventData = new byte[byArray.length - this._formatLength];
            System.arraycopy(byArray, this._formatLength, this._eventData, 0, this._eventData.length);
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap((Throwable)exception);
        }
    }

    public String getFromDatabase() {
        try {
            return ((String)this._record.getField("FROM_DB")).trim();
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap((Throwable)exception);
        }
    }

    public void setFromDatabase(String string) {
        try {
            this._record.setField("FROM_DB", (Object)string);
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap((Throwable)exception);
        }
    }

    public String getProgram() {
        try {
            return ((String)this._record.getField("PROGRAM")).trim();
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap((Throwable)exception);
        }
    }

    public void setProgram(String string) {
        try {
            this._record.setField("PROGRAM", (Object)string);
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap((Throwable)exception);
        }
    }

    public String getUid() {
        try {
            return ((String)this._record.getField("UID")).trim();
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap((Throwable)exception);
        }
    }

    public void setUid(String string) {
        try {
            this._record.setField("UID", (Object)string);
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap((Throwable)exception);
        }
    }

    public String getToDatabase() {
        try {
            return ((String)this._record.getField("TO_DB")).trim();
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap((Throwable)exception);
        }
    }

    public void setToDatabase(String string) {
        try {
            this._record.setField("TO_DB", (Object)string);
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap((Throwable)exception);
        }
    }

    private void initFormat(RecordFormat recordFormat) {
        this._format = recordFormat;
        for (FieldDescription fieldDescription : this._format.getFieldDescriptions()) {
            this._formatLength += fieldDescription.getLength();
        }
    }

    public Record getRecord() {
        return this._record;
    }

    public void setFormatId(String string) {
        try {
            this._record.setField("FORMATID", (Object)string);
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap((Throwable)exception);
        }
    }

    public String getFormatId() {
        try {
            return ((String)this._record.getField("FORMATID")).trim();
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap((Throwable)exception);
        }
    }

    public void setCompany(String string) {
        try {
            this._record.setField("COMPANY", (Object)string);
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap((Throwable)exception);
        }
    }

    public String getCompany() {
        try {
            return ((String)this._record.getField("COMPANY")).trim();
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap((Throwable)exception);
        }
    }

    public void setDivision(String string) {
        try {
            this._record.setField("DIVISION", (Object)string);
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap((Throwable)exception);
        }
    }

    public String getDivision() {
        try {
            return ((String)this._record.getField("DIVISION")).trim();
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap((Throwable)exception);
        }
    }

    public void setEventData(byte[] byArray) {
        this._eventData = byArray;
    }

    public byte[] getEventData() {
        return this._eventData;
    }

    public byte[] asByteArray() {
        try {
            byte[] byArray = new byte[this._formatLength + this._eventData.length];
            System.arraycopy(this._record.getContents(), 0, byArray, 0, this._formatLength);
            System.arraycopy(this._eventData, 0, byArray, this._formatLength, this._eventData.length);
            return byArray;
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap((Throwable)exception);
        }
    }

    public void setAction(String string) {
        try {
            this._record.setField("ACTION", (Object)string);
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap((Throwable)exception);
        }
    }

    public String getAction() {
        try {
            return ((String)this._record.getField("ACTION")).trim();
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap((Throwable)exception);
        }
    }

    public void setVersion(int n) {
        try {
            this._record.setField("VERSION", (Object)BigDecimal.valueOf(n));
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap((Throwable)exception);
        }
    }

    public int getVersion() {
        try {
            return ((BigDecimal)this._record.getField("VERSION")).intValue();
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap((Throwable)exception);
        }
    }

    public void setDataVersion(int n) {
        try {
            this._record.setField("DATAVERSION", (Object)BigDecimal.valueOf(n));
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap((Throwable)exception);
        }
    }

    public int getDataVersion() {
        try {
            return ((BigDecimal)this._record.getField("DATAVERSION")).intValue();
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap((Throwable)exception);
        }
    }

    public String toString() {
        return ClassX.getShortName(this.getClass()) + "[" + this.getAction() + "," + this.getFormatId() + "]";
    }
}

