/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.esb.dataqueue;

import com.ahsrcm.corp.Database;
import com.ahsrcm.esb.dataqueue.DataQueueReader;
import com.google.inject.Singleton;
import java.util.List;
import java.util.Map;
import net.java.dev.properties.jdbc.CurrentSession;
import net.model3.collections.GeneratedMap;
import net.model3.collections.ListX;
import net.model3.lang.TimeDuration;
import net.model3.logging.Log;
import net.model3.logging.LogHelper;

@Singleton
public class DataQueueReaderManager
implements Runnable {
    private static final Log logger = LogHelper.getLog();
    private Map<String, List<DataQueueReader>> _dataQueueReaderMap = new GeneratedMap<String, List<DataQueueReader>>(){

        public List<DataQueueReader> generate(String string) {
            return ListX.create();
        }
    };
    private TimeDuration _frequency = new TimeDuration("2 minutes");

    public void start() {
        new Thread((Runnable)this, "DataQueueReaderManager").start();
    }

    @Override
    public void run() {
        for (Database database : Database.selectAll()) {
            logger.debug((Object)"{} {}", database.id.get(), database.esbEnabled);
            int n = 1;
            this._dataQueueReaderMap.get(database.id.get()).clear();
            for (int i = 0; i < n; ++i) {
                this._dataQueueReaderMap.get(database.id.get()).add(new DataQueueReader(database));
            }
        }
        while (true) {
            try {
                while (true) {
                    this.checkAndUpdateStatusForAll();
                    this._frequency.sleep();
                }
            }
            catch (Throwable throwable) {
                logger.error((Object)throwable);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkAndUpdateStatusForAll() {
        CurrentSession.get().close();
        try {
            for (List<DataQueueReader> list : this._dataQueueReaderMap.values()) {
                for (DataQueueReader dataQueueReader : list) {
                    try {
                        this.checkAndUpdateStatus(dataQueueReader);
                    }
                    catch (Exception exception) {
                        logger.error((Object)"error checking and updating status for {}", (Object)dataQueueReader.getDatabaseId(), (Object)exception);
                    }
                }
                CurrentSession.get().commit();
            }
        }
        finally {
            CurrentSession.get().close();
        }
    }

    private void checkAndUpdateStatus(DataQueueReader dataQueueReader) {
        Database database = Database.fetchByPk(dataQueueReader.getDatabaseId());
        if (((Boolean)database.esbEnabled.get()).booleanValue()) {
            dataQueueReader.checkAndUpdateStatus();
        } else if (dataQueueReader.isRunning()) {
            dataQueueReader.stop();
        }
        database.esbStatus.set((Object)dataQueueReader.getStatus());
    }
}

