/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.esb.dataqueue;

import com.ahsrcm.corp.Company;
import com.ahsrcm.corp.Database;
import com.ahsrcm.corp.ISeries;
import com.ahsrcm.esb.EsbEvent;
import com.ahsrcm.esb.ServiceBus;
import com.ahsrcm.esb.dataqueue.DataQueueRecord;
import com.ahsrcm.esb.dataqueue.DataQueueRecord_v1;
import com.ahsrcm.esb.dataqueue.DataQueueRecord_v2;
import com.ahsrcm.esb.dataqueue.DataQueueStatus;
import com.ahsrcm.scanning.app.server.ServerAppConfig;
import com.ahsrcm.util.EbcdicHelper;
import com.google.inject.Inject;
import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400JPing;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400ZonedDecimal;
import com.ibm.as400.access.DataQueue;
import com.ibm.as400.access.DataQueueEntry;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.IllegalObjectTypeException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.QSYSObjectPathName;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Set;
import net.java.dev.properties.jdbc.CurrentSession;
import net.model3.collections.SetX;
import net.model3.guice.DependencyInjector;
import net.model3.lang.AbstractComparable;
import net.model3.lang.StringX;
import net.model3.lang.TimeDuration;
import net.model3.logging.Log;
import net.model3.logging.LogHelper;
import net.model3.util.DateX;

public class DataQueueReader {
    private static final Log logger = LogHelper.getLog();
    static BigDecimal Version_0 = new BigDecimal("0");
    static BigDecimal Version_1 = new BigDecimal("1");
    static BigDecimal Version_2 = new BigDecimal("2");
    private static final TimeDuration PING_TIMEOUT = new TimeDuration("1 second");
    private static final int PING_RETRY_COUNT = 3;
    private static final TimeDuration DQ_READ_TIMEOUT = new TimeDuration("2 seconds");
    private static final TimeDuration DQ_READ_STUCK = new TimeDuration(DQ_READ_TIMEOUT.inMilliseconds() * 5L);
    @Inject
    private ServiceBus _serviceBus;
    private ServerAppConfig _config = (ServerAppConfig)((Object)DependencyInjector.get().getInstance(ServerAppConfig.class));
    private Database _database;
    private ISeries _iSeries;
    private Set<String> _authorizedCompanies = SetX.create();
    private AS400 _as400;
    private DataQueue _dataQueue;
    private Thread _thread;
    private DataQueueStatus _status = DataQueueStatus.Down;
    private Object _statusChangeLock = new Object();
    private volatile boolean _stop = false;
    private DateX _readStart;
    private final String queueName = this._config.getEsbConfig().getDataQueueName();

    public DataQueueReader(Database database) {
        DependencyInjector.inject((Object)this);
        this._database = database;
        this._iSeries = (ISeries)this._database.iSeries.get();
        if (!database.isEnterprise()) {
            for (Company company : this._database.companies) {
                this._authorizedCompanies.add((String)company.id.get());
            }
        }
    }

    public void checkAndUpdateStatus() {
        logger.trace((Object)"checking status for {}", (Object)this.getDatabaseId());
        DataQueueStatus dataQueueStatus = this._status;
        boolean bl = this.ping();
        if (!bl) {
            if (dataQueueStatus.isRunning() && !this._stop) {
                this.stop();
            }
        } else if (!dataQueueStatus.isRunning()) {
            this.start();
        }
    }

    public boolean ping() {
        AS400JPing aS400JPing = new AS400JPing((String)this._iSeries.ipAddress.get(), 3);
        aS400JPing.setTimeout(PING_TIMEOUT.inMilliseconds());
        boolean bl = false;
        for (int i = 0; i < 3; ++i) {
            if (!aS400JPing.ping()) continue;
            bl = true;
        }
        return bl;
    }

    public String getDatabaseId() {
        return (String)this._database.id.get();
    }

    private String getLibrary() {
        return (String)this._database.library.get();
    }

    private String getIpAddress() {
        return (String)this._iSeries.ipAddress.get();
    }

    private String getUser() {
        return (String)this._iSeries.user.get();
    }

    private String getPassword() {
        return (String)this._iSeries.password.get();
    }

    public void start() {
        if (this._status != DataQueueStatus.Down) {
            throw new RuntimeException(this.getDatabaseId() + " is not Down trying to start a reader that is not down");
        }
        this._stop = false;
        this.setStatus(DataQueueStatus.Reading);
        this._thread = new Thread(){

            @Override
            public void run() {
                this.setName("dqreader-db" + DataQueueReader.this.getDatabaseId() + "-th" + this.getId());
                try {
                    DataQueueReader.this.readDataQueue();
                }
                catch (Throwable throwable) {
                    logger.fatal((Object)"fatal error reading data queue for {}", (Object)DataQueueReader.this.getDatabaseId(), (Object)throwable);
                }
            }
        };
        this._thread.start();
        logger.debug((Object)"data queue listening thread start for {}", (Object)this.getDatabaseId());
    }

    public void stop() {
        this.stop(false);
    }

    public boolean isRunning() {
        return this._status != DataQueueStatus.Down;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(boolean bl) {
        if (this._status == DataQueueStatus.Down) {
            throw new RuntimeException(this.getDatabaseId() + " is already down. Trying to stop a reader that is aleady down.");
        }
        logger.debug((Object)"stopping data queue listening thread for {}", (Object)this.getDatabaseId());
        if (this._status.isRunning()) {
            this._stop = true;
        }
        Object object = this._statusChangeLock;
        synchronized (object) {
            if (this._status == DataQueueStatus.Reading) {
                try {
                    this._thread.interrupt();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (bl) {
            while (this._status.isProcessing() && this._thread.isAlive()) {
                try {
                    this._thread.interrupt();
                }
                catch (Exception exception) {
                    logger.warn((Object)"this happened while interupting a thread. it is highly likely it can be ignored and is being logged here only for educational purposes.", (Object)exception);
                }
            }
        }
        logger.debug((Object)"stopped data queue listening thread for {}", (Object)this.getDatabaseId());
    }

    public void writeDataQueueRecord(EsbEvent esbEvent) {
        if (this._dataQueue == null) {
            this.connect();
        }
        for (int i = 1; i <= 3; ++i) {
            try {
                this._dataQueue.write(esbEvent.getDataQueueBytes());
                break;
            }
            catch (Exception exception) {
                logger.warn((Object)"error writing {} to data queue", (Object)esbEvent, (Object)exception);
                this.connect();
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readDataQueue() {
        AS400ZonedDecimal aS400ZonedDecimal = new AS400ZonedDecimal(3, 0);
        this.connect();
        logger.debug((Object)"starting up for {}", (Object)this.getDatabaseId());
        try {
            boolean bl = true;
            while (true) {
                DataQueueRecord dataQueueRecord;
                if (CurrentSession.get((boolean)false) != null) {
                    CurrentSession.get().close();
                }
                if (bl || this._status != DataQueueStatus.Reading) {
                    logger.debug((Object)"waiting on {} data queue {}", (Object)this.queueName, (Object)this.getDatabaseId());
                    bl = false;
                }
                DataQueueEntry dataQueueEntry = null;
                if (this._status.isRunning()) {
                    this.setStatus(DataQueueStatus.Reading);
                    try {
                        this._readStart = new DateX();
                        dataQueueEntry = this._dataQueue.read((int)DQ_READ_TIMEOUT.inSeconds());
                    }
                    finally {
                        this._readStart = null;
                    }
                }
                if (this._stop) {
                    break;
                }
                if (dataQueueEntry == null) continue;
                Object object = this._statusChangeLock;
                synchronized (object) {
                    if (this._status == DataQueueStatus.Reading) {
                        this.setStatus(DataQueueStatus.Processing);
                    }
                }
                logger.debug((Object)"entry read from {} data queue {}", (Object)this.queueName, (Object)this.getDatabaseId());
                object = dataQueueEntry.getData();
                BigDecimal bigDecimal = (BigDecimal)aS400ZonedDecimal.toObject((byte[])object);
                if (bigDecimal.equals(Version_1) || bigDecimal.equals(Version_0)) {
                    dataQueueRecord = new DataQueueRecord_v1((byte[])object);
                } else if (bigDecimal.equals(Version_2)) {
                    dataQueueRecord = new DataQueueRecord_v2((byte[])object);
                } else {
                    logger.error((Object)("don't know how to handle version " + bigDecimal + " error reading DQ for " + (String)this._database.id.get()));
                    continue;
                }
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)"data queue record read bytes read\n{}", (Object)EbcdicHelper.arrayToHexDump((byte[])object));
                }
                EsbEvent esbEvent = null;
                try {
                    esbEvent = new EsbEvent(dataQueueRecord);
                    if (StringX.isBlank((String)((String)esbEvent.fromDatabaseId.get()))) {
                        esbEvent.fromDatabaseId.set((Object)((String)this._database.id.get()));
                    }
                    DataQueueReader.parseDataQueueSenderInformation(esbEvent, dataQueueEntry.getSenderInformation(), this._database);
                }
                catch (NumberFormatException numberFormatException) {
                    logger.warn((Object)"data queue record read bytes read\n{}", (Object)EbcdicHelper.arrayToHexDump((byte[])object));
                    throw numberFormatException;
                }
                try {
                    esbEvent.setId();
                    CurrentSession.get().insert((Object)esbEvent);
                    CurrentSession.get().commit();
                }
                catch (Exception exception) {
                    logger.error((Object)"error saving data queue record to enterprise DB saving DQ record to disk", (Object)exception);
                    esbEvent.saveToDisk();
                    continue;
                }
                try {
                    this._serviceBus.process(esbEvent);
                }
                catch (Exception exception) {
                    logger.error((Object)"error processing data queue request", (Object)exception);
                }
                CurrentSession.get().commit();
            }
        }
        catch (AS400SecurityException aS400SecurityException) {
            throw new RuntimeException(aS400SecurityException);
        }
        catch (ObjectDoesNotExistException objectDoesNotExistException) {
            throw new RuntimeException(objectDoesNotExistException);
        }
        catch (IllegalObjectTypeException illegalObjectTypeException) {
            throw new RuntimeException(illegalObjectTypeException);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        catch (InterruptedException interruptedException) {
            logger.trace((Object)"data queue reading interupted for {}", (Object)this.getDatabaseId());
        }
        catch (ErrorCompletingRequestException errorCompletingRequestException) {
            throw new RuntimeException(errorCompletingRequestException);
        }
        finally {
            this.disconnect();
            this.setStatus(DataQueueStatus.Down);
        }
    }

    public boolean isStuckOnRead() {
        DateX dateX = this._readStart;
        return dateX != null && dateX.diff().greaterThan((AbstractComparable)DQ_READ_STUCK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setStatus(DataQueueStatus dataQueueStatus) {
        if (this._status != dataQueueStatus) {
            DataQueueStatus dataQueueStatus2 = this._status;
            synchronized (dataQueueStatus2) {
                logger.debug((Object)"data queue status for {} changed from {} to {}", (Object)this.getDatabaseId(), (Object)this._status, (Object)dataQueueStatus);
                this._status = dataQueueStatus;
            }
        }
    }

    private void disconnect() {
        if (this._as400 != null) {
            logger.trace((Object)"disconnecting {}", (Object)this.getDatabaseId());
            try {
                this._as400.disconnectAllServices();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._as400 = null;
            this._dataQueue = null;
        }
    }

    private void connect() {
        this.disconnect();
        try {
            String string = QSYSObjectPathName.toPath((String)this.getLibrary(), (String)this.queueName, (String)"dtaq");
            logger.info((Object)"iSeries {} with ip address {} connection being started. listening to dtaq = {}", (Object)this.getDatabaseId(), (Object)this.getIpAddress(), (Object)string);
            this._as400 = new AS400(this.getIpAddress(), this.getUser(), this.getPassword());
            this._as400.setGuiAvailable(false);
            this._dataQueue = new DataQueue(this._as400, string);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        logger.trace((Object)"connected {}", (Object)this.getDatabaseId());
    }

    public static void parseDataQueueSenderInformation(EsbEvent esbEvent, String string, Database database) {
        try {
            esbEvent.userId.set((Object)string.substring(26).trim());
            esbEvent.jobNumber.set((Object)string.substring(20, 26).trim());
        }
        catch (Exception exception) {
            logger.warn((Object)"don't know how to handle sender info '{}' database={}", (Object)string, database.id.get());
        }
    }

    public DataQueueStatus getStatus() {
        return this._status;
    }

    boolean isAuthorizedCompanyAndDivision(String string, String string2) {
        if (this._database.isEnterprise()) {
            return true;
        }
        return this._authorizedCompanies.contains(string);
    }
}

