/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.esb;

import com.ahsrcm.esb.EsbEvent;
import com.ahsrcm.esb.EsbEventStatus;
import com.ahsrcm.esb.ServiceBus;
import com.ahsrcm.esb.dataqueue.DataQueueReaderManager;
import com.ahsrcm.esb.synch.routing.EndPointTemplate;
import com.ahsrcm.scanning.app.server.ServerAppConfig;
import com.google.inject.Inject;
import java.util.List;
import net.java.dev.properties.jdbc.CurrentSession;
import net.java.dev.properties.jdbc.UpdateQuery;
import net.model3.lang.ThreadScheduler;
import net.model3.lang.TimeDuration;
import net.model3.logging.Log;
import net.model3.logging.LogHelper;
import net.model3.newfile.File;

public class ServiceBusStarter {
    private static final Log logger = LogHelper.getLog();
    @Inject
    private ServerAppConfig _config;
    @Inject
    private DataQueueReaderManager _dataQueueReaderManager;
    @Inject
    private ServiceBus _serviceBus;
    @Inject
    private ThreadScheduler _jobScheduler;

    public void start() {
        this.startStuckEvents();
        this._dataQueueReaderManager.start();
        this.scheduleReadingSavedToDiskDataQueueRecords();
        this.scheduleReadingRetryRecordsFromEnterpriseDatabase();
    }

    private void startStuckEvents() {
        for (EsbEvent esbEvent : EsbEvent.select("e6sts = 'P'", new Object[0])) {
            if (this._serviceBus.isProcessing(esbEvent)) continue;
            UpdateQuery updateQuery = new UpdateQuery("update espesb set E6STS = 'R', E6RTRY = E6RTRY+1 where E6EID = " + esbEvent.id.get() + " and E6STS = 'P'", CurrentSession.get().getConnection());
            updateQuery.execute();
            int n = updateQuery.getNumberOfRowsUpdated();
            if (n == 1) {
                logger.debug((Object)"changed status from {} to {} for event = {}", (Object)EsbEventStatus.Processing, (Object)EsbEventStatus.Retry, esbEvent.id.get());
            } else {
                logger.debug(new Object[]{"update status query expected 1 row to change but {} rows were changed. Unexpected results while changing status from {} to {} for event = {}", n, EsbEventStatus.Processing, EsbEventStatus.Retry, esbEvent.id.get()});
            }
            CurrentSession.get().commit();
        }
    }

    EsbEvent createServiceBusEvent(EndPointTemplate endPointTemplate, String string, String string2) {
        EsbEvent esbEvent = new EsbEvent(endPointTemplate, string, string2);
        esbEvent.setId();
        CurrentSession.get().insert((Object)esbEvent);
        CurrentSession.get().commit();
        return esbEvent;
    }

    private void scheduleReadingSavedToDiskDataQueueRecords() {
        final TimeDuration timeDuration = new TimeDuration("5 minutes");
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    CurrentSession.get().close();
                    for (File file : ServiceBusStarter.this._config.getDataQueueEventDirectory().files()) {
                        try {
                            EsbEvent esbEvent = EsbEvent.loadFromDisk(file);
                            esbEvent.setId();
                            esbEvent.status.set((Object)EsbEventStatus.Retry);
                            CurrentSession.get().insert((Object)esbEvent);
                            CurrentSession.get().commit();
                            file.delete();
                            ServiceBusStarter.this._serviceBus.process(esbEvent);
                        }
                        catch (Exception exception) {
                            logger.error((Object)"error processing saved esb event {}", (Object)file.getName(), (Object)exception);
                        }
                    }
                }
                catch (Exception exception) {
                    logger.error((Object)"error processing saved dq records", (Object)exception);
                }
                finally {
                    ServiceBusStarter.this._jobScheduler.schedule("loadDatabaseFromSavedDqRecords", timeDuration, (Runnable)this);
                }
            }
        };
        this._jobScheduler.submit("loadDatabaseFromSavedDqRecords", runnable);
    }

    private void scheduleReadingRetryRecordsFromEnterpriseDatabase() {
        final TimeDuration timeDuration = new TimeDuration("30 seconds");
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    CurrentSession.get().close();
                    List list = EsbEvent.select("E6STS = ?", EsbEventStatus.Retry.getStatusCode()).getResults();
                    for (EsbEvent esbEvent : list) {
                        try {
                            esbEvent.retryCount.set((Object)((Integer)esbEvent.retryCount.get() + 1));
                            ServiceBusStarter.this._serviceBus.process(esbEvent);
                        }
                        catch (Exception exception) {
                            logger.error((Object)"error procesing {}", (Object)esbEvent, (Object)exception);
                        }
                    }
                }
                catch (Exception exception) {
                    logger.error((Object)"error processing ent db dq event records", (Object)exception);
                }
                finally {
                    ServiceBusStarter.this._jobScheduler.schedule("esbRunRetryEvents", timeDuration, (Runnable)this);
                }
            }
        };
        this._jobScheduler.submit("esbRunRetryEvents", runnable);
    }
}

