/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.esb;

import com.ahsrcm.core.transaction.AhsTransactionManager;
import com.ahsrcm.corp.Company;
import com.ahsrcm.corp.Database;
import com.ahsrcm.corp.Division;
import com.ahsrcm.corp.Location;
import com.ahsrcm.corp.PatientFile;
import com.ahsrcm.corp.ScanBatch;
import com.ahsrcm.esb.EsbEvent;
import com.ahsrcm.esb.EsbEventStatus;
import com.ahsrcm.esb.EventHandler;
import com.ahsrcm.esb.EventHandlerFactory;
import com.ahsrcm.esb.HarleyInterfaceImportTextFileProcessor;
import com.ahsrcm.esb.dataqueue.DataQueueReader;
import com.ahsrcm.scanning.app.server.ServerAppConfig;
import com.ahsrcm.util.UserContext;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import edu.emory.mathcs.backport.java.util.Collections;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import net.java.dev.properties.jdbc.CurrentSession;
import net.model3.lang.StringX;
import net.model3.logging.Log;
import net.model3.logging.LogHelper;
import org.apache.log4j.NDC;

@Singleton
public class ServiceBus {
    private static final Log logger = LogHelper.getLog();
    @Inject
    EventHandlerFactory _actionFactory;
    @Inject
    Injector _injector;
    @Inject
    UserContext _userContext;
    @Inject
    AhsTransactionManager _transactionManager;
    @Inject
    ServerAppConfig _serverConfig;
    private DataQueueReader _dataQueue;
    private Set<Long> _inProcessEvents = Collections.synchronizedSet(new HashSet());

    void doDatabaseIdHackFix(EsbEvent esbEvent) {
        if (((String)esbEvent.actionId.get()).equals("RECORD-SYNCH") && (((String)esbEvent.formatId.get()).equals("ESPSCNPH") || ((String)esbEvent.formatId.get()).equals("ESPSCNB"))) {
            if (StringX.isBlank((String)((String)esbEvent.fromDatabaseId.get()))) {
                esbEvent.fromDatabaseId.set((Object)((String)Database.getEnterpriseDatabase().id.get()));
            }
            if (StringX.isBlank((String)((String)esbEvent.toDatabaseId.get())) && esbEvent.getFromTemplate().getDatabase().isEnterprise()) {
                esbEvent.toDatabaseId.set((Object)((String)((Database)esbEvent.getCompany().database.get()).id.get()));
            }
        }
    }

    public void process(final EsbEvent esbEvent) {
        this.doDatabaseIdHackFix(esbEvent);
        logger.debug((Object)"processing event {}  {}", esbEvent.id.get(), esbEvent.actionId.get());
        final long l = (Long)esbEvent.id.get();
        this._transactionManager.runWithSuperUser(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    NDC.push((String)("esb=" + esbEvent.id.get()));
                    ServiceBus.this._inProcessEvents.add(l);
                    esbEvent.addStandardRuntimeParms(ServiceBus.this._serverConfig.getDatabaseConfig().getUser());
                    CurrentSession.get().merge((Object)esbEvent);
                    esbEvent.unpackParameters();
                    ServiceBus.this.processImpl(esbEvent);
                    esbEvent.status.set((Object)EsbEventStatus.Success);
                }
                catch (Exception exception) {
                    if ((Integer)esbEvent.retryCount.get() > 4) {
                        esbEvent.status.set((Object)EsbEventStatus.Failed);
                    } else {
                        esbEvent.status.set((Object)EsbEventStatus.Retry);
                    }
                    logger.error((Object)"error processing event {}", (Object)esbEvent, (Object)exception);
                }
                finally {
                    ServiceBus.this._inProcessEvents.remove(l);
                    EsbEvent.set(null);
                    NDC.pop();
                }
                return null;
            }
        });
    }

    public boolean isProcessing(EsbEvent esbEvent) {
        return this._inProcessEvents.contains(esbEvent.id.get());
    }

    private void processImpl(EsbEvent esbEvent) {
        logger.debug((Object)"starting event\n  {}", (Object)esbEvent);
        if (((Boolean)esbEvent.getFromTemplate().getDatabase().esbEnabled.get()).booleanValue()) {
            esbEvent.status.set((Object)EsbEventStatus.Processing);
            CurrentSession.get().commit();
            EsbEvent.set(esbEvent);
            long l = System.currentTimeMillis();
            esbEvent.getProperties().put("nowTimestamp", new Timestamp(l));
            esbEvent.getProperties().put("nowDate", new Date(l));
            esbEvent.getProperties().put("nowTime", new Time(l));
            EventHandler eventHandler = this._actionFactory.getEventHandler((String)esbEvent.actionId.get());
            eventHandler.processEvent(esbEvent);
            if (((String)esbEvent.formatId.get()).equals("INTERFACE_IMPORT")) {
                ((HarleyInterfaceImportTextFileProcessor)this._injector.getInstance(HarleyInterfaceImportTextFileProcessor.class)).process(esbEvent);
            }
            esbEvent.status.set((Object)EsbEventStatus.Success);
            logger.debug((Object)"successful event completion - {}", (Object)esbEvent);
        } else {
            esbEvent.status.set((Object)EsbEventStatus.Disabled);
            logger.warn((Object)"ignoring events sourced from a disabled database event={}", (Object)esbEvent);
        }
    }

    public void createRecordSynchEvent(PatientFile patientFile) {
        Division division = (Division)((Location)((ScanBatch)patientFile.batch.get()).location.get()).division.get();
        EsbEvent esbEvent = new EsbEvent();
        esbEvent.actionId.set((Object)"RECORD-SYNCH");
        esbEvent.formatId.set((Object)"ESPSCNPH");
        esbEvent.formatVersion.set((Object)1);
        esbEvent.fromDatabaseId.set((Object)((String)Database.getEnterpriseDatabase().id.get()));
        esbEvent.toDatabaseId.set((Object)((String)((Database)((Company)division.company.get()).database.get()).id.get()));
        esbEvent.companyId.set((Object)((String)((Company)division.company.get()).id.get()));
        esbEvent.divisionId.set((Object)((String)division.id.get()));
        esbEvent.addDataQueueParameter("patientFileId", new BigDecimal((Long)patientFile.id.get()));
        this.getDataQueue().writeDataQueueRecord(esbEvent);
    }

    public DataQueueReader getDataQueue() {
        if (this._dataQueue == null) {
            this._dataQueue = new DataQueueReader(Database.getEnterpriseDatabase());
        }
        return this._dataQueue;
    }

    public void createRecordSynchEvent(ScanBatch scanBatch) {
        EsbEvent esbEvent = new EsbEvent();
        esbEvent.actionId.set((Object)"RECORD-SYNCH");
        esbEvent.formatId.set((Object)"ESPSCNB");
        esbEvent.formatVersion.set((Object)1);
        esbEvent.fromDatabaseId.set((Object)((String)Database.getEnterpriseDatabase().id.get()));
        esbEvent.toDatabaseId.set((Object)((String)((Database)((Company)((Division)((Location)scanBatch.location.get()).division.get()).company.get()).database.get()).id.get()));
        esbEvent.setDivision((Division)((Location)scanBatch.location.get()).division.get());
        esbEvent.addDataQueueParameter("scanBatchId", new BigDecimal((Long)scanBatch.id.get()));
        this.getDataQueue().writeDataQueueRecord(esbEvent);
    }
}

