/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.esb;

import com.ahsrcm.corp.CodingCharge;
import com.ahsrcm.corp.PatientFile;
import com.ahsrcm.corp.ScanBatch;
import com.ahsrcm.corp.ScannedImage;
import com.ahsrcm.corp.cdl.CDLEntity;
import com.ahsrcm.esb.ConnectionTransaction;
import com.ahsrcm.esb.EsbEvent;
import com.ahsrcm.scanning.device.TextToTiffCopier;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.ibm.as400.access.AS400;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.IFSFileInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.List;
import java.util.concurrent.Callable;
import net.java.dev.properties.jdbc.CurrentSession;
import net.model3.guice.InjectionCompletedListener;
import net.model3.guice.bootstrap.CacheDirectory;
import net.model3.io.IOHelper;
import net.model3.lang.StringX;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.newfile.Directory;
import net.model3.transaction.TransactionManager;

public class HarleyInterfaceImportTextFileProcessor
implements InjectionCompletedListener {
    static final Logger logger = LoggerHelper.getLogger();
    @Inject
    Injector _injector;
    @Inject
    TransactionManager _transactionManager;
    @Inject
    TextToTiffCopier _textToTiffCopier;
    @Inject
    CacheDirectory _cacheDirectory;
    Directory _reportsDirectory;

    public void injectionComplete() throws Exception {
        this._reportsDirectory = ((Directory)this._cacheDirectory.get()).subDirectory("old-reports");
        this._reportsDirectory.makeDirectories();
    }

    public void process(final EsbEvent esbEvent) {
        this._transactionManager.run((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ConnectionTransaction connectionTransaction = (ConnectionTransaction)HarleyInterfaceImportTextFileProcessor.this._injector.getInstance(ConnectionTransaction.class);
                AS400 aS400 = connectionTransaction.getAS400Connection(esbEvent.getClientDatabase());
                BigDecimal bigDecimal = (BigDecimal)esbEvent.getProperty("scanBatchId");
                long l = bigDecimal.longValue();
                ScanBatch scanBatch = ScanBatch.fetchByPk(l);
                for (PatientFile patientFile : scanBatch.patientFiles.get()) {
                    HarleyInterfaceImportTextFileProcessor.this.processPatientFileForImages(aS400, patientFile);
                }
                scanBatch.expectedVisitCount.set((Object)scanBatch.patientFiles.size());
                scanBatch.expectedImageCount.set((Object)scanBatch.getVisibleImages().size());
                return null;
            }
        });
        CurrentSession.get().commit();
    }

    void processPatientFileForImages(AS400 aS400, PatientFile patientFile) throws Exception {
        CDLEntity cDLEntity = patientFile.getCDLEntity();
        String string = StringX.padLeft((Object)patientFile.id.get(), (int)11, (char)'0');
        String string2 = "/db" + cDLEntity.getDatabaseId() + "/coding/" + cDLEntity.getCompanyId() + "/" + cDLEntity.getDivisionId() + "/" + string + ".TXT";
        logger.debug((Object)"processing {}", (Object)string2);
        IFSFile iFSFile = new IFSFile(aS400, string2);
        if (iFSFile.exists()) {
            String string3 = patientFile.getAccessionNumber();
            byte[] byArray = IOHelper.readFully((InputStream)new IFSFileInputStream(iFSFile));
            String string4 = new String(byArray);
            List<TextToTiffCopier.Page> list = this._textToTiffCopier.getPages(string4, string3);
            ScannedImage scannedImage = null;
            for (TextToTiffCopier.Page object : list) {
                ScannedImage scannedImage2 = patientFile.newScannedImage(true);
                if (scannedImage == null) {
                    scannedImage = scannedImage2;
                }
                object.outputFile = scannedImage2.getImageFile();
            }
            for (CodingCharge codingCharge : patientFile.getCharges()) {
                codingCharge.image.set((Object)scannedImage);
            }
            this._textToTiffCopier.outputPages(list);
            this._reportsDirectory.file(iFSFile.getName()).write(byArray);
            iFSFile.delete();
        } else {
            logger.warn((Object)"unable to find patient file image {}", (Object)string2);
        }
    }
}

