/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.esb;

import com.ahsrcm.corp.Company;
import com.ahsrcm.corp.Database;
import com.ahsrcm.corp.Division;
import com.ahsrcm.corp.OrmBean;
import com.ahsrcm.corp.orm.ByteBufferHandler;
import com.ahsrcm.esb.EsbConfiguration;
import com.ahsrcm.esb.EsbEventParameter;
import com.ahsrcm.esb.EsbEventStatus;
import com.ahsrcm.esb.dataqueue.DataQueueFormat;
import com.ahsrcm.esb.dataqueue.DataQueueRecord;
import com.ahsrcm.esb.dataqueue.DataQueueRecord_v1;
import com.ahsrcm.esb.dataqueue.ISeriesDataStructure;
import com.ahsrcm.esb.synch.routing.EndPointTemplate;
import com.ahsrcm.esb.synch.routing.Routing;
import com.ahsrcm.scanning.app.server.ServerAppConfig;
import com.ahsrcm.scanning.dao.ScanningDao;
import com.ahsrcm.util.ByteBuffer;
import com.ahsrcm.util.EbcdicHelper;
import com.ibm.as400.access.FieldDescription;
import com.ibm.as400.access.Record;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import net.java.dev.properties.Property;
import net.java.dev.properties.RProperty;
import net.java.dev.properties.annotations.Column;
import net.java.dev.properties.annotations.Table;
import net.java.dev.properties.container.BeanContainer;
import net.java.dev.properties.container.IPropertyContext;
import net.java.dev.properties.container.ObservableProperty;
import net.java.dev.properties.jdbc.CurrentSession;
import net.java.dev.properties.jdbc.Query;
import net.java.dev.properties.jdbc.handlers.EnumDelegatingInterfaceHandler;
import net.model3.bean.ReflectionTool;
import net.model3.bean.converters.Converter;
import net.model3.collections.CaseInsensitiveMapWrapper;
import net.model3.collections.ListX;
import net.model3.guice.DependencyInjector;
import net.model3.io.IOHelper;
import net.model3.lang.StringX;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.logging.SimpleLoggingConfigurator;
import net.model3.newfile.Directory;
import net.model3.newfile.File;

@Table(name="ESPESB", prefix="E6")
public class EsbEvent
implements Serializable,
OrmBean {
    private static final long serialVersionUID = -8110488287360419436L;
    private static final Logger logger = LoggerHelper.getLogger();
    private static ThreadLocal<EsbEvent> _eventContext = new ThreadLocal();
    @Column(suffix="EID", key=true)
    public final Property<Long> id = ObservableProperty.create();
    @Column(suffix="UID", length=32L)
    public final Property<String> uid = ObservableProperty.create();
    @Column(suffix="DBID", length=4L)
    public final Property<String> fromDatabaseId = ObservableProperty.create((Object)"");
    @Column(suffix="TODB", length=4L)
    public final Property<String> toDatabaseId = ObservableProperty.create((Object)"");
    @Column(suffix="CMP", length=4L)
    public final Property<String> companyId = ObservableProperty.create((Object)"");
    @Column(suffix="DIV", length=4L)
    public final Property<String> divisionId = ObservableProperty.create((Object)"");
    @Column(suffix="ACT", length=20L)
    public final Property<String> actionId = ObservableProperty.create((Object)"");
    @Column(suffix="FMT", length=20L)
    public final Property<String> formatId = ObservableProperty.create((Object)"");
    @Column(suffix="FVER")
    public final Property<Integer> formatVersion = ObservableProperty.create((Object)-1);
    @Column(suffix="DQVER")
    public final Property<Integer> dqFormatVersion = ObservableProperty.create((Object)-1);
    @Column(suffix="RTRY")
    public final Property<Integer> retryCount = ObservableProperty.create((Object)0);
    @Column(suffix="STS", typeHandler=EnumDelegatingInterfaceHandler.class)
    public final Property<EsbEventStatus> status = new ObservableProperty<EsbEventStatus>(EsbEventStatus.Initial){

        public void set(EsbEventStatus esbEventStatus) {
            super.set((Object)esbEventStatus);
            EsbEvent.this.updated.set((Object)new Timestamp(System.currentTimeMillis()));
        }
    };
    @Column(suffix="USRE", length=10L)
    public final Property<String> userId = ObservableProperty.create((Object)"");
    @Column(suffix="JOB", length=6L)
    public final Property<String> jobNumber = ObservableProperty.create((Object)"");
    @Column(suffix="CRT")
    public final Property<Timestamp> created = ObservableProperty.create();
    @Column(suffix="UPD")
    public final Property<Timestamp> updated = ObservableProperty.create();
    @Column(suffix="DATA", typeHandler=ByteBufferHandler.class)
    public final Property<ByteBuffer> data = ObservableProperty.create((Object)ByteBuffer.EMPTY);
    private transient Map<String, Object> _dataQueueParameters = CaseInsensitiveMapWrapper.create();
    private transient Map<String, Object> _runtimeProperties = CaseInsensitiveMapWrapper.create();
    private transient EndPointTemplate _from;
    private transient EndPointTemplate _to;
    transient boolean _parametersUnpacked = false;
    transient boolean _persisted;
    public static final EsbEvent Meta = new EsbEvent();

    public EsbEvent() {
        BeanContainer.bind((Object)this);
    }

    public EsbEvent(DataQueueRecord dataQueueRecord) {
        BeanContainer.bind((Object)this);
        this.actionId.set((Object)dataQueueRecord.getAction());
        this.fromDatabaseId.set((Object)dataQueueRecord.getFromDatabase());
        this.toDatabaseId.set((Object)dataQueueRecord.getToDatabase());
        this.companyId.set((Object)dataQueueRecord.getCompany());
        this.divisionId.set((Object)dataQueueRecord.getDivision());
        this.formatId.set((Object)dataQueueRecord.getFormatId());
        this.formatVersion.set((Object)dataQueueRecord.getDataVersion());
        this.data.set((Object)new ByteBuffer(dataQueueRecord.getEventData()));
        this.created.set((Object)new Timestamp(System.currentTimeMillis()));
        this.updated.set((Object)((Timestamp)this.created.get()));
        this.dqFormatVersion.set((Object)dataQueueRecord.getVersion());
    }

    public EsbEvent(EndPointTemplate endPointTemplate, String string, String string2) {
        BeanContainer.bind((Object)this);
        this.actionId.set((Object)string);
        this.companyId.set((Object)endPointTemplate.getCompanyId());
        this.created.set((Object)new Timestamp(System.currentTimeMillis()));
        this.fromDatabaseId.set((Object)endPointTemplate.getDatabaseId());
        this.divisionId.set((Object)endPointTemplate.getDivisionId());
        this.formatId.set((Object)string2);
        this.created.set((Object)new Timestamp(System.currentTimeMillis()));
        this.updated.set((Object)((Timestamp)this.created.get()));
    }

    Object readResolve() {
        BeanContainer.bind((Object)this);
        return this;
    }

    public static EsbEvent loadFromDisk(File file) {
        Properties properties = new Properties();
        FileReader fileReader = null;
        try {
            fileReader = file.createFileReader();
            properties.load(fileReader);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        finally {
            IOHelper.close((Reader)fileReader);
        }
        ReflectionTool reflectionTool = (ReflectionTool)DependencyInjector.get().getInstance(ReflectionTool.class);
        EsbEvent esbEvent = new EsbEvent();
        for (IPropertyContext iPropertyContext : BeanContainer.get().getContext(esbEvent.getClass()).getProperties()) {
            Converter converter = reflectionTool.getConverterFactory().getConverter(iPropertyContext.getType());
            String string = properties.getProperty(iPropertyContext.getName());
            if (string == null) continue;
            Object object = converter.stringToValue(iPropertyContext.getType(), string);
            iPropertyContext.setValue((Object)esbEvent, object);
        }
        return esbEvent;
    }

    public void saveToDisk() {
        Directory directory = ((ServerAppConfig)((Object)DependencyInjector.get().getInstance(ServerAppConfig.class))).getDataQueueEventDirectory();
        File file = directory.file("dq-" + UUID.randomUUID() + ".event");
        Properties properties = new Properties();
        ReflectionTool reflectionTool = (ReflectionTool)DependencyInjector.get().getInstance(ReflectionTool.class);
        for (IPropertyContext iPropertyContext : BeanContainer.get().getContext(this.getClass()).getProperties()) {
            Object object = iPropertyContext.getValue((Object)this);
            Converter converter = reflectionTool.getConverterFactory().getConverter(iPropertyContext.getType());
            if (object == null) continue;
            String string = converter.valueToString(object);
            properties.put(iPropertyContext.getName(), string);
        }
        directory.makeDirectories();
        try {
            FileWriter fileWriter = file.createWriter();
            properties.store(fileWriter, "");
            ((Writer)fileWriter).close();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void serializeParameters() {
        ISeriesDataStructure iSeriesDataStructure = this.getDataStructure();
        if (iSeriesDataStructure == null) {
            throw new RuntimeException("format " + (String)this.formatId.get() + "-" + this.formatVersion.get() + " not found");
        }
        Record record = iSeriesDataStructure.asRecordFormat().getNewRecord();
        for (String string : this._dataQueueParameters.keySet()) {
            string = string.toUpperCase();
            try {
                Object object = this._dataQueueParameters.get(string);
                if (object instanceof Long) {
                    object = new BigDecimal((Long)object);
                }
                record.setField(string, object);
            }
            catch (Exception exception) {
                logger.warn((Object)"error with field {}", (Object)string, (Object)exception);
            }
        }
        try {
            this.data.set((Object)new ByteBuffer(record.getContents()));
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public Company getCompany() {
        if (StringX.isNotBlank((String)((String)this.companyId.get()))) {
            return Company.fetchByPk((String)this.companyId.get());
        }
        return null;
    }

    public ISeriesDataStructure getDataStructure() {
        DataQueueFormat dataQueueFormat = ((EsbConfiguration)((Object)DependencyInjector.get().getInstance(EsbConfiguration.class))).dataQueueFormatsByFormatId.get((String)this.formatId.get());
        return dataQueueFormat.getDataStructure((Integer)this.formatVersion.get());
    }

    public void addStandardRuntimeParms(String string) {
        if (StringX.isNotBlank((String)this.getCompanyId())) {
            this.addRuntimeParameter("companyId", this.getCompanyId());
        }
        if (StringX.isNotBlank((String)this.getDivisionId())) {
            this.addRuntimeParameter("divisionId", this.getDivisionId());
        }
        this.addRuntimeParameter("esbUser", string);
    }

    public void addDataQueueParameter(String string, Object object) {
        this._dataQueueParameters.put(string, object);
        this._runtimeProperties.put(string, object);
    }

    public void addDataQueueParameter(RProperty<?> rProperty) {
        this.addDataQueueParameter(rProperty.getContext().getName(), rProperty.get());
    }

    public void addRuntimeParameter(String string, Object object) {
        this._runtimeProperties.put(string, object);
    }

    public void addRuntimeParameter(RProperty<?> rProperty) {
        this.addRuntimeParameter(rProperty.getContext().getName(), rProperty.get());
    }

    public <T> T getProperty(String string) {
        return (T)this._runtimeProperties.get(string);
    }

    public Map<String, Object> getProperties() {
        return this._runtimeProperties;
    }

    public static EsbEvent get() {
        return _eventContext.get();
    }

    public static void set(EsbEvent esbEvent) {
        if (esbEvent == null) {
            _eventContext.remove();
        } else {
            _eventContext.set(esbEvent);
        }
    }

    public void setDivision(Division division) {
        this.companyId.set((Object)((String)((Company)division.company.get()).id.get()));
        this.divisionId.set((Object)((String)division.id.get()));
    }

    public void setId() {
        this.id.set((Object)((ScanningDao)ScanningDao.Impl.get()).nextControlNumber(this.getClass()));
    }

    public byte[] getDataQueueBytes() {
        if (((ByteBuffer)this.data.get()).getBuffer().length == 0 || this._dataQueueParameters.size() > 0) {
            this.serializeParameters();
        }
        DataQueueRecord_v1 dataQueueRecord_v1 = new DataQueueRecord_v1();
        dataQueueRecord_v1.setAction((String)this.actionId.get());
        dataQueueRecord_v1.setCompany((String)this.companyId.get());
        dataQueueRecord_v1.setDataVersion((Integer)this.formatVersion.get());
        dataQueueRecord_v1.setDivision((String)this.divisionId.get());
        dataQueueRecord_v1.setEventData(((ByteBuffer)this.data.get()).getBuffer());
        dataQueueRecord_v1.setFormatId((String)this.formatId.get());
        dataQueueRecord_v1.setVersion(1);
        return dataQueueRecord_v1.asByteArray();
    }

    public String getDataQueueParametersAsString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, Object> entry : this._dataQueueParameters.entrySet()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(entry.getKey());
            stringBuilder.append(" = ");
            stringBuilder.append(entry.getValue());
        }
        return stringBuilder.toString();
    }

    public String getCompanyId() {
        return (String)this.companyId.get();
    }

    public String getDivisionId() {
        return (String)this.divisionId.get();
    }

    public static EsbEvent fetchByPk(Object ... objectArray) {
        return (EsbEvent)CurrentSession.get().fetchByPK(EsbEvent.class, objectArray);
    }

    public static Query<EsbEvent> select(String string, Object ... objectArray) {
        return CurrentSession.get().select(EsbEvent.class, string, objectArray);
    }

    public static List<EsbEvent> selectAll() {
        return CurrentSession.get().selectAll(EsbEvent.class);
    }

    public static EsbEvent fetch(String string, Object ... objectArray) {
        return (EsbEvent)ListX.getFirst(EsbEvent.select(string, objectArray));
    }

    public void unpackParameters() {
        byte[] byArray = ((ByteBuffer)this.data.get()).getBuffer();
        if (byArray != null && byArray.length > 0) {
            ISeriesDataStructure iSeriesDataStructure = this.getDataStructure();
            if (iSeriesDataStructure == null) {
                logger.warn((Object)"no data queue format found for {} {}", this.formatId, this.formatVersion);
            } else {
                logger.debug((Object)"received event {}", this.formatId.get());
                byte[] byArray2 = new byte[iSeriesDataStructure.getLength()];
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)"unpacking eventDataBytes\n{}", (Object)EbcdicHelper.arrayToHexDump(byArray2));
                }
                if (byArray.length != byArray2.length) {
                    logger.warn((Object)"event data length {} does not match defined event data format length {}", (Object)byArray.length, (Object)byArray2.length);
                }
                System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
                try {
                    Record record = iSeriesDataStructure.asRecordFormat().getNewRecord(byArray2);
                    for (FieldDescription fieldDescription : record.getRecordFormat().getFieldDescriptions()) {
                        String string = fieldDescription.getFieldName();
                        try {
                            Object object = record.getField(string);
                            this.addDataQueueParameter(string, object);
                        }
                        catch (Exception exception) {
                            logger.warn((Object)"error on fieldname = {}", (Object)string, (Object)exception);
                        }
                    }
                }
                catch (Exception exception) {
                    logger.warn((Object)exception);
                }
            }
        }
        this._parametersUnpacked = true;
    }

    public String toString() {
        return "EsbEvent[" + this.id + ", " + this.fromDatabaseId + ", " + this.toDatabaseId + ", " + this.companyId + ", " + this.divisionId + ", " + this.actionId + ", " + this.formatId + ", " + this.formatVersion + ", " + this.retryCount + ", dq-parms-follow[" + this.getDataQueueParametersAsString() + "]]";
    }

    public void insertParameterDetails() {
        if (!this._parametersUnpacked) {
            this.unpackParameters();
        }
        for (String string : this._runtimeProperties.keySet()) {
            EsbEventParameter esbEventParameter = new EsbEventParameter();
            esbEventParameter.id.set((Object)((Long)this.id.get()));
            esbEventParameter.name.set((Object)string);
            esbEventParameter.value.set((Object)("" + this._runtimeProperties.get(string)));
            CurrentSession.get().insert((Object)esbEventParameter);
        }
    }

    public EndPointTemplate getFromTemplate() {
        if (this._from == null) {
            this._from = new EndPointTemplate((String)this.fromDatabaseId.get(), (String)this.companyId.get(), (String)this.divisionId.get());
        }
        return this._from;
    }

    public EndPointTemplate getToTemplate() {
        if (this._to == null) {
            if (StringX.isBlank((String)((String)this.toDatabaseId.get()))) {
                if (this.getFromTemplate().getDatabase().isEnterprise()) {
                    this.toDatabaseId.set((Object)((String)((Database)this.getCompany().database.get()).id.get()));
                } else {
                    this.toDatabaseId.set((Object)((String)Database.getEnterpriseDatabase().id.get()));
                }
            }
            this._to = new EndPointTemplate((String)this.toDatabaseId.get(), (String)this.companyId.get(), (String)this.divisionId.get());
        }
        return this._to;
    }

    @Override
    public void preInsert() {
        this.insertParameterDetails();
    }

    @Override
    public void preDelete() {
    }

    @Override
    public void preUpdate() {
    }

    @Override
    public void postDelete() {
        this._persisted = false;
    }

    @Override
    public void postInsert() {
        this._persisted = true;
    }

    @Override
    public boolean isPersisted() {
        return this._persisted;
    }

    @Override
    public void postLoad() {
        this._persisted = true;
    }

    @Override
    public void postUpdate() {
    }

    @Override
    public void delete() {
        CurrentSession.get().delete((Object)this);
    }

    @Override
    public void insert() {
        CurrentSession.get().insert((Object)this);
    }

    @Override
    public void refresh() {
        CurrentSession.get().refresh((Object)this, false);
    }

    @Override
    public void update() {
        CurrentSession.get().update((Object)this);
    }

    public Routing getRouting() {
        if (this.getFromTemplate().getDatabase().isEnterprise() && this.getToTemplate().getDatabase().isClient()) {
            return Routing.EntToClient;
        }
        if (this.getFromTemplate().getDatabase().isClient() && this.getToTemplate().getDatabase().isEnterprise()) {
            return Routing.ClientToEnt;
        }
        throw new RuntimeException("unable to determine routing");
    }

    public Database getClientDatabase() {
        if (this.getRouting() == Routing.EntToClient) {
            return this.getToTemplate().getDatabase();
        }
        return this.getFromTemplate().getDatabase();
    }

    public Database getEnterpriseDatabase() {
        if (this.getRouting() == Routing.EntToClient) {
            return this.getFromTemplate().getDatabase();
        }
        return this.getToTemplate().getDatabase();
    }

    public static void main(String[] stringArray) {
        new SimpleLoggingConfigurator().addConsoleAppender();
        new EsbEvent().saveToDisk();
    }

    public Database getFromDatabase() {
        return this.getFromTemplate().getDatabase();
    }
}

