/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.esb;

import com.ahsrcm.corp.beanprops.LazyMapProperty;
import com.ahsrcm.esb.dataqueue.DataQueueFormat;
import com.ahsrcm.esb.synch.Synchronization;
import com.ahsrcm.esb.synch.routing.SynchPer;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import net.java.dev.properties.container.BeanContainer;
import net.model3.collections.ListX;
import net.model3.guice.bootstrap.ConfigurationDirectory;
import net.model3.io.IOHelper;
import net.model3.lang.ClassX;
import net.model3.newfile.Directory;
import net.model3.newfile.File;
import net.model3.xstream.XmlSerializableConfig;

@Singleton
@XStreamAlias(value="esb-configuration")
public class EsbConfiguration
extends XmlSerializableConfig {
    @XStreamImplicit(itemFieldName="dataQueueFormat")
    private List<DataQueueFormat> _dataQueueFormats = ListX.create();
    @XStreamImplicit(itemFieldName="synchronization")
    private List<Synchronization> _synchronizations = ListX.create();
    public final transient LazyMapProperty<String, List<Synchronization>> synchronizationsByFormatId = new LazyMapProperty<String, List<Synchronization>>(){

        @Override
        public void init(Map<String, List<Synchronization>> map) {
            for (Synchronization synchronization : EsbConfiguration.this._synchronizations) {
                List list = map.get(synchronization.getId());
                if (list == null) {
                    list = ListX.create();
                    map.put(synchronization.getId(), list);
                }
                list.add(synchronization);
            }
        }
    };
    public final transient LazyMapProperty<String, DataQueueFormat> dataQueueFormatsByFormatId = new LazyMapProperty<String, DataQueueFormat>(){

        @Override
        public void init(Map<String, DataQueueFormat> map) {
            for (DataQueueFormat dataQueueFormat : EsbConfiguration.this._dataQueueFormats) {
                map.put(dataQueueFormat.getId(), dataQueueFormat);
            }
        }
    };

    @Inject
    public EsbConfiguration(ConfigurationDirectory configurationDirectory) {
        BeanContainer.bind((Object)((Object)this));
        InputStream inputStream = ClassX.getResourceAsStream((String)"esb-config-default.xml");
        String string = IOHelper.readFully((Reader)new InputStreamReader(inputStream));
        File file = new File((Directory)configurationDirectory.get(), "esb-config.xml");
        File file2 = new File((Directory)configurationDirectory.get(), "esb-config.xml.sample");
        if (file.exists()) {
            this.load(file);
        } else {
            this.loadFromXml(string);
        }
        file2.write(string);
    }

    public EsbConfiguration() {
        BeanContainer.bind((Object)((Object)this));
    }

    public List<Synchronization> getSynchronizations() {
        return this._synchronizations;
    }

    public List<Synchronization> getSyncronizations(String string) {
        List list = ListX.create();
        for (Synchronization synchronization : this._synchronizations) {
            list.add(synchronization);
        }
        return list;
    }

    public void addRecordSynch(Synchronization synchronization) {
        this._synchronizations.add(synchronization);
    }

    public List<DataQueueFormat> getDataQueueFormats() {
        return this._dataQueueFormats;
    }

    public DataQueueFormat addDataQueueFormat(String string) {
        DataQueueFormat dataQueueFormat = new DataQueueFormat(string);
        this._dataQueueFormats.add(dataQueueFormat);
        return dataQueueFormat;
    }

    public XStream createXStreamer() {
        XStream xStream = new XStream();
        xStream.processAnnotations(((Object)((Object)this)).getClass());
        xStream.registerConverter((SingleValueConverter)new AbstractSingleValueConverter(){

            public boolean canConvert(Class clazz) {
                return clazz.equals(SynchPer.class);
            }

            public Object fromString(String string) {
                return SynchPer.valueOf(string);
            }

            public String toString(Object object) {
                return object.toString();
            }
        });
        return xStream;
    }

    protected void loadFromXmlImpl(String string, String string2) {
        super.loadFromXmlImpl(string, string2);
        for (Synchronization synchronization : this._synchronizations) {
            synchronization.init();
        }
    }
}

