/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.esb;

import com.ahsrcm.corp.Database;
import com.ahsrcm.corp.Division;
import com.ahsrcm.corp.cdl.CDLEntity;
import com.ahsrcm.esb.ConnectionManager;
import com.ahsrcm.esb.synch.TableInfo;
import com.ahsrcm.esb.synch.routing.EndPoint;
import com.ibm.as400.access.AS400;
import com.ibm.as400.access.CommandCall;
import java.sql.Connection;
import java.util.Map;
import net.java.dev.properties.jdbc.UpdateQuery;
import net.model3.collections.GeneratedMap;
import net.model3.guice.DependencyInjector;
import net.model3.jdbc.JdbcHelper;
import net.model3.lang.ExceptionPropagator;
import net.model3.lang.Pair;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;

public final class ConnectionTransaction {
    static final Logger logger = LoggerHelper.getLogger();
    Map<Database, Connection> _connectionMap = new GeneratedMap<Database, Connection>(){

        public Connection generate(Database database) {
            return ConnectionTransaction.this._connectionManager.getConnection(database);
        }
    };
    Map<Database, AS400> _as400Map = new GeneratedMap<Database, AS400>(){

        public AS400 generate(Database database) {
            return ConnectionTransaction.this._connectionManager.getAS400Connection(database);
        }
    };
    ConnectionManager _connectionManager;

    public static ConnectionTransaction get() {
        return (ConnectionTransaction)DependencyInjector.getInstance(ConnectionTransaction.class);
    }

    public void setConnectionManager(ConnectionManager connectionManager) {
        this._connectionManager = connectionManager;
    }

    public void rollback(Throwable throwable) {
        for (Map.Entry<Database, Connection> entry : this._connectionMap.entrySet()) {
            try {
                entry.getValue().rollback();
            }
            catch (Exception exception) {
                logger.debug((Object)"error rolling back connection to {}", (Object)entry.getKey(), (Object)throwable);
            }
        }
    }

    public void runCommand(Database database, String string) {
        try {
            AS400 aS400 = this.getAS400Connection(database);
            CommandCall commandCall = new CommandCall(aS400, string);
            boolean bl = commandCall.run();
            if (!bl) {
                throw new RuntimeException("command '" + string + "' run on " + database + " failed.");
            }
        }
        catch (Exception exception) {
            throw ExceptionPropagator.throwUnchecked((Throwable)exception);
        }
    }

    public void commit() {
        for (Map.Entry<Database, Connection> entry : this._connectionMap.entrySet()) {
            try {
                entry.getValue().commit();
            }
            catch (Exception exception) {
                logger.debug((Object)"error rolling back connection to {}", (Object)entry.getKey(), (Object)exception);
            }
        }
    }

    public Connection getConnection(Database database) {
        return this._connectionMap.get(database);
    }

    public Connection getConnection(EndPoint endPoint) {
        return this.getConnection(endPoint.getDatabase());
    }

    public AS400 getAS400Connection(Database database) {
        AS400 aS400 = this._connectionManager.getAS400Connection(database);
        this._as400Map.put(database, aS400);
        return aS400;
    }

    protected void cleanup(Throwable throwable) {
        logger.debug((Object)"cleaning up");
        if (throwable != null) {
            this.commit();
        } else {
            this.rollback(throwable);
        }
        for (Connection object : this._connectionMap.values()) {
            JdbcHelper.close((Connection)object);
        }
        for (Map.Entry entry : this._as400Map.entrySet()) {
            this._connectionManager.returnAS400Connection((Database)entry.getKey(), (AS400)entry.getValue());
        }
    }

    public String getAlias(String string, Division division) {
        return this.getAlias(string, division.getCDLEntity());
    }

    public Pair<String, String> getCreateAliasSQL(String string, CDLEntity cDLEntity) {
        TableInfo tableInfo = this._connectionManager._tableInfoPlugin.getTableInfo(string, cDLEntity.getDatabase());
        if (tableInfo.overrideDatabaseFileNeeded()) {
            Division division = cDLEntity.getDivision();
            if (division == null) {
                throw new RuntimeException("override error.  table " + string + " needs an override but cdl " + cDLEntity + " has no division");
            }
            Connection connection = this.getConnection(cDLEntity.getDatabase());
            String string2 = tableInfo.getMemberName(division, connection);
            String string3 = "QTEMP/" + string + "_" + cDLEntity.getCompanyId() + "_" + cDLEntity.getDivisionId();
            return Pair.create((Object)string3, (Object)("create alias " + string3 + " for " + (String)division.getDatabase().library.get() + "/" + string + "(" + string2 + ")"));
        }
        return null;
    }

    public String getAlias(String string, CDLEntity cDLEntity) {
        TableInfo tableInfo = this._connectionManager._tableInfoPlugin.getTableInfo(string, cDLEntity.getDatabase());
        Pair<String, String> pair = this.getCreateAliasSQL(string, cDLEntity);
        if (pair != null) {
            try {
                Connection connection = this.getConnection(cDLEntity.getDatabase());
                new UpdateQuery((String)pair.getRight(), connection).execute();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return (String)pair.getLeft();
        }
        return string;
    }
}

