/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.esb;

import com.ahsrcm.core.transaction.AhsTransactionManager;
import com.ahsrcm.corp.Database;
import com.ahsrcm.corp.ISeries;
import com.ahsrcm.esb.ConnectionTransaction;
import com.ahsrcm.esb.synch.TableInfoPlugin;
import com.ahsrcm.esb.synch.routing.EndPoint;
import com.ahsrcm.scanning.app.server.ServerAppConfig;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.ibm.as400.access.AS400;
import com.ibm.as400.access.CommandCall;
import java.sql.Connection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import net.model3.collections.ListX;
import net.model3.collections.MapX;
import net.model3.lang.ExceptionPropagator;
import net.model3.lang.TimeDuration;
import net.model3.logging.Log;
import net.model3.logging.LogHelper;
import net.model3.transaction.Transaction;
import net.model3.transaction.TransactionManager;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.pool.BasePoolableObjectFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;

@Singleton
public class ConnectionManager {
    private static final Log logger = LogHelper.getLog();
    Map<String, DataSource> _databaseIdToDataSourceMap = new ConcurrentHashMap<String, DataSource>();
    Map<String, ObjectPool> _as400ToolboxConnectionPools = MapX.create();
    @Inject
    AhsTransactionManager _transactionManager;
    @Inject
    DataSource _enterpriseDataSource;
    @Inject
    TableInfoPlugin _tableInfoPlugin;
    @Inject
    ServerAppConfig _config;

    @Inject
    private ConnectionManager() {
    }

    public DataSource getDataSource(Database database) {
        DataSource dataSource = this._databaseIdToDataSourceMap.get(database.id.get());
        if (dataSource == null) {
            dataSource = database.isEnterprise() && this._config.usingDeveloperDatabase() ? this._enterpriseDataSource : database.createDataSource();
            this._databaseIdToDataSourceMap.put((String)database.id.get(), dataSource);
        }
        return dataSource;
    }

    Connection getConnection(Database database) {
        if (database == null) {
            throw new NullPointerException("database must not be null");
        }
        try {
            return this.getDataSource(database).getConnection();
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap((String)("unable to obtain connection to database " + (String)database.id.get()), (Throwable)exception);
        }
    }

    Connection getConnection(EndPoint endPoint) {
        try {
            return this.getConnection(endPoint.getDatabase());
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap((Throwable)exception);
        }
    }

    AS400 getAS400Connection(Database database) {
        try {
            return (AS400)this.getAS400ConnectionPool(database).borrowObject();
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap((Throwable)exception);
        }
    }

    void returnAS400Connection(Database database, AS400 aS400) {
        try {
            if (database != null && aS400 != null) {
                this.getAS400ConnectionPool(database).returnObject((Object)aS400);
            }
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap((Throwable)exception);
        }
    }

    ObjectPool getAS400ConnectionPool(final Database database) {
        GenericObjectPool genericObjectPool = (GenericObjectPool)this._as400ToolboxConnectionPools.get(database.id.get());
        if (genericObjectPool == null) {
            final String string = (String)database.id.get();
            genericObjectPool = new GenericObjectPool();
            GenericObjectPool.Config config = new GenericObjectPool.Config();
            config.maxActive = 10;
            config.minIdle = 0;
            config.testOnBorrow = true;
            config.testWhileIdle = true;
            config.testOnReturn = true;
            config.numTestsPerEvictionRun = 100;
            config.minEvictableIdleTimeMillis = new TimeDuration("15 minutes").inMilliseconds();
            config.timeBetweenEvictionRunsMillis = new TimeDuration("15 minutes").inMilliseconds();
            config.maxWait = new TimeDuration("10 seconds").inMilliseconds();
            genericObjectPool.setConfig(config);
            genericObjectPool.setFactory((PoolableObjectFactory)new BasePoolableObjectFactory(){

                public void destroyObject(Object object) throws Exception {
                    logger.debug((Object)"destroying connection to {}", (Object)database.getDnsName());
                    ((AS400)object).disconnectAllServices();
                }

                public boolean validateObject(Object object) {
                    boolean bl;
                    logger.debug((Object)"validating connection {} to {}", object, (Object)database.getDnsName());
                    CommandCall commandCall = null;
                    try {
                        commandCall = new CommandCall((AS400)object, "CHGLIB LIB(QTEMP)");
                        bl = commandCall.run();
                    }
                    catch (Exception exception) {
                        logger.warn((Object)"connection validation failed", (Object)exception);
                        bl = false;
                    }
                    if (!bl) {
                        logger.warn((Object)"connection to {} failed validation", (Object)string);
                    }
                    return bl;
                }

                public Object makeObject() throws Exception {
                    ISeries iSeries = (ISeries)database.iSeries.get();
                    String string4 = ((String)iSeries.user.get()).trim();
                    String string2 = ((String)iSeries.password.get()).trim();
                    AS400 aS400 = new AS400(database.getDnsName(), string4, string2);
                    logger.debug((Object)"created connection {} to {}", (Object)aS400, (Object)database.getDnsName());
                    CommandCall commandCall = new CommandCall(aS400);
                    commandCall.run("CHGLIBL LIBL(*NONE)");
                    for (String string3 : database.getLibraryList()) {
                        boolean bl = commandCall.run("ADDLIBLE " + string3);
                        if (!bl) continue;
                        logger.debug((Object)"adding library {} to {}", (Object)string3, (Object)aS400);
                    }
                    return aS400;
                }
            });
            this._as400ToolboxConnectionPools.put((String)database.id.get(), (ObjectPool)genericObjectPool);
        }
        return genericObjectPool;
    }

    public void shutdown() {
        for (String string : ListX.create(this._as400ToolboxConnectionPools.keySet())) {
            logger.debug((Object)"shutting down as400 pool {}", (Object)string);
            try {
                this._as400ToolboxConnectionPools.get(string).close();
            }
            catch (Exception exception) {
                logger.warn((Object)"error shutting down as400 pool for {}", (Object)string, (Object)exception);
            }
        }
        for (String string : ListX.create(this._databaseIdToDataSourceMap.keySet())) {
            logger.debug((Object)"shutting down jdbc data source {}", (Object)string);
            try {
                ((BasicDataSource)this._databaseIdToDataSourceMap.get(string)).close();
            }
            catch (Exception exception) {
                logger.warn((Object)"error shutting down jdbc pool for {}", (Object)string, (Object)exception);
            }
        }
    }

    public ConnectionTransaction createTransaction() {
        final ConnectionTransaction connectionTransaction = new ConnectionTransaction();
        TransactionManager.getTransaction().events().addListener((Object)new Transaction.Adapter(){

            public void rollback(Transaction transaction, Throwable throwable) {
                if (throwable == null) {
                    throwable = new Throwable();
                }
                connectionTransaction.cleanup(throwable);
            }

            public void finally_(Transaction transaction) {
            }

            public void commit(Transaction transaction) {
                connectionTransaction.cleanup(null);
            }
        });
        connectionTransaction.setConnectionManager(this);
        return connectionTransaction;
    }
}

