/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.corp.rules;

import com.ahsrcm.corp.BaseBusinessBeanWithStatus;
import com.ahsrcm.corp.rules.StageTransition;
import com.ahsrcm.corp.rules.UserRole;
import com.ahsrcm.datamodel.StaticDropdown;
import com.ahsrcm.scanning.dao.DaoRetriever;
import com.ahsrcm.scanning.dao.ScanningDao;
import java.util.Collections;
import java.util.List;
import net.java.dev.properties.IndexedProperty;
import net.java.dev.properties.LazyIndexedProperty;
import net.java.dev.properties.Property;
import net.java.dev.properties.RProperty;
import net.java.dev.properties.RPropertyImpl;
import net.java.dev.properties.annotations.Bidirectional;
import net.java.dev.properties.annotations.Column;
import net.java.dev.properties.annotations.Table;
import net.java.dev.properties.container.BeanContainer;
import net.java.dev.properties.container.BeanContext;
import net.java.dev.properties.container.IPropertyContext;
import net.java.dev.properties.container.ObservableIndexed;
import net.java.dev.properties.container.ObservableProperty;
import net.java.dev.properties.container.PropertyContextable;
import net.java.dev.properties.jdbc.CurrentSession;
import net.java.dev.properties.jdbc.Query;
import net.java.dev.properties.util.BeanComparator;
import net.model3.collections.ListX;
import net.model3.guice.DependencyInjector;

@StaticDropdown
@Table(name="ESPSTG", prefix="ES", useDirtyChecking=false)
public class Stage
extends BaseBusinessBeanWithStatus<Stage> {
    private static final long serialVersionUID = -2575038251240839819L;
    public static final DaoRetriever<Stage> ScanningInProgress = DaoRetriever.create(Stage.class, "10");
    public static final DaoRetriever<Stage> Ocr = DaoRetriever.create(Stage.class, "15");
    public static final DaoRetriever<Stage> IndexDocuments = DaoRetriever.create(Stage.class, "20");
    public static final DaoRetriever<Stage> CodingQueue = DaoRetriever.create(Stage.class, "30");
    public static final DaoRetriever<Stage> ReworkOut = DaoRetriever.create(Stage.class, "40");
    public static final DaoRetriever<Stage> ReworkIn = DaoRetriever.create(Stage.class, "50");
    public static final DaoRetriever<Stage> DataEntryQueue = DaoRetriever.create(Stage.class, "60");
    public static final DaoRetriever<Stage> Concurrency = DaoRetriever.create(Stage.class, "65");
    public static final DaoRetriever<Stage> DataEntryComplete = DaoRetriever.create(Stage.class, "70");
    public static final DaoRetriever<Stage> Canceled = DaoRetriever.create(Stage.class, "99");
    @Column(suffix="STG", key=true, length=2L)
    public final Property<String> id = ObservableProperty.create();
    @Column(suffix="D40", length=40L)
    public final Property<String> description = ObservableProperty.create();
    public final transient RProperty<String> visualId = new RPropertyImpl<String>(){
        private static final long serialVersionUID = 7984392125308650701L;

        public String get() {
            return (String)Stage.this.id.get() + " - " + (String)Stage.this.description.get();
        }
    };
    @Column(suffix="D15", length=2L)
    public final Property<String> briefDescription = ObservableProperty.create();
    @Bidirectional(value="stage-transitions", parent=true)
    public final ObservableIndexed<StageTransition> transitions = ObservableIndexed.create();
    public final transient IndexedProperty<Stage> allowedToStages = new LazyIndexedProperty<Stage>(){

        public void init(List<Stage> list) {
            for (StageTransition stageTransition : Stage.this.transitions) {
                list.add((Stage)stageTransition.to.get());
            }
        }
    };
    private transient List<UserRole> _allowedRoles;
    public static final BeanContext $BeanContext = (BeanContext)BeanContainer.get().getContext(Stage.class);
    public static final IPropertyContext $visualId = $BeanContext.getProperty("visualId");
    public static final IPropertyContext $creationUser = $BeanContext.getProperty("creationUser");
    public static final IPropertyContext $creationDate = $BeanContext.getProperty("creationDate");
    public static final IPropertyContext $creationTime = $BeanContext.getProperty("creationTime");
    public static final IPropertyContext $lastChangeUser = $BeanContext.getProperty("lastChangeUser");
    public static final IPropertyContext $lastChangeDate = $BeanContext.getProperty("lastChangeDate");
    public static final IPropertyContext $lastChangeTime = $BeanContext.getProperty("lastChangeTime");
    public static final IPropertyContext $creationTimestamp = $BeanContext.getProperty("creationTimestamp");
    public static final IPropertyContext $lastChangeTimestamp = $BeanContext.getProperty("lastChangeTimestamp");
    public static final IPropertyContext $status = $BeanContext.getProperty("status");
    public static final IPropertyContext $id = $BeanContext.getProperty("id");
    public static final IPropertyContext $description = $BeanContext.getProperty("description");
    public static final IPropertyContext $briefDescription = $BeanContext.getProperty("briefDescription");
    public static final IPropertyContext $transitions = $BeanContext.getProperty("transitions");
    public static final IPropertyContext $allowedToStages = $BeanContext.getProperty("allowedToStages");
    public static final Stage Meta = new Stage();

    public static List<Stage> getSortedStages() {
        List list = ListX.create(Stage.selectAll());
        Collections.sort(list, BeanComparator.create((PropertyContextable[])new PropertyContextable[]{$id}));
        return list;
    }

    public Stage() {
        BeanContainer.bind((Object)this);
    }

    int idAsInt() {
        return Integer.parseInt((String)this.id.get());
    }

    public boolean lessThanOrEqual(Stage stage) {
        int n;
        int n2 = this.idAsInt();
        return n2 <= (n = stage.idAsInt());
    }

    public List<UserRole> getAllowedRoles() {
        if (this._allowedRoles != null) {
            return this._allowedRoles;
        }
        List list = ListX.create();
        String string = (String)this.id.get();
        if (string.equals(Stage.ScanningInProgress.get().id.get())) {
            list.add(UserRole.Scanner.get());
            list.add(UserRole.CodingManager.get());
        } else if (string.equals(Stage.IndexDocuments.get().id.get())) {
            list.addAll(UserRole.getAllRoles());
        } else if (string.equals(Stage.CodingQueue.get().id.get())) {
            list.add(UserRole.Coder.get());
            list.add(UserRole.CodingManager.get());
        } else if (string.equals(Stage.ReworkOut.get().id.get())) {
            list.add(UserRole.CodingManager.get());
            list.add(UserRole.Coder.get());
            list.add(UserRole.DataEntryManager.get());
        } else if (string.equals(Stage.ReworkIn.get().id.get())) {
            list.add(UserRole.CodingManager.get());
            list.add(UserRole.DataEntryManager.get());
            list.add(UserRole.Coder.get());
        } else if (string.equals(Stage.Concurrency.get().id.get())) {
            list.add(UserRole.CodingManager.get());
            list.add(UserRole.DataEntryManager.get());
            list.add(UserRole.Coder.get());
        } else if (string.equals(Stage.DataEntryQueue.get().id.get())) {
            list.add(UserRole.DataEntryUser.get());
            list.add(UserRole.DataEntryManager.get());
        }
        this._allowedRoles = list;
        return this._allowedRoles;
    }

    @Override
    public String toString() {
        return (String)this.id.get() + " - " + (String)this.briefDescription.get();
    }

    @Override
    public String getVisualId() {
        return (String)this.id.get() + " - " + (String)this.description.get();
    }

    public String getId() {
        return (String)this.id.get();
    }

    public void setId(String string) {
        this.id.set((Object)string);
    }

    public String getDescription() {
        return (String)this.description.get();
    }

    public void setDescription(String string) {
        this.description.set((Object)string);
    }

    public String getBriefDescription() {
        return (String)this.briefDescription.get();
    }

    public void setBriefDescription(String string) {
        this.briefDescription.set((Object)string);
    }

    public List<StageTransition> getTransitions() {
        return this.transitions.get();
    }

    public void setTransitions(List<StageTransition> list) {
        this.transitions.set(list);
    }

    public List<Stage> getAllowedToStages() {
        return (List)this.allowedToStages.get();
    }

    public void setAllowedToStages(List<Stage> list) {
        this.allowedToStages.set(list);
    }

    public void setAllowedRoles(List<UserRole> list) {
        this._allowedRoles = list;
    }

    public static Stage fetchByPk(String string) {
        return (Stage)CurrentSession.get().fetchByPK(Stage.class, new Object[]{string});
    }

    public static Query<Stage> select(String string, Object ... objectArray) {
        return CurrentSession.get().select(Stage.class, string, objectArray);
    }

    public static List<Stage> selectAll() {
        return ((ScanningDao)DependencyInjector.getInstance(ScanningDao.class)).selectAll(Stage.class);
    }

    public static Stage fetch(String string, Object ... objectArray) {
        return (Stage)ListX.getFirst(Stage.select(string, objectArray));
    }
}

