/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.corp.rules;

import com.ahsrcm.corp.BaseBusinessBeanWithStatus;
import com.ahsrcm.corp.BatchType;
import com.ahsrcm.corp.beanprops.LazyMapProperty;
import com.ahsrcm.corp.cdl.CDLEntity;
import com.ahsrcm.corp.cdl.CDLFactory;
import com.ahsrcm.corp.rules.Rule;
import com.ahsrcm.corp.rules.Stage;
import com.ahsrcm.scanning.dao.ScanningDao;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.java.dev.properties.IndexedProperty;
import net.java.dev.properties.LazyIndexedProperty;
import net.java.dev.properties.annotations.Bidirectional;
import net.java.dev.properties.annotations.Column;
import net.java.dev.properties.annotations.Table;
import net.java.dev.properties.container.BeanContainer;
import net.java.dev.properties.container.BeanContext;
import net.java.dev.properties.container.IPropertyContext;
import net.java.dev.properties.container.ObservableIndexed;
import net.java.dev.properties.container.ObservableProperty;
import net.java.dev.properties.container.PropertyContextable;
import net.java.dev.properties.jdbc.CurrentSession;
import net.java.dev.properties.jdbc.Query;
import net.java.dev.properties.util.BeanComparator;
import net.model3.collections.ListX;
import net.model3.guice.DependencyInjector;
import net.model3.logging.Log;
import net.model3.logging.LogHelper;

@Table(name="ESPRULEH", prefix="EY", useDirtyChecking=false)
public class RuleSet
extends BaseBusinessBeanWithStatus<RuleSet> {
    private static final Log logger = LogHelper.getLog();
    private static final long serialVersionUID = 6743751314189146835L;
    @Column(suffix="CMP", key=true, length=4L)
    public final ObservableProperty<String> companyId = ObservableProperty.create();
    @Column(suffix="DIV", key=true, length=4L)
    public final ObservableProperty<String> divisionId = ObservableProperty.create();
    @Column(suffix="LOS", key=true, length=4L)
    public final ObservableProperty<String> locationId = ObservableProperty.create();
    @Column(suffix="BTP", key=true)
    public final ObservableProperty<BatchType> batchType = ObservableProperty.create();
    @Column(suffix="D40", length=40L)
    public final ObservableProperty<String> description = ObservableProperty.create();
    @Bidirectional(value="rules", parent=true)
    public final ObservableIndexed<Rule> rules = ObservableIndexed.create();
    public final transient LazyMapProperty<Stage, Rule> rulesByStage = new LazyMapProperty<Stage, Rule>(){
        private static final long serialVersionUID = -4191869198593718172L;

        @Override
        public void init(Map<Stage, Rule> map) {
            for (Rule rule : RuleSet.this.rules) {
                map.put((Stage)rule.stage.get(), rule);
            }
        }
    };
    public final transient IndexedProperty<Rule> rulesBySequence = new LazyIndexedProperty<Rule>(){
        private static final long serialVersionUID = -4961197847436288685L;

        public List<Rule> init() {
            List list = ListX.create(RuleSet.this.rules);
            Rule rule = new Rule();
            Collections.sort(list, BeanComparator.create((PropertyContextable[])new PropertyContextable[]{rule.sequence}));
            return list;
        }
    };
    public static final BeanContext $BeanContext = (BeanContext)BeanContainer.get().getContext(RuleSet.class);
    public static final IPropertyContext $visualId = $BeanContext.getProperty("visualId");
    public static final IPropertyContext $creationUser = $BeanContext.getProperty("creationUser");
    public static final IPropertyContext $creationDate = $BeanContext.getProperty("creationDate");
    public static final IPropertyContext $creationTime = $BeanContext.getProperty("creationTime");
    public static final IPropertyContext $lastChangeUser = $BeanContext.getProperty("lastChangeUser");
    public static final IPropertyContext $lastChangeDate = $BeanContext.getProperty("lastChangeDate");
    public static final IPropertyContext $lastChangeTime = $BeanContext.getProperty("lastChangeTime");
    public static final IPropertyContext $creationTimestamp = $BeanContext.getProperty("creationTimestamp");
    public static final IPropertyContext $lastChangeTimestamp = $BeanContext.getProperty("lastChangeTimestamp");
    public static final IPropertyContext $status = $BeanContext.getProperty("status");
    public static final IPropertyContext $companyId = $BeanContext.getProperty("companyId");
    public static final IPropertyContext $divisionId = $BeanContext.getProperty("divisionId");
    public static final IPropertyContext $locationId = $BeanContext.getProperty("locationId");
    public static final IPropertyContext $batchType = $BeanContext.getProperty("batchType");
    public static final IPropertyContext $description = $BeanContext.getProperty("description");
    public static final IPropertyContext $rules = $BeanContext.getProperty("rules");
    public static final IPropertyContext $rulesByStage = $BeanContext.getProperty("rulesByStage");
    public static final IPropertyContext $rulesBySequence = $BeanContext.getProperty("rulesBySequence");
    public static final RuleSet Meta = new RuleSet();

    public RuleSet() {
        BeanContainer.bind((Object)this);
    }

    public CDLEntity getCDLEntity() {
        return CDLFactory.get().getCDL((String)this.companyId.get(), (String)this.divisionId.get(), (String)this.locationId.get());
    }

    public static RuleSet getDefaultRuleSet(BatchType batchType) {
        logger.warn((Object)"creating default rule set for {}", (Object)batchType);
        RuleSet ruleSet = new RuleSet();
        ruleSet.batchType.set((Object)batchType);
        for (Stage stage : CurrentSession.get().selectAll(Stage.class)) {
            Rule rule = new Rule();
            ruleSet.rules.add((Object)rule);
            rule.stage.set((Object)stage);
            rule.required.set((Object)true);
            rule.sequence.set((Object)Short.parseShort((String)stage.id.get()));
        }
        return ruleSet;
    }

    public boolean isCodingRequired() {
        Rule rule = this.rulesByStage.get(Stage.CodingQueue.get());
        if (rule == null) {
            return false;
        }
        return (Boolean)rule.required.get();
    }

    public Rule getPostScanningRule() {
        Rule rule = this.rulesByStage.get(Stage.ScanningInProgress.get());
        Rule rule2 = null;
        if (rule != null) {
            rule2 = rule.nextRequiredRule();
            if (rule2 == null) {
                rule2 = rule.nextRule();
            }
            if (rule2 == null) {
                rule2 = rule;
            }
        }
        return rule2;
    }

    public static RuleSet fetch(CDLEntity cDLEntity, BatchType batchType) {
        for (CDLEntity cDLEntity2 : cDLEntity.getEntityChain(true)) {
            for (RuleSet ruleSet : RuleSet.selectAll()) {
                if (!((BatchType)ruleSet.batchType.get()).equals(batchType) || !cDLEntity2.equals(ruleSet.getCDLEntity())) continue;
                return ruleSet;
            }
        }
        return null;
    }

    public String getCompanyId() {
        return (String)this.companyId.get();
    }

    public void setCompanyId(String string) {
        this.companyId.set((Object)string);
    }

    public String getDivisionId() {
        return (String)this.divisionId.get();
    }

    public void setDivisionId(String string) {
        this.divisionId.set((Object)string);
    }

    public String getLocationId() {
        return (String)this.locationId.get();
    }

    public void setLocationId(String string) {
        this.locationId.set((Object)string);
    }

    public BatchType getBatchType() {
        return (BatchType)this.batchType.get();
    }

    public void setBatchType(BatchType batchType) {
        this.batchType.set((Object)batchType);
    }

    public String getDescription() {
        return (String)this.description.get();
    }

    public void setDescription(String string) {
        this.description.set((Object)string);
    }

    public List<Rule> getRules() {
        return this.rules.get();
    }

    public void setRules(List<Rule> list) {
        this.rules.set(list);
    }

    public Map<Stage, Rule> getRulesByStage() {
        return this.rulesByStage.get();
    }

    public void setRulesByStage(Map<Stage, Rule> map) {
        this.rulesByStage.set(map);
    }

    public List<Rule> getRulesBySequence() {
        return (List)this.rulesBySequence.get();
    }

    public void setRulesBySequence(List<Rule> list) {
        this.rulesBySequence.set(list);
    }

    public static RuleSet fetchByPk(String string, String string2, String string3, String string4) {
        return (RuleSet)CurrentSession.get().fetchByPK(RuleSet.class, new Object[]{string, string2, string3, string4});
    }

    public static Query<RuleSet> select(String string, Object ... objectArray) {
        return CurrentSession.get().select(RuleSet.class, string, objectArray);
    }

    public static List<RuleSet> selectAll() {
        return ((ScanningDao)DependencyInjector.getInstance(ScanningDao.class)).selectAll(RuleSet.class);
    }

    public static RuleSet fetch(String string, Object ... objectArray) {
        return (RuleSet)ListX.getFirst(RuleSet.select(string, objectArray));
    }
}

